/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.time.Instant;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;

public final class TemporalAccessor {
    public final int dimension;
    public final DefaultTemporalCRS timeCRS;

    private TemporalAccessor(int n, TemporalCRS temporalCRS) {
        this.dimension = n;
        this.timeCRS = DefaultTemporalCRS.castOrCopy(temporalCRS);
    }

    public static TemporalAccessor of(CoordinateReferenceSystem coordinateReferenceSystem, int n) {
        if (coordinateReferenceSystem instanceof TemporalCRS) {
            return new TemporalAccessor(n, (TemporalCRS)coordinateReferenceSystem);
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : ((CompoundCRS)coordinateReferenceSystem).getComponents()) {
                TemporalAccessor temporalAccessor = TemporalAccessor.of(coordinateReferenceSystem2, n);
                if (temporalAccessor != null) {
                    return temporalAccessor;
                }
                n += ReferencingUtilities.getDimension(coordinateReferenceSystem2);
            }
        }
        return null;
    }

    public Instant[] getTimeRange(AbstractEnvelope abstractEnvelope) {
        Instant instant = this.timeCRS.toInstant(abstractEnvelope.getLower(this.dimension));
        Instant instant2 = this.timeCRS.toInstant(abstractEnvelope.getUpper(this.dimension));
        if (instant == null) {
            instant = instant2;
            instant2 = null;
        }
        Instant[] instantArray = new Instant[instant2 != null ? 2 : (instant != null ? 1 : 0)];
        switch (instantArray.length) {
            default: {
                instantArray[1] = instant2;
            }
            case 1: {
                instantArray[0] = instant;
            }
            case 0: 
        }
        return instantArray;
    }
}

