/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.channel;

import groovy.text.GStringTemplateEngine;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.lifecycle.AbstractNotificationLifecycle;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class ChannelManagerImpl
implements ChannelManager,
Startable {
    private static final Log LOG = ExoLogger.getLogger(ChannelManagerImpl.class);
    private final Map<ChannelKey, AbstractChannel> channels = new HashMap<ChannelKey, AbstractChannel>();
    private List<TemplateProvider> providers = new LinkedList<TemplateProvider>();
    private GStringTemplateEngine gTemplateEngine = new GStringTemplateEngine();

    public void register(AbstractChannel channel) {
        this.channels.put(ChannelKey.key((String)channel.getId()), channel);
    }

    public void unregister(AbstractChannel channel) {
        this.channels.remove(channel.getId());
    }

    public void registerTemplateProvider(TemplateProvider provider) {
        this.providers.add(provider);
    }

    public void registerOverrideTemplateProvider(TemplateProvider provider) {
        this.providers.add(provider);
        AbstractChannel channel = this.channels.get(provider.getChannelKey());
        if (channel != null) {
            channel.registerTemplateProvider(this.addTemplateEngine(provider));
        } else {
            LOG.warn((Object)"Register the new TemplateProvider is unsucessful");
        }
    }

    public AbstractChannel getChannel(ChannelKey key) {
        return this.channels.get(key);
    }

    public AbstractNotificationLifecycle getLifecycle(ChannelKey key) {
        return this.getChannel(key).getLifecycle();
    }

    public int sizeChannels() {
        return this.channels.size();
    }

    public List<AbstractChannel> getChannels() {
        LinkedList<AbstractChannel> channels = new LinkedList<AbstractChannel>();
        AbstractChannel emailChannel = this.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        if (emailChannel != null) {
            channels.add(emailChannel);
        }
        for (AbstractChannel channel : this.channels.values()) {
            if ("MAIL_CHANNEL".equals(channel.getId())) continue;
            channels.add(channel);
        }
        return Collections.unmodifiableList(channels);
    }

    public void start() {
        for (TemplateProvider provider : this.providers) {
            AbstractChannel channel = this.channels.get(provider.getChannelKey());
            if (channel != null) {
                channel.registerTemplateProvider(this.addTemplateEngine(provider));
                continue;
            }
            LOG.warn((Object)"Register the new TemplateProvider is unsucessful");
        }
    }

    public void stop() {
    }

    private TemplateProvider addTemplateEngine(TemplateProvider provider) {
        Map builders = provider.getTemplateBuilder();
        Map configs = provider.getTemplateFilePathConfigs();
        for (PluginKey plugin : configs.keySet()) {
            String templatePath = (String)configs.get(plugin);
            if (templatePath == null || templatePath.length() <= 0) continue;
            try {
                AbstractTemplateBuilder builder = (AbstractTemplateBuilder)builders.get(plugin);
                if (builder == null) continue;
                String template = TemplateUtils.loadGroovyTemplate(templatePath);
                builder.setTemplateEngine(this.gTemplateEngine.createTemplate(template));
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to build groovy template engine for: " + plugin.getId() + " templatePath: " + templatePath), (Throwable)e);
            }
        }
        return provider;
    }
}

