/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.io.Closeable;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.internal.feature.Resources;

public abstract class WritablePixelIterator
extends PixelIterator
implements Closeable {
    final WritableRenderedImage destination;
    WritableRaster destRaster;

    WritablePixelIterator(Raster raster, WritableRaster writableRaster, Rectangle rectangle, Dimension dimension) {
        super(raster, rectangle, dimension);
        this.destRaster = writableRaster;
        this.destination = null;
        if (writableRaster != null) {
            if (!raster.getSampleModel().equals(writableRaster.getSampleModel())) {
                throw new IllegalArgumentException(Resources.format((short)41));
            }
            if (!raster.getBounds().equals(writableRaster.getBounds())) {
                throw new IllegalArgumentException(Resources.format((short)40));
            }
        }
    }

    WritablePixelIterator(RenderedImage renderedImage, WritableRenderedImage writableRenderedImage, Rectangle rectangle, Dimension dimension) {
        super(renderedImage, rectangle, dimension);
        this.destRaster = null;
        this.destination = writableRenderedImage;
        if (writableRenderedImage != null) {
            if (!renderedImage.getSampleModel().equals(writableRenderedImage.getSampleModel())) {
                throw new IllegalArgumentException(Resources.format((short)41));
            }
            if (renderedImage.getMinX() != writableRenderedImage.getMinX() || renderedImage.getMinY() != writableRenderedImage.getMinY() || renderedImage.getWidth() != writableRenderedImage.getWidth() || renderedImage.getHeight() != writableRenderedImage.getHeight()) {
                throw new IllegalArgumentException(Resources.format((short)40));
            }
            if (renderedImage.getMinTileX() != writableRenderedImage.getMinTileX() || renderedImage.getMinTileY() != writableRenderedImage.getMinTileY() || renderedImage.getTileWidth() != writableRenderedImage.getTileWidth() || renderedImage.getTileHeight() != writableRenderedImage.getTileHeight()) {
                throw new IllegalArgumentException(Resources.format((short)42));
            }
        }
    }

    public static WritablePixelIterator create(WritableRenderedImage writableRenderedImage) {
        return new PixelIterator.Builder().createWritable(writableRenderedImage);
    }

    @Override
    public boolean isWritable() {
        return this.destination != null || this.destRaster != null;
    }

    public abstract void setSample(int var1, int var2);

    public abstract void setSample(int var1, float var2);

    public abstract void setSample(int var1, double var2);

    public abstract void setPixel(int[] var1);

    public abstract void setPixel(float[] var1);

    public abstract void setPixel(double[] var1);

    @Override
    public abstract void close();
}

