/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.registry;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;

public class ApplicationCategoriesPlugins
extends BaseComponentPlugin {
    private ConfigurationManager cmanager_;
    private ApplicationRegistryService pdcService_;
    private List<ApplicationCategory> categories;
    private boolean merge;

    public ApplicationCategoriesPlugins(ApplicationRegistryService pdcService, ConfigurationManager cmanager, InitParams params) throws Exception {
        this.categories = params.getObjectParamValues(ApplicationCategory.class);
        if (params.containsKey((Object)"merge")) {
            this.merge = StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)params.getValueParam("merge").getValue());
        }
        this.cmanager_ = cmanager;
        this.pdcService_ = pdcService;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public void run() throws Exception {
        this.run(false);
    }

    public List<ApplicationCategory> getCategories() {
        return this.categories;
    }

    public void run(boolean firstStartup) throws Exception {
        if (this.categories == null || !firstStartup && !this.merge) {
            return;
        }
        for (ApplicationCategory category : this.categories) {
            ApplicationCategory storedCategory = this.pdcService_.getApplicationCategory(category.getName());
            List<Application> apps = category.getApplications();
            if (!this.merge || storedCategory == null) {
                this.pdcService_.save(category);
            }
            if (!firstStartup && storedCategory != null) continue;
            for (Application app : apps) {
                this.pdcService_.save(category, app);
            }
        }
    }
}

