/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.unidata.util.StringUtil2;

public class Grib2Table {
    public static final String tableMapPath = "resources/grib2/standardTableMap.txt";
    public static List<Grib2Table> tables = null;
    private static Grib2Table standardTable = null;
    public final String name;
    public final Type type;
    public final Id id;
    private String path;

    private static List<Grib2Table> init() {
        ArrayList<Grib2Table> result = new ArrayList<Grib2Table>();
        ClassLoader cl = Grib2Table.class.getClassLoader();
        try (InputStream is = cl.getResourceAsStream(tableMapPath);){
            String line;
            if (is == null) {
                throw new IllegalStateException("Cant find resources/grib2/standardTableMap.txt");
            }
            BufferedReader dataIS = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF8")));
            int count = 0;
            while ((line = dataIS.readLine()) != null) {
                if (line.startsWith("#")) continue;
                ++count;
                String[] flds = line.split(";");
                if (flds.length < 7) {
                    System.out.printf("%d BAD format == %s%n", count, line);
                    continue;
                }
                int fldidx = 0;
                try {
                    int center = Integer.parseInt(flds[fldidx++].trim());
                    int subcenter = Integer.parseInt(flds[fldidx++].trim());
                    int master = Integer.parseInt(flds[fldidx++].trim());
                    int local = Integer.parseInt(flds[fldidx++].trim());
                    int genProcess = Integer.parseInt(flds[fldidx++].trim());
                    String typeName = StringUtil2.remove((String)flds[fldidx++].trim(), (int)34);
                    String name = StringUtil2.remove((String)flds[fldidx++].trim(), (int)34);
                    String resource = flds.length > 7 ? StringUtil2.remove((String)flds[fldidx++].trim(), (int)34) : null;
                    Type type = Type.valueOf(typeName);
                    Grib2Table table = new Grib2Table(name, center, subcenter, master, local, genProcess, resource, type);
                    result.add(table);
                }
                catch (Exception e) {
                    System.out.printf("%d %d BAD line == %s : %s%n", count, fldidx, line, e.getMessage());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        standardTable = new Grib2Table("WMO", 0, -1, -1, -1, -1, WmoCodeTable.standard.getResourceName(), Type.wmo);
        result.add(standardTable);
        return result;
    }

    public static Grib2Table getTable(Id id) {
        if (tables == null) {
            tables = Grib2Table.init();
        }
        for (Grib2Table table : tables) {
            if (!table.id.match(id)) continue;
            return table;
        }
        return standardTable;
    }

    public static List<Grib2Table> getTables() {
        if (tables == null) {
            tables = Grib2Table.init();
        }
        return tables;
    }

    Grib2Table(String name, int center, int subCenter, int masterVersion, int localVersion, int genProcessId, String path, Type type) {
        this.name = name;
        this.path = path;
        this.type = type;
        this.id = new Id(center, subCenter, masterVersion, localVersion, genProcessId);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Id getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grib2Table that = (Grib2Table)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }

    public static class Id {
        public final int center;
        public final int subCenter;
        public final int masterVersion;
        public final int localVersion;
        public final int genProcessId;

        Id(int center, int subCenter, int masterVersion, int localVersion, int genProcessId) {
            this.center = center;
            this.subCenter = subCenter;
            this.masterVersion = masterVersion;
            this.localVersion = localVersion;
            this.genProcessId = genProcessId;
        }

        boolean match(Id id) {
            if (id.center != this.center) {
                return false;
            }
            if (this.subCenter != -1 && id.subCenter != this.subCenter) {
                return false;
            }
            if (this.masterVersion != -1 && id.masterVersion != this.masterVersion) {
                return false;
            }
            if (this.localVersion != -1 && id.localVersion != this.localVersion) {
                return false;
            }
            return this.genProcessId == -1 || id.genProcessId == this.genProcessId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id that = (Id)o;
            if (this.center != that.center) {
                return false;
            }
            if (this.genProcessId != that.genProcessId) {
                return false;
            }
            if (this.localVersion != that.localVersion) {
                return false;
            }
            if (this.masterVersion != that.masterVersion) {
                return false;
            }
            return this.subCenter == that.subCenter;
        }

        public int hashCode() {
            int result = this.center;
            result = 31 * result + this.subCenter;
            result = 31 * result + this.masterVersion;
            result = 31 * result + this.localVersion;
            result = 31 * result + this.genProcessId;
            return result;
        }
    }

    public static enum Type {
        wmo,
        dss,
        gempak,
        gsd,
        kma,
        ncep,
        ndfd;

    }
}

