/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.jdbc.dao.NavigationDAO;
import org.exoplatform.portal.mop.jdbc.dao.NodeDAO;
import org.exoplatform.portal.mop.jdbc.dao.PageDAO;
import org.exoplatform.portal.mop.jdbc.dao.SiteDAO;
import org.exoplatform.portal.mop.navigation.NavigationData;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.NavigationStoreImpl;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CachedNavigationStore
extends NavigationStoreImpl {
    private static final Log LOG = ExoLogger.getExoLogger(CachedNavigationStore.class);
    public static final String NAVIGATION_CACHE_NAME = "portal.NavigationService";
    public static final String NODE_CACHE_NAME = "portal.NavigationNode";
    private final FutureExoCache<NavigationKey, NavigationData, Object> navigationFutureCache;
    private final ExoCache<NavigationKey, NavigationData> navigationCache;
    private final FutureExoCache<Long, NodeData, Object> nodeFutureCache;
    private final ExoCache<Long, NodeData> nodeCache;

    public CachedNavigationStore(CacheService cacheService, NavigationDAO navigationDAO, SiteDAO siteDAO, NodeDAO nodeDAO, PageDAO pageDAO, DataStorage dataStorage) {
        super(navigationDAO, siteDAO, nodeDAO, pageDAO, dataStorage);
        this.navigationCache = cacheService.getCacheInstance(NAVIGATION_CACHE_NAME);
        this.navigationFutureCache = new FutureExoCache((Loader)new Loader<NavigationKey, NavigationData, Object>(){

            public NavigationData retrieve(Object context, NavigationKey navigationKey) throws Exception {
                if (navigationKey.key == null) {
                    return CachedNavigationStore.super.loadNavigationData(navigationKey.nodeId);
                }
                return CachedNavigationStore.super.loadNavigationData(navigationKey.key);
            }
        }, this.navigationCache);
        this.nodeCache = cacheService.getCacheInstance(NODE_CACHE_NAME);
        this.nodeFutureCache = new FutureExoCache((Loader)new Loader<Long, NodeData, Object>(){

            public NodeData retrieve(Object context, Long nodeId) throws Exception {
                return CachedNavigationStore.super.loadNode(nodeId);
            }
        }, this.nodeCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeData[] createNode(Long parentId, Long previousId, String name, NodeState state) {
        try {
            NodeData[] nodeDataArray = super.createNode(parentId, previousId, name, state);
            return nodeDataArray;
        }
        finally {
            this.nodeCache.remove((Serializable)parentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeData destroyNode(Long targetId) {
        NodeData nodeData = this.loadNode(targetId);
        try {
            NodeData nodeData2 = super.destroyNode(targetId);
            return nodeData2;
        }
        finally {
            this.clearNodeCache(nodeData);
        }
    }

    @Override
    public NodeData loadNode(Long nodeId) {
        return (NodeData)this.nodeFutureCache.get(null, (Object)nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeData[] moveNode(Long targetId, Long fromId, Long toId, Long previousId) {
        NodeData nodeData = this.loadNode(targetId);
        NodeData fromNodeData = this.loadNode(fromId);
        NodeData toNodeData = this.loadNode(toId);
        try {
            NodeData[] nodeDataArray = super.moveNode(targetId, fromId, toId, previousId);
            return nodeDataArray;
        }
        finally {
            this.clearNodeCache(nodeData);
            this.clearNodeCache(fromNodeData);
            this.clearNodeCache(toNodeData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeData[] renameNode(Long targetId, Long parentId, String name) {
        NodeData nodeData = this.loadNode(targetId);
        NodeData parentNodeData = this.loadNode(parentId);
        try {
            NodeData[] nodeDataArray = super.renameNode(targetId, parentId, name);
            return nodeDataArray;
        }
        finally {
            this.clearNodeCache(nodeData);
            this.clearNodeCache(parentNodeData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeData updateNode(Long targetId, NodeState state) {
        NodeData nodeData = this.loadNode(targetId);
        try {
            NodeData nodeData2 = super.updateNode(targetId, state);
            return nodeData2;
        }
        finally {
            this.clearNodeCache(nodeData);
        }
    }

    @Override
    public NavigationData loadNavigationData(Long nodeId) {
        return (NavigationData)this.navigationFutureCache.get(null, (Object)new NavigationKey(null, nodeId));
    }

    @Override
    public NavigationData loadNavigationData(SiteKey key) {
        return (NavigationData)this.navigationFutureCache.get(null, (Object)new NavigationKey(key, null));
    }

    @Override
    public void saveNavigation(SiteKey key, NavigationState state) {
        try {
            super.saveNavigation(key, state);
        }
        finally {
            this.clearNavigationByKey(key);
            this.clearNodeCache(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroyNavigation(NavigationData data) {
        try {
            boolean bl = super.destroyNavigation(data);
            return bl;
        }
        finally {
            SiteKey siteKey = data.getSiteKey();
            this.clearNavigationByKey(siteKey);
            this.clearNodeCache(siteKey);
            this.clearNodeCache(Long.parseLong(data.rootId));
        }
    }

    public void clearNavigationByKey(SiteKey siteKey) {
        if (siteKey != null) {
            try {
                this.navigationCache.select((CachedObjectSelector)new NavigationCacheSelector(siteKey));
                this.nodeCache.select((CachedObjectSelector)new NavigationDataCacheSelector(siteKey, null));
            }
            catch (Exception e) {
                LOG.error("Error clearing cache of navigation having site key {}", new Object[]{siteKey, e});
            }
        }
    }

    public void clearNodeCache(SiteKey siteKey) {
        try {
            this.nodeCache.select((CachedObjectSelector)new NavigationDataCacheSelector(siteKey, null));
            this.navigationCache.select((CachedObjectSelector)new NavigationCacheSelector(siteKey));
        }
        catch (Exception e) {
            LOG.error("Error clearing cache of nodes of site {}", new Object[]{siteKey, e});
        }
    }

    public void clearNodeCache(Long nodeId) {
        try {
            this.nodeCache.select((CachedObjectSelector)new NavigationDataCacheSelector(null, nodeId));
        }
        catch (Exception e) {
            LOG.error("Error clearing cache of node data with id", new Object[]{nodeId, e});
        }
    }

    public void clearNodeCache(NodeData nodeData) {
        if (nodeData != null) {
            try {
                SiteKey siteKey = nodeData.getState().getSiteKey();
                this.nodeCache.select((CachedObjectSelector)new NavigationDataCacheSelector(siteKey, Long.parseLong(nodeData.getId())));
                if (nodeData.getParentId() != null) {
                    this.nodeCache.select((CachedObjectSelector)new NavigationDataCacheSelector(null, Long.parseLong(nodeData.getParentId())));
                }
                this.navigationCache.select((CachedObjectSelector)new NavigationCacheSelector(siteKey));
            }
            catch (Exception e) {
                LOG.error("Error clearing cache of node data with id {} of page {}", new Object[]{nodeData.getId(), nodeData.getName(), e});
            }
        }
    }

    public static class NavigationKey
    implements Serializable {
        private static final long serialVersionUID = 186446668859416892L;
        private SiteKey key;
        private Long nodeId;

        public NavigationKey(SiteKey key, Long nodeId) {
            this.key = key;
            this.nodeId = nodeId;
        }

        public SiteKey getKey() {
            return this.key;
        }

        public void setKey(SiteKey key) {
            this.key = key;
        }

        public Long getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(Long nodeId) {
            this.nodeId = nodeId;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.key, this.nodeId});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NavigationKey)) {
                return false;
            }
            return Objects.equal((Object)this.key, (Object)((NavigationKey)obj).key) && Objects.equal((Object)this.nodeId, (Object)((NavigationKey)obj).nodeId);
        }
    }

    public static class NavigationDataCacheSelector
    implements CachedObjectSelector<Long, NodeData> {
        private SiteKey key;
        private Long nodeId;

        public NavigationDataCacheSelector(SiteKey key, Long nodeId) {
            this.key = key;
            this.nodeId = nodeId;
        }

        public boolean select(Long nodeKey, ObjectCacheInfo<? extends NodeData> ocinfo) {
            return Objects.equal((Object)this.nodeId, (Object)nodeKey) || Objects.equal((Object)this.key, (Object)((NodeData)ocinfo.get()).getParentId()) || Objects.equal((Object)this.key, (Object)((NodeData)ocinfo.get()).getState().getSiteKey());
        }

        public void onSelect(ExoCache<? extends Long, ? extends NodeData> cache, Long key, ObjectCacheInfo<? extends NodeData> ocinfo) throws Exception {
            cache.remove((Serializable)key);
        }
    }

    public static class NavigationCacheSelector
    implements CachedObjectSelector<NavigationKey, NavigationData> {
        private SiteKey key;

        public NavigationCacheSelector(SiteKey key) {
            this.key = key;
        }

        public boolean select(NavigationKey navigationKey, ObjectCacheInfo<? extends NavigationData> ocinfo) {
            return Objects.equal((Object)this.key, (Object)navigationKey.getKey()) || Objects.equal((Object)this.key, (Object)((NavigationData)ocinfo.get()).getSiteKey());
        }

        public void onSelect(ExoCache<? extends NavigationKey, ? extends NavigationData> cache, NavigationKey key, ObjectCacheInfo<? extends NavigationData> ocinfo) throws Exception {
            cache.remove((Serializable)key);
        }
    }
}

