/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.common.lifecycle.LifeCycleListener;
import org.exoplatform.social.core.application.PortletPreferenceRequiredPlugin;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.SpaceExternalInvitation;
import org.exoplatform.social.core.space.SpaceApplicationConfigPlugin;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceLifecycle;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.SpacesAdministrationService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceApplicationHandler;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.web.security.security.RemindPasswordTokenService;

public class SpaceServiceImpl
implements SpaceService {
    private static final Log LOG = ExoLogger.getLogger((String)SpaceServiceImpl.class.getName());
    public static final String MEMBER = "member";
    public static final String MANAGER = "manager";
    public static final String DEFAULT_APP_CATEGORY = "spacesApplications";
    private IdentityRegistry identityRegistry;
    private SpaceStorage spaceStorage;
    private IdentityManager identityManager;
    private OrganizationService orgService = null;
    private UserACL userACL = null;
    private SpaceLifecycle spaceLifeCycle = new SpaceLifecycle();
    List<String> portletPrefsRequired = null;
    private static final int OFFSET = 0;
    private static final int LIMIT = 200;
    private WebNotificationService webNotificationService;
    private SpacesAdministrationService spacesAdministrationService;
    private SpaceTemplateService spaceTemplateService;
    private ConfigurationManager configurationManager;
    private ApplicationRegistryService applicationRegistryService;
    private String spacesApplicationsCategory = "spacesApplications";

    public SpaceServiceImpl(SpaceStorage spaceStorage, IdentityManager identityManager, UserACL userACL, ConfigurationManager configurationManager, IdentityRegistry identityRegistry, WebNotificationService webNotificationService, SpacesAdministrationService spacesAdministrationService, SpaceTemplateService spaceTemplateService, ApplicationRegistryService applicationRegistryService, InitParams params) {
        this.spaceStorage = spaceStorage;
        this.identityManager = identityManager;
        this.identityRegistry = identityRegistry;
        this.userACL = userACL;
        this.webNotificationService = webNotificationService;
        this.spacesAdministrationService = spacesAdministrationService;
        this.spaceTemplateService = spaceTemplateService;
        this.configurationManager = configurationManager;
        this.applicationRegistryService = applicationRegistryService;
        if (params != null && params.containsKey((Object)"spacesApplicationsCategory")) {
            this.spacesApplicationsCategory = params.getValueParam("spacesApplicationsCategory").getValue();
        }
    }

    public List<Space> getAllSpaces() throws SpaceException {
        try {
            return Arrays.asList((Space[])this.getAllSpacesWithListAccess().load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public ListAccess<Space> getAllSpacesWithListAccess() {
        return new SpaceListAccess(this.spaceStorage, SpaceListAccess.Type.ALL);
    }

    public Space getSpaceByDisplayName(String spaceDisplayName) {
        return this.spaceStorage.getSpaceByDisplayName(spaceDisplayName);
    }

    public Space getSpaceByName(String spaceName) {
        return this.getSpaceByPrettyName(spaceName);
    }

    public Space getSpaceByPrettyName(String spacePrettyName) {
        return this.spaceStorage.getSpaceByPrettyName(spacePrettyName);
    }

    public List<Space> getSpacesByFirstCharacterOfName(String firstCharacterOfName) throws SpaceException {
        try {
            return Arrays.asList((Space[])this.getAllSpacesByFilter(new SpaceFilter(firstCharacterOfName.charAt(0))).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public List<Space> getSpacesBySearchCondition(String searchCondition) throws SpaceException {
        try {
            return Arrays.asList((Space[])this.getAllSpacesByFilter(new SpaceFilter(searchCondition)).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public Space getSpaceByGroupId(String groupId) {
        return this.spaceStorage.getSpaceByGroupId(groupId);
    }

    public Space getSpaceById(String id) {
        return this.spaceStorage.getSpaceById(id);
    }

    public Space getSpaceByUrl(String url) {
        return this.spaceStorage.getSpaceByUrl(url);
    }

    public List<Space> getSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList((Space[])this.getMemberSpaces(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public List<Space> getAccessibleSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getAccessibleSpacesWithListAccess(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public SpaceListAccess getAccessibleSpacesWithListAccess(String userId) {
        return new SpaceListAccess(this.spaceStorage, userId, SpaceListAccess.Type.ACCESSIBLE);
    }

    public List<Space> getVisibleSpaces(String userId, SpaceFilter spaceFilter) throws SpaceException {
        try {
            return Arrays.asList(this.getVisibleSpacesWithListAccess(userId, spaceFilter).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public SpaceListAccess getVisibleSpacesWithListAccess(String userId, SpaceFilter spaceFilter) {
        if (this.isSuperManager(userId)) {
            if (spaceFilter == null) {
                return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.ALL);
            }
            return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
        }
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.VISIBLE);
    }

    public SpaceListAccess getUnifiedSearchSpacesWithListAccess(String userId, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.UNIFIED_SEARCH);
    }

    public List<Space> getEditableSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList((Space[])this.getSettingableSpaces(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public List<Space> getInvitedSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList((Space[])this.getInvitedSpacesWithListAccess(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public List<Space> getPublicSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getPublicSpacesWithListAccess(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public SpaceListAccess getPublicSpacesWithListAccess(String userId) {
        if (this.isSuperManager(userId)) {
            return new SpaceListAccess(this.spaceStorage, SpaceListAccess.Type.PUBLIC_SUPER_USER);
        }
        return new SpaceListAccess(this.spaceStorage, userId, SpaceListAccess.Type.PUBLIC);
    }

    public List<Space> getPendingSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getPendingSpacesWithListAccess(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public SpaceListAccess getPendingSpacesWithListAccess(String userId) {
        return new SpaceListAccess(this.spaceStorage, userId, SpaceListAccess.Type.PENDING);
    }

    public Space createSpace(Space space, String creator) {
        return this.createSpace(space, creator, (String)null);
    }

    @Deprecated
    public Space createSpace(Space space, String creator, String invitedGroupId) {
        ArrayList<org.exoplatform.social.core.identity.model.Identity> invitedIdentities = new ArrayList<org.exoplatform.social.core.identity.model.Identity>();
        if (invitedGroupId != null) {
            OrganizationService org = this.getOrgService();
            try {
                User[] users;
                ListAccess groupMembersAccess = org.getUserHandler().findUsersByGroupId(invitedGroupId);
                for (User user : users = (User[])groupMembersAccess.load(0, groupMembersAccess.getSize())) {
                    String userId = user.getUserName();
                    org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", userId);
                    if (identity == null) continue;
                    invitedIdentities.add(identity);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invite users from group " + invitedGroupId, e);
            }
        }
        return this.createSpace(space, creator, invitedIdentities);
    }

    public Space createSpace(Space space, String creator, List<org.exoplatform.social.core.identity.model.Identity> identitiesToInvite) {
        if (space.getDisplayName().length() > 200) {
            throw new RuntimeException("Error while creating the space " + space.getDisplayName() + ": space name cannot exceed 200 characters");
        }
        if (!SpaceUtils.isValidSpaceName(space.getDisplayName())) {
            throw new RuntimeException("Error while creating the space " + space.getDisplayName() + ": space name can only contain letters, digits or space characters only");
        }
        if (!this.spacesAdministrationService.canCreateSpace(creator)) {
            throw new RuntimeException("User does not have permissions to create a space.");
        }
        Object[] managers = space.getManagers();
        Object[] members = space.getMembers();
        managers = (String[])ArrayUtils.add((Object[])managers, (Object)creator);
        members = (String[])ArrayUtils.add((Object[])members, (Object)creator);
        space.setManagers((String[])managers);
        space.setMembers((String[])members);
        String groupId = null;
        try {
            groupId = SpaceUtils.createGroup(space.getDisplayName(), space.getPrettyName(), creator);
        }
        catch (SpaceException e) {
            throw new RuntimeException("Error while creating group for space " + space.getPrettyName(), e);
        }
        String prettyName = groupId.split("/")[2];
        if (!prettyName.equals(space.getPrettyName())) {
            space.setPrettyName(groupId.split("/")[2]);
        }
        space.setGroupId(groupId);
        space.setUrl(space.getPrettyName());
        try {
            String spaceType = space.getTemplate();
            SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplateByName(spaceType);
            if (spaceTemplate == null) {
                LOG.warn("could not find space template of type {}, will use Default template", new Object[]{spaceType});
                String defaultTemplate = this.spaceTemplateService.getDefaultSpaceTemplate();
                space.setTemplate(defaultTemplate);
            }
            SpaceApplicationHandler applicationHandler = this.getSpaceApplicationHandler(space);
            this.spaceTemplateService.initSpaceApplications(space, applicationHandler);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to init apps for space " + space.getPrettyName(), e);
        }
        this.saveSpace(space, true);
        this.spaceLifeCycle.spaceCreated(space, creator);
        try {
            this.inviteIdentities(space, identitiesToInvite);
        }
        catch (Exception e) {
            LOG.warn("Error inviting identities {} to space {}", new Object[]{identitiesToInvite, space.getDisplayName(), e});
        }
        return this.getSpaceById(space.getId());
    }

    public void inviteIdentities(Space space, List<org.exoplatform.social.core.identity.model.Identity> identitiesToInvite) {
        if (identitiesToInvite == null || identitiesToInvite.isEmpty()) {
            return;
        }
        Set<String> userIds = this.getUsersToInvite(identitiesToInvite);
        for (String userId : userIds) {
            if (this.isMember(space, userId) || this.isInvited(space, userId)) continue;
            this.inviteMember(space, userId);
        }
    }

    public boolean isSpaceContainsExternals(Long spaceId) {
        return this.spaceStorage.countExternalMembers(spaceId) != 0;
    }

    private Set<String> getUsersToInvite(List<org.exoplatform.social.core.identity.model.Identity> identities) {
        HashSet<String> invitedUserIds = new HashSet<String>();
        for (org.exoplatform.social.core.identity.model.Identity identity : identities) {
            String providerId = identity.getProviderId();
            String remoteId = identity.getRemoteId();
            if ("space".equals(providerId)) {
                Space space = this.getSpaceByPrettyName(remoteId);
                if (space == null) continue;
                String[] users = space.getMembers();
                invitedUserIds.addAll(Arrays.asList(users));
                continue;
            }
            invitedUserIds.add(remoteId);
        }
        return invitedUserIds;
    }

    public void saveSpace(Space space, boolean isNew) {
        Space oldSpace = this.getSpaceById(space.getId());
        this.spaceStorage.saveSpace(space, isNew);
        if (!isNew) {
            if (!oldSpace.getVisibility().equals(space.getVisibility())) {
                this.spaceLifeCycle.spaceAccessEdited(space, space.getEditor());
            }
            String oldRegistration = oldSpace.getRegistration();
            String registration = space.getRegistration();
            if (oldRegistration == null && registration != null || oldRegistration != null && !oldRegistration.equals(registration)) {
                this.spaceLifeCycle.spaceRegistrationEdited(space, space.getEditor());
            }
        }
    }

    public void renameSpace(Space space, String newDisplayName) {
        this.spaceStorage.renameSpace(space, newDisplayName);
        this.spaceLifeCycle.spaceRenamed(space, space.getEditor());
    }

    public void renameSpace(String remoteId, Space space, String newDisplayName) {
        if (remoteId != null && this.isSuperManager(remoteId) && !this.isMember(space, remoteId)) {
            this.spaceStorage.renameSpace(remoteId, space, newDisplayName);
        } else {
            this.spaceStorage.renameSpace(space, newDisplayName);
        }
        this.spaceLifeCycle.spaceRenamed(space, space.getEditor());
    }

    public void deleteSpace(Space space) {
        try {
            SpaceUtils.removeMembershipFromGroup(space);
            org.exoplatform.social.core.identity.model.Identity spaceIdentity = null;
            if (this.identityManager.identityExisted("space", space.getPrettyName())) {
                spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
            }
            this.spaceStorage.deleteSpace(space.getId());
            if (spaceIdentity != null) {
                this.identityManager.hardDeleteIdentity(spaceIdentity);
            }
            OrganizationService orgService = this.getOrgService();
            UserACL acl = this.getUserACL();
            GroupHandler groupHandler = orgService.getGroupHandler();
            Group deletedGroup = groupHandler.findGroupById(space.getGroupId());
            List mandatories = acl.getMandatoryGroups();
            if (deletedGroup != null) {
                if (!this.isMandatory(groupHandler, deletedGroup, mandatories)) {
                    SpaceUtils.removeGroup(space);
                }
            } else {
                LOG.warn((Object)"deletedGroup is null");
            }
            SpaceUtils.removePagesAndGroupNavigation(space);
        }
        catch (Exception e) {
            LOG.error("Unable delete space: {}. Cause: {}", new Object[]{space.getPrettyName(), e.getMessage()});
        }
        this.spaceLifeCycle.spaceRemoved(space, null);
    }

    public void deleteSpace(String spaceId) {
        this.deleteSpace(this.getSpaceById(spaceId));
    }

    public void initApp(Space space) throws SpaceException {
        LOG.warn((Object)"Does nothing, just for compatible. It will be removed at 1.3.x");
    }

    public void initApps(Space space) throws SpaceException {
        LOG.warn((Object)"Does nothing, just for compatible. It will be removed at 1.3.x");
    }

    public void deInitApps(Space space) throws SpaceException {
        LOG.warn((Object)"Does nothing, just for compatible. It will be removed at 1.3.x");
    }

    public void addMember(Space space, String userId) {
        Object[] members = space.getMembers();
        space = this.removeInvited(space, userId);
        space = this.removePending(space, userId);
        if (!ArrayUtils.contains((Object[])members, (Object)userId)) {
            members = (String[])ArrayUtils.add((Object[])members, (Object)userId);
            space.setMembers((String[])members);
            this.updateSpace(space);
            SpaceUtils.addUserToGroupWithMemberMembership(userId, space.getGroupId());
            this.spaceLifeCycle.memberJoined(space, userId);
        }
    }

    public void addMember(String spaceId, String userId) {
        this.addMember(this.getSpaceById(spaceId), userId);
    }

    public void removeMember(Space space, String userId) {
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        if (spaceIdentity != null && spaceIdentity.isDeleted()) {
            return;
        }
        Object[] members = space.getMembers();
        if (ArrayUtils.contains((Object[])members, (Object)userId)) {
            members = (String[])ArrayUtils.removeElement((Object[])members, (Object)userId);
            space.setMembers((String[])members);
            this.updateSpace(space);
            SpaceUtils.removeUserFromGroupWithMemberMembership(userId, space.getGroupId());
            this.spaceLifeCycle.memberLeft(space, userId);
        }
    }

    public void removeMember(String spaceId, String userId) {
        this.removeMember(this.getSpaceById(spaceId), userId);
    }

    private Space addPending(Space space, String userId) {
        Object[] pendingUsers = space.getPendingUsers();
        if (!ArrayUtils.contains((Object[])pendingUsers, (Object)userId)) {
            pendingUsers = (String[])ArrayUtils.add((Object[])pendingUsers, (Object)userId);
            space.setPendingUsers((String[])pendingUsers);
        }
        return space;
    }

    private Space removePending(Space space, String userId) {
        Object[] pendingUsers = space.getPendingUsers();
        if (ArrayUtils.contains((Object[])pendingUsers, (Object)userId)) {
            pendingUsers = (String[])ArrayUtils.removeElement((Object[])pendingUsers, (Object)userId);
            space.setPendingUsers((String[])pendingUsers);
        }
        return space;
    }

    private Space addInvited(Space space, String userId) {
        Object[] invitedUsers = space.getInvitedUsers();
        if (!ArrayUtils.contains((Object[])invitedUsers, (Object)userId)) {
            invitedUsers = (String[])ArrayUtils.add((Object[])invitedUsers, (Object)userId);
            space.setInvitedUsers((String[])invitedUsers);
        }
        return space;
    }

    private Space removeInvited(Space space, String userId) {
        Object[] invitedUsers = space.getInvitedUsers();
        if (ArrayUtils.contains((Object[])invitedUsers, (Object)userId)) {
            invitedUsers = (String[])ArrayUtils.removeElement((Object[])invitedUsers, (Object)userId);
            space.setInvitedUsers((String[])invitedUsers);
        }
        return space;
    }

    public List<String> getMembers(Space space) {
        if (space.getMembers() != null) {
            return Arrays.asList(space.getMembers());
        }
        return new ArrayList<String>();
    }

    public List<String> getMembers(String spaceId) {
        return this.getMembers(this.getSpaceById(spaceId));
    }

    public void setLeader(Space space, String userId, boolean isLeader) {
        this.setManager(space, userId, isLeader);
    }

    public void setLeader(String spaceId, String userId, boolean isLeader) {
        this.setManager(this.getSpaceById(spaceId), userId, isLeader);
    }

    public boolean isLeader(Space space, String userId) {
        return this.isManager(space, userId);
    }

    public boolean isLeader(String spaceId, String userId) {
        return this.isManager(this.getSpaceById(spaceId), userId);
    }

    public boolean isOnlyLeader(Space space, String userId) {
        return this.isOnlyManager(space, userId);
    }

    public boolean isOnlyLeader(String spaceId, String userId) {
        return this.isOnlyManager(this.getSpaceById(spaceId), userId);
    }

    public boolean isMember(Space space, String userId) {
        return ArrayUtils.contains((Object[])space.getMembers(), (Object)userId);
    }

    public boolean isMember(String spaceId, String userId) {
        return this.isMember(this.getSpaceById(spaceId), userId);
    }

    public boolean hasAccessPermission(Space space, String userId) {
        return this.isSuperManager(userId) || ArrayUtils.contains((Object[])space.getMembers(), (Object)userId) || ArrayUtils.contains((Object[])space.getManagers(), (Object)userId);
    }

    public boolean hasAccessPermission(String spaceId, String userId) {
        return this.hasAccessPermission(this.getSpaceById(spaceId), userId);
    }

    public boolean hasEditPermission(Space space, String userId) {
        return this.hasSettingPermission(space, userId);
    }

    public boolean hasEditPermission(String spaceId, String userId) {
        return this.hasSettingPermission(this.getSpaceById(spaceId), userId);
    }

    public boolean isInvited(Space space, String userId) {
        return this.isInvitedUser(space, userId);
    }

    public boolean isInvited(String spaceId, String userId) {
        return this.isInvitedUser(this.getSpaceById(spaceId), userId);
    }

    public boolean isPending(Space space, String userId) {
        return this.isPendingUser(space, userId);
    }

    public boolean isPending(String spaceId, String userId) {
        return this.isPendingUser(this.getSpaceById(spaceId), userId);
    }

    public boolean isIgnored(Space space, String userId) {
        boolean ignoredMember = this.spaceStorage.isSpaceIgnored(space.getId(), userId);
        return ignoredMember;
    }

    public void setIgnored(String spaceId, String userId) {
        this.spaceStorage.ignoreSpace(spaceId, userId);
        this.removeWebNotifications(spaceId, userId);
    }

    public List<Application> getSpacesApplications() {
        ApplicationCategory category = this.applicationRegistryService.getApplicationCategory(this.spacesApplicationsCategory);
        return category == null || category.getApplications() == null ? Collections.emptyList() : category.getApplications();
    }

    public void addSpacesApplication(Application application) {
        ApplicationCategory category = this.applicationRegistryService.getApplicationCategory(this.spacesApplicationsCategory);
        if (category == null) {
            category = new ApplicationCategory();
            category.setName(this.spacesApplicationsCategory);
            category.setDisplayName("Spaces applications");
            this.applicationRegistryService.save(category);
            category = this.applicationRegistryService.getApplicationCategory(this.spacesApplicationsCategory);
        }
        application.setCategoryName(this.spacesApplicationsCategory);
        application.setCreatedDate(new Date());
        application.setType(ApplicationType.PORTLET);
        this.applicationRegistryService.save(category, application);
    }

    public void deleteSpacesApplication(String applicationName) {
        Application application = this.applicationRegistryService.getApplication(this.spacesApplicationsCategory, applicationName);
        if (application != null) {
            this.applicationRegistryService.remove(application);
        }
    }

    public void installApplication(String spaceId, String appId) throws SpaceException {
        this.installApplication(this.getSpaceById(spaceId), appId);
    }

    public void moveApplication(String spaceId, String appId, int transition) throws SpaceException {
        Space space = this.getSpaceById(spaceId);
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        try {
            appHandler.moveApplication(space, appId, transition);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_MOVE_APPLICATION, (Throwable)e);
        }
    }

    public void installApplication(Space space, String appId) throws SpaceException {
        this.spaceLifeCycle.addApplication(space, this.getPortletId(appId));
    }

    public void activateApplication(Space space, String appId) throws SpaceException {
        Object appName = null;
        appName = SpaceUtils.isInstalledApp(space, appId) ? appId + System.currentTimeMillis() : appId;
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        appHandler.activateApplication(space, appId, (String)appName);
        this.spaceTemplateService.setApp(space, appId, (String)appName, true, "active");
        this.saveSpace(space, false);
        this.spaceLifeCycle.activateApplication(space, this.getPortletId(appId));
    }

    public void activateApplication(String spaceId, String appId) throws SpaceException {
        this.activateApplication(this.getSpaceById(spaceId), appId);
    }

    public void deactivateApplication(Space space, String appId) throws SpaceException {
        String appStatus = SpaceUtils.getAppStatus(space, appId);
        if (appStatus == null) {
            LOG.warn((Object)"appStatus is null!");
            return;
        }
        if (appStatus.equals("deactive")) {
            return;
        }
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        appHandler.deactiveApplication(space, appId);
        this.spaceTemplateService.setApp(space, appId, appId, SpaceUtils.isRemovableApp(space, appId), "deactive");
        this.saveSpace(space, false);
        this.spaceLifeCycle.deactivateApplication(space, this.getPortletId(appId));
    }

    public void deactivateApplication(String spaceId, String appId) throws SpaceException {
        this.deactivateApplication(this.getSpaceById(spaceId), appId);
    }

    public void removeApplication(Space space, String appId, String appName) throws SpaceException {
        String appStatus = SpaceUtils.getAppStatus(space, appId);
        if (appStatus == null) {
            return;
        }
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        appHandler.removeApplication(space, appId, appName);
        this.removeApp(space, appId, appName);
        this.spaceLifeCycle.removeApplication(space, this.getPortletId(appId));
    }

    public void removeApplication(String spaceId, String appId, String appName) throws SpaceException {
        this.removeApplication(this.getSpaceById(spaceId), appId, appName);
    }

    public void requestJoin(String spaceId, String userId) {
        this.addPendingUser(this.getSpaceById(spaceId), userId);
    }

    public void requestJoin(Space space, String userId) {
        this.addPendingUser(space, userId);
    }

    public void revokeRequestJoin(Space space, String userId) {
        this.removePendingUser(space, userId);
    }

    public void revokeRequestJoin(String spaceId, String userId) {
        this.removePending(this.getSpaceById(spaceId), userId);
    }

    public void inviteMember(Space space, String userId) {
        this.addInvitedUser(space, userId);
    }

    public void inviteMember(String spaceId, String userId) {
        this.addInvitedUser(this.getSpaceById(spaceId), userId);
    }

    public void revokeInvitation(Space space, String userId) {
        this.removeInvitedUser(space, userId);
    }

    public void revokeInvitation(String spaceId, String userId) {
        this.removeInvitedUser(this.getSpaceById(spaceId), userId);
    }

    public void acceptInvitation(Space space, String userId) throws SpaceException {
        this.addMember(space, userId);
    }

    public void acceptInvitation(String spaceId, String userId) throws SpaceException {
        this.addMember(this.getSpaceById(spaceId), userId);
    }

    public void denyInvitation(String spaceId, String userId) {
        this.removeInvitedUser(this.getSpaceById(spaceId), userId);
    }

    public void denyInvitation(Space space, String userId) {
        this.removeInvitedUser(space, userId);
    }

    public void validateRequest(Space space, String userId) {
        this.addMember(space, userId);
    }

    public void validateRequest(String spaceId, String userId) {
        this.addMember(this.getSpaceById(spaceId), userId);
    }

    public void declineRequest(Space space, String userId) {
        this.removePendingUser(space, userId);
    }

    public void declineRequest(String spaceId, String userId) {
        this.removePendingUser(this.getSpaceById(spaceId), userId);
    }

    public void registerSpaceLifeCycleListener(SpaceLifeCycleListener listener) {
        this.spaceLifeCycle.addListener((LifeCycleListener)listener);
    }

    public void unregisterSpaceLifeCycleListener(SpaceLifeCycleListener listener) {
        this.spaceLifeCycle.removeListener((LifeCycleListener)listener);
    }

    public void addSpaceListener(SpaceListenerPlugin plugin) {
        this.registerSpaceLifeCycleListener((SpaceLifeCycleListener)plugin);
    }

    public void setPortletsPrefsRequired(PortletPreferenceRequiredPlugin portletPrefsRequiredPlugin) {
        List portletPrefs = portletPrefsRequiredPlugin.getPortletPrefs();
        if (this.portletPrefsRequired == null) {
            this.portletPrefsRequired = new ArrayList<String>();
        }
        this.portletPrefsRequired.addAll(portletPrefs);
    }

    public String[] getPortletsPrefsRequired() {
        return this.portletPrefsRequired.toArray(new String[this.portletPrefsRequired.size()]);
    }

    private OrganizationService getOrgService() {
        if (this.orgService == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        }
        return this.orgService;
    }

    private UserACL getUserACL() {
        return this.userACL;
    }

    private SpaceApplicationHandler getSpaceApplicationHandler(Space space) throws SpaceException {
        String spaceTemplate = space.getTemplate();
        SpaceApplicationHandler appHandler = (SpaceApplicationHandler)this.spaceTemplateService.getSpaceApplicationHandlers().get(spaceTemplate);
        if (appHandler == null) {
            LOG.debug("No space application handler was defined for template with name {}. Default will be used.", new Object[]{spaceTemplate});
            String defaultTemplate = this.spaceTemplateService.getDefaultSpaceTemplate();
            appHandler = (SpaceApplicationHandler)this.spaceTemplateService.getSpaceApplicationHandlers().get(defaultTemplate);
            if (appHandler == null) {
                throw new SpaceException(SpaceException.Code.UNKNOWN_SPACE_TYPE);
            }
        }
        return appHandler;
    }

    private void removeApp(Space space, String appId, String appName) throws SpaceException {
        String apps = space.getApp();
        StringBuffer remainApp = new StringBuffer();
        String[] listApp = apps.split(",");
        for (int idx = 0; idx < listApp.length; ++idx) {
            String app = listApp[idx];
            String[] appPart = app.split(":");
            if (appPart[1].equals(appName)) continue;
            if (remainApp.length() != 0) {
                remainApp.append(",");
            }
            remainApp.append(app);
        }
        space.setApp(remainApp.toString());
        this.saveSpace(space, false);
    }

    private boolean isMandatory(GroupHandler groupHandler, Group group, List<String> mandatories) throws Exception {
        if (mandatories.contains(group.getId())) {
            return true;
        }
        Collection children = groupHandler.findGroups(group);
        for (Group g : children) {
            if (!this.isMandatory(groupHandler, g, mandatories)) continue;
            return true;
        }
        return false;
    }

    public SpaceStorage getStorage() {
        return this.spaceStorage;
    }

    public void setStorage(SpaceStorage storage) {
        this.spaceStorage = storage;
    }

    public void addInvitedUser(Space space, String userId) {
        if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId)) {
            return;
        }
        if (this.isPending(space, userId)) {
            space = this.removePending(space, userId);
            this.addMember(space, userId);
        } else {
            space = this.addInvited(space, userId);
        }
        this.updateSpace(space);
        this.spaceLifeCycle.addInvitedUser(space, userId);
    }

    public void addPendingUser(Space space, String userId) {
        if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId)) {
            return;
        }
        if (ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)userId)) {
            return;
        }
        if (ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)userId)) {
            this.addMember(space, userId);
            space = this.removeInvited(space, userId);
            this.updateSpace(space);
            return;
        }
        String registration = space.getRegistration();
        String visibility = space.getVisibility();
        if (visibility.equals("hidden") && registration.equals("closed")) {
            LOG.warn((Object)"Unable request to join hidden");
            return;
        }
        if (registration.equals("open")) {
            this.addMember(space, userId);
        } else if (registration.equals("validation")) {
            space = this.addPending(space, userId);
            this.saveSpace(space, false);
        } else {
            LOG.warn((Object)"Unable request to join");
        }
        this.spaceLifeCycle.addPendingUser(space, userId);
    }

    public ListAccess<Space> getAccessibleSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        if (this.isSuperManager(userId) && (spaceFilter == null || spaceFilter.getAppId() == null)) {
            if (spaceFilter == null) {
                return new SpaceListAccess(this.spaceStorage, spaceFilter, SpaceListAccess.Type.ALL);
            }
            return new SpaceListAccess(this.spaceStorage, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
        }
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.ACCESSIBLE_FILTER);
    }

    public ListAccess<Space> getAllSpacesByFilter(SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
    }

    public ListAccess<Space> getInvitedSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.INVITED_FILTER);
    }

    public ListAccess<Space> getMemberSpaces(String userId) {
        return new SpaceListAccess(this.spaceStorage, userId, SpaceListAccess.Type.MEMBER);
    }

    public ListAccess<Space> getManagerSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.MANAGER_FILTER);
    }

    public ListAccess<Space> getManagerSpaces(String userId) {
        return new SpaceListAccess(this.spaceStorage, userId, SpaceListAccess.Type.MANAGER);
    }

    public ListAccess<Space> getMemberSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.MEMBER_FILTER);
    }

    public ListAccess<Space> getPendingSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.PENDING_FILTER);
    }

    public ListAccess<Space> getPublicSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        if (this.isSuperManager(userId)) {
            return new SpaceListAccess(this.spaceStorage, SpaceListAccess.Type.PUBLIC_SUPER_USER);
        }
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.PUBLIC_FILTER);
    }

    public ListAccess<Space> getSettingableSpaces(String userId) {
        if (this.isSuperManager(userId)) {
            return new SpaceListAccess(this.spaceStorage, SpaceListAccess.Type.ALL);
        }
        return new SpaceListAccess(this.spaceStorage, userId, SpaceListAccess.Type.SETTING);
    }

    public ListAccess<Space> getSettingabledSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        if (this.isSuperManager(userId)) {
            return new SpaceListAccess(this.spaceStorage, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
        }
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.SETTING_FILTER);
    }

    public boolean hasSettingPermission(Space space, String userId) {
        return this.isSuperManager(userId) || space != null && ArrayUtils.contains((Object[])space.getManagers(), (Object)userId);
    }

    public boolean isInvitedUser(Space space, String userId) {
        return ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)userId);
    }

    public boolean isManager(Space space, String userId) {
        return ArrayUtils.contains((Object[])space.getManagers(), (Object)userId);
    }

    public boolean isRedactor(Space space, String userId) {
        return ArrayUtils.contains((Object[])space.getRedactors(), (Object)userId);
    }

    public boolean hasRedactor(Space space) {
        return space.getRedactors() != null && space.getRedactors().length > 0;
    }

    public boolean canRedactOnSpace(Space space, Identity viewer) {
        String username = viewer.getUserId();
        return this.isMember(space, username) && (!this.hasRedactor(space) || this.isRedactor(space, username)) || this.isManagerOrSpaceManager(viewer, space);
    }

    public boolean isOnlyManager(Space space, String userId) {
        return space.getManagers() != null && space.getManagers().length == 1 && ArrayUtils.contains((Object[])space.getManagers(), (Object)userId);
    }

    public boolean isPendingUser(Space space, String userId) {
        return ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)userId);
    }

    public void registerSpaceListenerPlugin(SpaceListenerPlugin spaceListenerPlugin) {
        this.spaceLifeCycle.addListener((LifeCycleListener)spaceListenerPlugin);
    }

    public void removeInvitedUser(Space space, String userId) {
        if (ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)userId)) {
            space = this.removeInvited(space, userId);
            this.updateSpace(space);
            this.removeWebNotifications(space.getId(), userId);
        }
    }

    public void removePendingUser(Space space, String userId) {
        if (ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)userId)) {
            space = this.removePending(space, userId);
            this.updateSpace(space);
            this.removeWebNotifications(space.getId(), userId);
        }
    }

    private void removeWebNotifications(String spaceId, String userId) {
        if (this.webNotificationService != null) {
            WebNotificationFilter filter = new WebNotificationFilter(userId);
            filter.setParameter("spaceId", spaceId);
            PluginKey pluginKey = new PluginKey("SpaceInvitationPlugin");
            filter.setPluginKey(pluginKey);
            try {
                for (NotificationInfo notificationInfo : this.webNotificationService.getNotificationInfos(filter, 0, -1)) {
                    this.webNotificationService.remove(notificationInfo.getId());
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot remove web notifications for user: " + userId + " and space id: " + spaceId), (Throwable)e);
            }
        } else {
            LOG.error((Object)"Cannot update web notfication. WebNotificationService is null");
        }
    }

    public void addRedactor(Space space, String userId) {
        Object[] redactors = space.getRedactors();
        if (!ArrayUtils.contains((Object[])redactors, (Object)userId)) {
            redactors = (String[])ArrayUtils.add((Object[])redactors, (Object)userId);
            space.setRedactors((String[])redactors);
            this.updateSpace(space);
            SpaceUtils.addUserToGroupWithRedactorMembership(userId, space.getGroupId());
        }
    }

    public void removeRedactor(Space space, String userId) {
        Object[] redactors = space.getRedactors();
        if (ArrayUtils.contains((Object[])redactors, (Object)userId)) {
            redactors = (String[])ArrayUtils.removeElement((Object[])redactors, (Object)userId);
            space.setRedactors((String[])redactors);
            this.updateSpace(space);
            SpaceUtils.removeUserFromGroupWithRedactorMembership(userId, space.getGroupId());
        }
    }

    public void setManager(Space space, String userId, boolean isManager) {
        Object[] managers = space.getManagers();
        if (isManager) {
            if (!ArrayUtils.contains((Object[])managers, (Object)userId)) {
                managers = (String[])ArrayUtils.add((Object[])managers, (Object)userId);
                space.setManagers((String[])managers);
                this.updateSpace(space);
                SpaceUtils.addUserToGroupWithManagerMembership(userId, space.getGroupId());
                this.spaceLifeCycle.grantedLead(space, userId);
            }
        } else if (ArrayUtils.contains((Object[])managers, (Object)userId)) {
            managers = (String[])ArrayUtils.removeElement((Object[])managers, (Object)userId);
            space.setManagers((String[])managers);
            this.updateSpace(space);
            SpaceUtils.removeUserFromGroupWithManagerMembership(userId, space.getGroupId());
            Space updatedSpace = this.getSpaceById(space.getId());
            if (this.isMember(updatedSpace, userId)) {
                this.spaceLifeCycle.revokedLead(space, userId);
            }
        }
    }

    public void unregisterSpaceListenerPlugin(SpaceListenerPlugin spaceListenerPlugin) {
        this.spaceLifeCycle.removeListener((LifeCycleListener)spaceListenerPlugin);
    }

    @Deprecated
    public void setSpaceApplicationConfigPlugin(SpaceApplicationConfigPlugin spaceApplicationConfigPlugin) {
        LOG.warn((Object)"setSpaceApplicationConfigPlugin method has been deprecated, please use addSpaceTemplateConfigPlugin method from SpaceTemplateConfigPlugin class");
    }

    @Deprecated
    public SpaceApplicationConfigPlugin getSpaceApplicationConfigPlugin() {
        return null;
    }

    public Space updateSpace(Space existingSpace, List<org.exoplatform.social.core.identity.model.Identity> identitiesToInvite) {
        this.spaceStorage.saveSpace(existingSpace, false);
        if (Space.UpdatedField.DESCRIPTION.equals((Object)existingSpace.getField())) {
            this.spaceLifeCycle.spaceDescriptionEdited(existingSpace, existingSpace.getEditor());
        }
        this.inviteIdentities(existingSpace, identitiesToInvite);
        return this.getSpaceById(existingSpace.getId());
    }

    public Space updateSpace(Space existingSpace) {
        return this.updateSpace(existingSpace, null);
    }

    public Space updateSpaceAvatar(Space existingSpace) {
        this.checkSpaceEditorPermissions(existingSpace);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(existingSpace.getPrettyName());
        Profile profile = spaceIdentity.getProfile();
        if (existingSpace.getAvatarAttachment() != null) {
            profile.setProperty("avatar", (Object)existingSpace.getAvatarAttachment());
        } else {
            profile.removeProperty("avatar");
            profile.setAvatarUrl(null);
            profile.setAvatarLastUpdated(null);
        }
        this.identityManager.updateProfile(profile);
        this.spaceLifeCycle.spaceAvatarEdited(existingSpace, existingSpace.getEditor());
        existingSpace = this.spaceStorage.getSpaceById(existingSpace.getId());
        existingSpace.setAvatarLastUpdated(Long.valueOf(System.currentTimeMillis()));
        this.spaceStorage.saveSpace(existingSpace, false);
        return existingSpace;
    }

    public Space updateSpaceBanner(Space existingSpace) {
        Profile profile;
        this.checkSpaceEditorPermissions(existingSpace);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(existingSpace.getPrettyName());
        if (spaceIdentity != null) {
            profile = spaceIdentity.getProfile();
            if (existingSpace.getBannerAttachment() != null) {
                profile.setProperty("banner", (Object)existingSpace.getBannerAttachment());
            } else {
                profile.removeProperty("banner");
            }
        } else {
            throw new IllegalStateException("Can not update space banner. Space identity " + existingSpace.getPrettyName() + " not found");
        }
        this.identityManager.updateProfile(profile);
        existingSpace = this.spaceStorage.getSpaceById(existingSpace.getId());
        existingSpace.setAvatarLastUpdated(Long.valueOf(System.currentTimeMillis()));
        this.spaceStorage.saveSpace(existingSpace, false);
        this.spaceLifeCycle.spaceBannerEdited(existingSpace, existingSpace.getEditor());
        return existingSpace;
    }

    public ListAccess<Space> getInvitedSpacesWithListAccess(String userId) {
        return new SpaceListAccess(this.spaceStorage, userId, SpaceListAccess.Type.INVITED);
    }

    private String getPortletId(String appId) {
        int SEPARATOR = 46;
        if (appId.indexOf(46) != -1) {
            int beginIndex = appId.lastIndexOf(46) + 1;
            int endIndex = appId.length();
            return appId.substring(beginIndex, endIndex);
        }
        return appId;
    }

    public void updateSpaceAccessed(String remoteId, Space space) throws SpaceException {
        if (this.isMember(space, remoteId)) {
            this.spaceStorage.updateSpaceAccessed(remoteId, space);
        }
    }

    public List<Space> getLastAccessedSpace(String remoteId, String appId, int offset, int limit) throws SpaceException {
        SpaceFilter filter = new SpaceFilter(remoteId, appId);
        return this.spaceStorage.getLastAccessedSpace(filter, offset, limit);
    }

    public List<Space> getLastSpaces(int limit) {
        return this.spaceStorage.getLastSpaces(limit);
    }

    public ListAccess<Space> getLastAccessedSpace(String remoteId, String appId) {
        return new SpaceListAccess(this.spaceStorage, remoteId, appId, SpaceListAccess.Type.LASTEST_ACCESSED);
    }

    public ListAccess<Space> getVisitedSpaces(String remoteId, String appId) {
        return new SpaceListAccess(this.spaceStorage, remoteId, appId, SpaceListAccess.Type.VISITED);
    }

    public ListAccess<Space> getPendingSpaceRequestsToManage(String remoteId) {
        return new SpaceListAccess(this.spaceStorage, remoteId, SpaceListAccess.Type.PENDING_REQUESTS);
    }

    public List<SpaceExternalInvitation> findSpaceExternalInvitationsBySpaceId(String spaceId) {
        List spaceExternalInvitations = this.spaceStorage.findSpaceExternalInvitationsBySpaceId(spaceId);
        return spaceExternalInvitations;
    }

    public void saveSpaceExternalInvitation(String spaceId, String email, String tokenId) {
        this.spaceStorage.saveSpaceExternalInvitation(spaceId, email, tokenId);
    }

    public SpaceExternalInvitation getSpaceExternalInvitationById(String invitationId) {
        return this.spaceStorage.findSpaceExternalInvitationById(invitationId);
    }

    public void deleteSpaceExternalInvitation(String invitationId) {
        SpaceExternalInvitation spaceExternalInvitation = this.spaceStorage.findSpaceExternalInvitationById(invitationId);
        this.spaceStorage.deleteSpaceExternalInvitation(spaceExternalInvitation);
        RemindPasswordTokenService remindPasswordTokenService = (RemindPasswordTokenService)CommonsUtils.getService(RemindPasswordTokenService.class);
        if (remindPasswordTokenService != null) {
            remindPasswordTokenService.deleteToken(spaceExternalInvitation.getTokenId(), "external-registration");
        }
    }

    public List<String> findExternalInvitationsSpacesByEmail(String email) {
        return this.spaceStorage.findExternalInvitationsSpacesByEmail(email);
    }

    public void deleteExternalUserInvitations(String email) {
        this.spaceStorage.deleteExternalUserInvitations(email);
    }

    public boolean isSuperManager(String userId) {
        if (StringUtils.isBlank((String)userId) || IdentityConstants.ANONIM.equals(userId) || IdentityConstants.SYSTEM.equals(userId)) {
            return false;
        }
        if (userId.equals(this.getUserACL().getSuperUser())) {
            return true;
        }
        Identity identity = this.identityRegistry.getIdentity(userId);
        List superManagersMemberships = this.spacesAdministrationService.getSpacesAdministratorsMemberships();
        if (identity == null) {
            return superManagersMemberships.parallelStream().anyMatch(membershipEntry -> this.isUserInGroup(userId, (MembershipEntry)membershipEntry));
        }
        return superManagersMemberships.parallelStream().anyMatch(arg_0 -> ((Identity)identity).isMemberOf(arg_0));
    }

    private boolean isUserInGroup(String userId, MembershipEntry membershipEntry) {
        try {
            return this.getOrgService().getMembershipHandler().findMembershipByUserGroupAndType(userId, membershipEntry.getGroup(), membershipEntry.getMembershipType()) != null;
        }
        catch (Exception e) {
            LOG.error("Error when check {} have membershipType {} in group {}", new Object[]{userId, membershipEntry.getMembershipType(), membershipEntry.getGroup()});
            return false;
        }
    }

    private String checkSpaceEditorPermissions(Space space) {
        String editor = space.getEditor();
        if (StringUtils.isNotBlank((String)editor) && !this.hasEditPermission(space, editor)) {
            throw new IllegalStateException("User " + editor + " is not authorized to change space.");
        }
        return editor;
    }

    private boolean isManagerOrSpaceManager(Identity viewer, Space space) {
        String username = viewer.getUserId();
        if (viewer.isMemberOf(this.userACL.getAdminGroups()) || StringUtils.equals((String)this.userACL.getSuperUser(), (String)username)) {
            return true;
        }
        if (this.isSuperManager(username)) {
            return true;
        }
        return this.isManager(space, username);
    }
}

