/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.localization;

import java.util.Locale;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;

public class LocalizationLifecycle
extends BaseComponentPlugin
implements ApplicationLifecycle<WebuiRequestContext> {
    private static final String LOCALE_COOKIE = "LOCALE";
    private static final String LOCALE_SESSION_ATTR = "org.gatein.LOCALE";
    private static final String PREV_LOCALE_SESSION_ATTR = "org.gatein.LAST_LOCALE";
    private static Log log = ExoLogger.getLogger((String)"portal:LocalizationLifecycle");

    public void onInit(Application app) throws Exception {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        if (!(context instanceof PortalRequestContext)) {
            return;
        }
        PortalRequestContext reqCtx = (PortalRequestContext)context;
        ExoContainer container = app.getApplicationServiceContainer();
        LocalePolicy localePolicy = (LocalePolicy)container.getComponentInstanceOfType(LocalePolicy.class);
        HttpServletRequest request = (HttpServletRequest)HttpServletRequest.class.cast(context.getRequest());
        LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((HttpServletRequest)request);
        localeCtx.setRequestLocale(reqCtx.getRequestLocale());
        Set supportedLocales = LocaleContextInfoUtils.getSupportedLocales();
        Locale locale = localePolicy.determineLocale(localeCtx);
        boolean supported = supportedLocales.contains(locale);
        if (!supported && !"".equals(locale.getCountry())) {
            locale = new Locale(locale.getLanguage());
            supported = supportedLocales.contains(locale);
        }
        if (!supported) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Unsupported locale returned by LocalePolicy: " + localePolicy + ". Falling back to 'en'."));
            }
            locale = Locale.ENGLISH;
        }
        reqCtx.setLocale(locale);
        this.resetOrientation(reqCtx, locale);
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        PortalRequestContext reqCtx = (PortalRequestContext)context;
        Locale loc = reqCtx.getLocale();
        Locale sessLocale = LocalizationLifecycle.getPreviousLocale(reqCtx.getRequest());
        if (loc != null && sessLocale != null && !loc.equals(sessLocale)) {
            this.saveLocale(reqCtx, loc);
            this.resetOrientation(reqCtx, loc);
            this.savePreviousLocale(reqCtx, loc);
        } else if (sessLocale == null) {
            this.savePreviousLocale(reqCtx, loc);
        }
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
    }

    public void onDestroy(Application app) throws Exception {
    }

    private UserProfile loadUserProfile(ExoContainer container, PortalRequestContext context) {
        UserProfile userProfile = null;
        OrganizationService svc = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        String user = context.getRemoteUser();
        if (user != null) {
            try {
                userProfile = svc.getUserProfileHandler().findUserProfileByName(user);
            }
            catch (Exception ignored) {
                log.error((Object)("IGNORED: Failed to load UserProfile for username: " + user), (Throwable)ignored);
            }
            if (userProfile == null && log.isWarnEnabled()) {
                log.warn((Object)("Could not load user profile for " + user + ". Using default portal locale."));
            }
            if (userProfile == null) {
                userProfile = svc.getUserProfileHandler().createUserProfileInstance(user);
            }
        }
        return userProfile;
    }

    public static Locale getPreviousLocale(HttpServletRequest request) {
        return LocalizationLifecycle.getLocaleFromSession(request, PREV_LOCALE_SESSION_ATTR);
    }

    private static Locale getLocaleFromSession(HttpServletRequest request, String attrName) {
        String lang = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            lang = (String)session.getAttribute(attrName);
        }
        return lang != null ? LocaleContextInfo.getLocale(lang) : null;
    }

    private void saveLocale(PortalRequestContext context, Locale loc) {
        String user = context.getRemoteUser();
        if (user != null) {
            this.saveLocaleToUserProfile(context, loc, user);
        } else {
            this.saveLocaleToCookie(context, loc);
        }
        this.saveSessionLocale(context, loc);
    }

    private void resetOrientation(PortalRequestContext context, Locale loc) {
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        LocaleConfigService localeConfigService = (LocaleConfigService)container.getComponentInstanceOfType(LocaleConfigService.class);
        LocaleConfig localeConfig = localeConfigService.getLocaleConfig(LocaleContextInfo.getLocaleAsString((Locale)loc));
        if (localeConfig == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Locale changed to unsupported Locale during request processing: " + loc));
            }
            return;
        }
        ((UIPortalApplication)context.getUIApplication()).setOrientation(localeConfig.getOrientation());
    }

    private void saveSessionLocale(PortalRequestContext context, Locale loc) {
        this.saveLocaleToSession(context, LOCALE_SESSION_ATTR, loc);
    }

    private void savePreviousLocale(PortalRequestContext context, Locale loc) {
        this.saveLocaleToSession(context, PREV_LOCALE_SESSION_ATTR, loc);
    }

    private void saveLocaleToSession(PortalRequestContext context, String attrName, Locale loc) {
        HttpServletRequest res = context.getRequest();
        HttpSession session = res.getSession(false);
        if (session != null) {
            session.setAttribute(attrName, (Object)LocaleContextInfo.getLocaleAsString((Locale)loc));
        }
    }

    private void saveLocaleToCookie(PortalRequestContext context, Locale loc) {
        HttpServletResponse res = context.getResponse();
        Cookie cookie = new Cookie(LOCALE_COOKIE, LocaleContextInfo.getLocaleAsString((Locale)loc));
        cookie.setMaxAge(Integer.MAX_VALUE);
        cookie.setPath("/");
        res.addCookie(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLocaleToUserProfile(PortalRequestContext context, Locale loc, String user) {
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        OrganizationService svc = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        RequestLifeCycle.begin((ExoContainer)container);
        try {
            UserProfile userProfile = this.loadUserProfile(container, context);
            if (userProfile != null) {
                userProfile.getUserInfoMap().put("user.language", LocaleContextInfo.getLocaleAsString((Locale)loc));
                svc.getUserProfileHandler().saveUserProfile(userProfile, false);
            }
            if (userProfile == null && log.isWarnEnabled()) {
                log.warn((Object)("Unable to save locale into profile for user: " + user));
            }
        }
        catch (Exception ignored) {
            log.error((Object)("IGNORED: Failed to save profile for user: " + user), (Throwable)ignored);
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

