/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.page;

import org.gatein.api.common.Filter;
import org.gatein.api.common.Pagination;
import org.gatein.api.internal.ObjectToStringBuilder;
import org.gatein.api.page.Page;
import org.gatein.api.site.SiteId;
import org.gatein.api.site.SiteType;

public class PageQuery {
    private final SiteType siteType;
    private final String siteName;
    private final String displayName;
    private final Pagination pagination;
    private final Filter<Page> filter;

    private PageQuery(SiteType siteType, String siteName, String displayName, Pagination pagination, Filter<Page> filter) {
        this.siteType = siteType;
        this.siteName = siteName;
        this.displayName = displayName;
        this.pagination = pagination;
        this.filter = filter;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public PageQuery nextPage() {
        return new Builder().from(this).withNextPage().build();
    }

    public PageQuery previousPage() {
        return new Builder().from(this).withPreviousPage().build();
    }

    public Filter<Page> getFilter() {
        return this.filter;
    }

    public SiteType getSiteType() {
        return this.siteType;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return ObjectToStringBuilder.toStringBuilder(PageQuery.class).add("siteType", (Object)this.siteType).add("siteName", this.siteName).add("displayName", this.displayName).add("pagination", this.pagination).add("filter", this.filter).toString();
    }

    public static class Builder {
        public static final int DEFAULT_LIMIT = 15;
        public static final Pagination DEFAULT_PAGINATION = new Pagination(0, 15);
        private SiteType siteType;
        private String siteName;
        private String displayName;
        private Filter<Page> filter;
        private Pagination pagination = DEFAULT_PAGINATION;

        public Builder withSiteId(SiteId siteId) {
            return this.withSiteType(siteId.getType()).withSiteName(siteId.getName());
        }

        public Builder withSiteType(SiteType siteType) {
            this.siteType = siteType;
            return this;
        }

        public Builder withSiteName(String siteName) {
            this.siteName = siteName;
            return this;
        }

        public Builder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder withPagination(int offset, int limit) {
            return this.withPagination(new Pagination(offset, limit));
        }

        public Builder withPagination(Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public Builder withNextPage() {
            if (this.pagination != null) {
                this.pagination = this.pagination.getNext();
            }
            return this;
        }

        public Builder withPreviousPage() {
            if (this.pagination != null) {
                this.pagination = this.pagination.getPrevious();
            }
            return this;
        }

        public Builder withFilter(Filter<Page> filter) {
            this.filter = filter;
            return this;
        }

        public PageQuery build() {
            return new PageQuery(this.siteType, this.siteName, this.displayName, this.pagination, this.filter);
        }

        public Builder from(PageQuery query) {
            return new Builder().withSiteType(query.getSiteType()).withSiteName(query.getSiteName()).withDisplayName(query.getDisplayName()).withPagination(query.getPagination()).withFilter(query.getFilter());
        }
    }
}

