/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.xml;

import org.gatein.common.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidationReporter
implements ErrorHandler {
    private final String identifier;
    private boolean valid;
    private Logger log;

    public ValidationReporter(Logger log, String identifier) {
        this.identifier = identifier;
        this.log = log;
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.log.warn((Object)exception.getMessage(), (Throwable)exception);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.log.error((Object)("Error in document " + this.identifier + "  at (" + exception.getLineNumber() + "," + exception.getColumnNumber() + ") :" + exception.getMessage()));
        this.valid = false;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.log.error((Object)("Fatal error in document " + this.identifier + "  at (" + exception.getLineNumber() + "," + exception.getColumnNumber() + ") :" + exception.getMessage()));
        this.valid = false;
    }
}

