/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.util.Collection;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.ImageRenderer;
import org.apache.sis.internal.coverage.ConvertedGridCoverage;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public class BufferedGridCoverage
extends GridCoverage {
    protected final DataBuffer data;
    private GridCoverage converted;

    public BufferedGridCoverage(GridGeometry gridGeometry, Collection<? extends SampleDimension> collection, DataBuffer dataBuffer) {
        super(gridGeometry, collection);
        this.data = dataBuffer;
        ArgumentChecks.ensureNonNull((String)"data", (Object)dataBuffer);
    }

    public BufferedGridCoverage(GridGeometry gridGeometry, Collection<? extends SampleDimension> collection, int n) {
        super(gridGeometry, collection);
        long l = collection.size();
        GridExtent gridExtent = gridGeometry.getExtent();
        int n2 = gridGeometry.getDimension();
        while (--n2 >= 0) {
            l = Math.multiplyExact(l, gridExtent.getSize(n2));
        }
        n2 = Math.toIntExact(l);
        switch (n) {
            case 0: {
                this.data = new DataBufferByte(n2);
                break;
            }
            case 2: {
                this.data = new DataBufferShort(n2);
                break;
            }
            case 1: {
                this.data = new DataBufferUShort(n2);
                break;
            }
            case 3: {
                this.data = new DataBufferInt(n2);
                break;
            }
            case 4: {
                this.data = new DataBufferFloat(n2);
                break;
            }
            case 5: {
                this.data = new DataBufferDouble(n2);
                break;
            }
            default: {
                throw new IllegalArgumentException(Errors.format((short)149, (Object)n));
            }
        }
    }

    @Override
    public RenderedImage render(GridExtent gridExtent) {
        try {
            ImageRenderer imageRenderer = new ImageRenderer(this, gridExtent);
            imageRenderer.setData(this.data);
            return imageRenderer.image();
        }
        catch (RasterFormatException | ArithmeticException | IllegalArgumentException runtimeException) {
            throw new RuntimeException(runtimeException.getMessage(), runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCoverage forConvertedValues(boolean bl) {
        if (bl) {
            BufferedGridCoverage bufferedGridCoverage = this;
            synchronized (bufferedGridCoverage) {
                if (this.converted == null) {
                    this.converted = BufferedGridCoverage.convert(this);
                }
                return this.converted;
            }
        }
        return this;
    }

    public static GridCoverage convert(GridCoverage gridCoverage) {
        return ConvertedGridCoverage.create(gridCoverage);
    }
}

