/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.malwareDetection;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.service.malwareDetection.connector.MalwareDetectionConnector;
import org.exoplatform.social.service.malwareDetection.connector.MalwareDetectionItemConnector;

public class MalwareDetectionService {
    private Map<String, MalwareDetectionItemConnector> malwareDetectionItemConnectors = new HashMap<String, MalwareDetectionItemConnector>();
    private Map<String, MalwareDetectionConnector> malwareDetectionConnectors = new HashMap<String, MalwareDetectionConnector>();
    private static final Log LOGGER = ExoLogger.getExoLogger(MalwareDetectionService.class);

    public void addMalwareDetectionItemConnector(MalwareDetectionItemConnector malwareDetectionItemConnector) {
        this.addMalwareDetectionItemConnector(malwareDetectionItemConnector, false);
    }

    public void addMalwareDetectionConnector(MalwareDetectionConnector malwareDetectionConnector) {
        this.addMalwareDetectionConnector(malwareDetectionConnector, false);
    }

    public void addMalwareDetectionItemConnector(MalwareDetectionItemConnector malwareDetectionItemConnector, Boolean override) {
        if (this.malwareDetectionItemConnectors.containsKey(malwareDetectionItemConnector.getType()) && override.equals(false)) {
            LOGGER.error("Impossible to add malware detection item connector {}. A malware detection item with the same type has already been registered.", new Object[]{malwareDetectionItemConnector.getType()});
        } else {
            this.malwareDetectionItemConnectors.put(malwareDetectionItemConnector.getType(), malwareDetectionItemConnector);
            LOGGER.info("A Malware detection item connector has been added: {}", new Object[]{malwareDetectionItemConnector.getType()});
        }
    }

    public void addMalwareDetectionConnector(MalwareDetectionConnector malwareDetectionConnector, Boolean override) {
        if (this.malwareDetectionConnectors.containsKey(malwareDetectionConnector.getType()) && override.equals(false)) {
            LOGGER.error("Impossible to add malware detection connector {}. A malware detection item with the same type has already been registered.", new Object[]{malwareDetectionConnector.getType()});
        } else {
            this.malwareDetectionConnectors.put(malwareDetectionConnector.getType(), malwareDetectionConnector);
            LOGGER.info("A Malware detection connector has been added: {}", new Object[]{malwareDetectionConnector.getType()});
        }
    }

    public Map<String, MalwareDetectionItemConnector> getMalwareDetectionItemConnectors() {
        return this.malwareDetectionItemConnectors;
    }

    public Map<String, MalwareDetectionConnector> getMalwareDetectionConnectors() {
        return this.malwareDetectionConnectors;
    }

    public MalwareDetectionConnector getDefaultMalwareDetectionConnector() {
        for (Map.Entry<String, MalwareDetectionConnector> malwareDetectionConnectorEntry : this.malwareDetectionConnectors.entrySet()) {
            MalwareDetectionConnector malwareDetectionConnector = malwareDetectionConnectorEntry.getValue();
            if (!malwareDetectionConnector.isDefault()) continue;
            return malwareDetectionConnector;
        }
        return null;
    }

    public void checkAndProcessNewInfectedItems() {
        MalwareDetectionConnector defaultMalwareDetectionConnector = this.getDefaultMalwareDetectionConnector();
        if (defaultMalwareDetectionConnector != null) {
            List<String> newInfectedItemsPaths = defaultMalwareDetectionConnector.getInfectedItemsPaths();
            for (String newInfectedItemPath : newInfectedItemsPaths) {
                this.processInfectedItem(newInfectedItemPath);
            }
        }
    }

    public void processInfectedItem(String infectedItemPath) {
        for (Map.Entry<String, MalwareDetectionItemConnector> malwareDetectionItemConnectorEntry : this.malwareDetectionItemConnectors.entrySet()) {
            MalwareDetectionItemConnector malwareDetectionItemConnector = malwareDetectionItemConnectorEntry.getValue();
            if (!malwareDetectionItemConnector.canProcessInfectedItem(infectedItemPath)) continue;
            malwareDetectionItemConnector.processInfectedItem(infectedItemPath);
        }
    }
}

