/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.ucar.DecoderWrapper;
import org.apache.sis.internal.netcdf.ucar.DimensionWrapper;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import ucar.nc2.VariableIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;

final class GridWrapper
extends Grid {
    private final CoordinateSystem netcdfCS;
    private final List<ucar.nc2.Dimension> domain;
    private final Map<List<ucar.nc2.Dimension>, GridWrapper> reordered;

    GridWrapper(CoordinateSystem coordinateSystem) {
        this.netcdfCS = coordinateSystem;
        this.domain = coordinateSystem.getDomain();
        this.reordered = new HashMap<List<ucar.nc2.Dimension>, GridWrapper>(4);
    }

    private GridWrapper(GridWrapper gridWrapper, List<ucar.nc2.Dimension> list) {
        this.netcdfCS = gridWrapper.netcdfCS;
        this.domain = list;
        this.reordered = gridWrapper.reordered;
        assert (this.netcdfCS.getDomain().containsAll(list));
    }

    @Override
    protected Grid forDimensions(Dimension[] dimensionArray) {
        return this.forDimensions((List<ucar.nc2.Dimension>)UnmodifiableArrayList.wrap((Object[])DimensionWrapper.unwrap(dimensionArray)));
    }

    private GridWrapper forDimensions(List<ucar.nc2.Dimension> list2) {
        if (list2.size() > this.domain.size()) {
            list2 = new ArrayList<ucar.nc2.Dimension>(list2);
            list2.retainAll(this.domain);
        }
        if (this.domain.equals(list2)) {
            return this;
        }
        return this.reordered.computeIfAbsent(list2, list -> {
            if (this.domain.size() == list.size() && this.domain.containsAll((Collection<?>)list)) {
                return new GridWrapper(this, (List<ucar.nc2.Dimension>)list);
            }
            return null;
        });
    }

    final GridWrapper forVariable(VariableIF variableIF, List<CoordinateSystem> list, String[] stringArray) {
        if (list.contains(this.netcdfCS) && this.containsAllNamedAxes(stringArray)) {
            return this.forDimensions(variableIF.getDimensions());
        }
        return null;
    }

    @Override
    public String getName() {
        return this.netcdfCS.getName();
    }

    @Override
    public int getSourceDimensions() {
        return this.netcdfCS.getRankDomain();
    }

    @Override
    public int getTargetDimensions() {
        return this.netcdfCS.getRankRange();
    }

    @Override
    protected List<Dimension> getDimensions() {
        return DimensionWrapper.wrap(this.domain);
    }

    @Override
    protected boolean containsAllNamedAxes(String[] stringArray) {
        if (stringArray != null) {
            block0: for (String string : stringArray) {
                for (CoordinateAxis coordinateAxis : this.netcdfCS.getCoordinateAxes()) {
                    if (!string.equalsIgnoreCase(coordinateAxis.getShortName())) continue;
                    continue block0;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected Axis[] createAxes(Decoder decoder) throws IOException, DataStoreException {
        List list = this.netcdfCS.getCoordinateAxes();
        int n = list.size();
        Object[] objectArray = new Axis[n];
        while (--n >= 0) {
            CoordinateAxis coordinateAxis = (CoordinateAxis)list.get(n);
            char c = '\u0000';
            AxisType axisType = coordinateAxis.getAxisType();
            if (axisType != null) {
                switch (axisType) {
                    case GeoX: {
                        c = this.netcdfCS.isGeoXY() ? (char)'E' : 'x';
                        break;
                    }
                    case GeoY: {
                        c = this.netcdfCS.isGeoXY() ? (char)'N' : 'y';
                        break;
                    }
                    case GeoZ: {
                        c = this.netcdfCS.isGeoXY() ? (char)'H' : 'z';
                        break;
                    }
                    case Lon: {
                        c = '\u03bb';
                        break;
                    }
                    case Lat: {
                        c = '\u03c6';
                        break;
                    }
                    case Pressure: 
                    case Height: {
                        c = 'H';
                        break;
                    }
                    case RunTime: 
                    case Time: {
                        c = 't';
                        break;
                    }
                    case RadialAzimuth: {
                        c = '\u03b8';
                        break;
                    }
                    case RadialElevation: {
                        c = '\u03a9';
                        break;
                    }
                    case RadialDistance: {
                        c = 'r';
                    }
                }
            }
            int n2 = 0;
            List list2 = coordinateAxis.getDimensions();
            int[] nArray = new int[list2.size()];
            int[] nArray2 = new int[nArray.length];
            for (ucar.nc2.Dimension dimension : list2) {
                int n3 = this.domain.lastIndexOf(dimension);
                if (n3 < 0) continue;
                nArray[n2] = n3;
                nArray2[n2++] = dimension.getLength();
            }
            objectArray[n] = new Axis(c, coordinateAxis.getPositive(), ArraysExt.resize((int[])nArray, (int)n2), ArraysExt.resize((int[])nArray2, (int)n2), ((DecoderWrapper)decoder).getWrapperFor((VariableIF)coordinateAxis));
        }
        int n4 = Math.min(this.domain.size(), list.size());
        while (--n4 >= 0) {
            List list3 = ((CoordinateAxis)list.get(n4)).getDimensions();
            if (list3.size() == 1 && ((ucar.nc2.Dimension)list3.get(0)).equals((Object)this.domain.get(n4))) continue;
            return objectArray;
        }
        ArraysExt.reverse((Object[])objectArray);
        return objectArray;
    }
}

