/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.referencing.provider.AbridgedMolodensky;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.internal.referencing.provider.DatumShiftMethod;
import org.apache.sis.internal.referencing.provider.GeocentricTranslation;
import org.apache.sis.internal.referencing.provider.GeocentricTranslation2D;
import org.apache.sis.internal.referencing.provider.GeocentricTranslation3D;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.internal.referencing.provider.Geographic2Dto3D;
import org.apache.sis.internal.referencing.provider.Geographic3Dto2D;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.internal.referencing.provider.PositionVector7Param;
import org.apache.sis.internal.referencing.provider.PositionVector7Param2D;
import org.apache.sis.internal.referencing.provider.PositionVector7Param3D;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

@XmlTransient
public abstract class GeocentricAffine
extends GeodeticOperation {
    private static final long serialVersionUID = 8291967302538661639L;
    private static final double BURSAWOLF_TOLERANCE = 1.0E-6;
    public static final ParameterDescriptor<Double> TX;
    public static final ParameterDescriptor<Double> TY;
    public static final ParameterDescriptor<Double> TZ;
    static final ParameterDescriptor<Double> RX;
    static final ParameterDescriptor<Double> RY;
    static final ParameterDescriptor<Double> RZ;
    static final ParameterDescriptor<Double> DS;
    static final int TRANSLATION = 1;
    static final int SEVEN_PARAM = 2;
    static final int FRAME_ROTATION = 3;
    static final int OTHER = 0;

    private static ParameterDescriptor<Double> createRotation(ParameterBuilder parameterBuilder, String string, String string2) {
        return ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName(string)).addName((Citation)Citations.OGC, string2)).createBounded(-648000.0, 648000.0, 0.0, Units.ARC_SECOND);
    }

    GeocentricAffine(int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup, GeodeticOperation[] geodeticOperationArray) {
        super(n, n2, parameterDescriptorGroup, geodeticOperationArray);
    }

    abstract int getType();

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws FactoryException {
        BursaWolfParameters bursaWolfParameters = new BursaWolfParameters(null, null);
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        boolean bl = false;
        switch (this.getType()) {
            default: {
                throw new AssertionError();
            }
            case 3: {
                bl = true;
            }
            case 2: {
                bursaWolfParameters.rX = parameters.doubleValue(RX);
                bursaWolfParameters.rY = parameters.doubleValue(RY);
                bursaWolfParameters.rZ = parameters.doubleValue(RZ);
                bursaWolfParameters.dS = parameters.doubleValue(DS);
            }
            case 1: 
        }
        bursaWolfParameters.tX = parameters.doubleValue(TX);
        bursaWolfParameters.tY = parameters.doubleValue(TY);
        bursaWolfParameters.tZ = parameters.doubleValue(TZ);
        if (bl) {
            bursaWolfParameters.reverseRotation();
        }
        return MathTransforms.linear(bursaWolfParameters.getPositionVectorTransformation(null));
    }

    private static Parameters createParameters(ParameterDescriptorGroup parameterDescriptorGroup, BursaWolfParameters bursaWolfParameters, boolean bl) {
        Parameters parameters = Parameters.castOrWrap(parameterDescriptorGroup.createValue());
        parameters.getOrCreate(TX).setValue(bursaWolfParameters.tX);
        parameters.getOrCreate(TY).setValue(bursaWolfParameters.tY);
        parameters.getOrCreate(TZ).setValue(bursaWolfParameters.tZ);
        if (!bl) {
            parameters.getOrCreate(RX).setValue(bursaWolfParameters.rX);
            parameters.getOrCreate(RY).setValue(bursaWolfParameters.rY);
            parameters.getOrCreate(RZ).setValue(bursaWolfParameters.rZ);
            parameters.getOrCreate(DS).setValue(bursaWolfParameters.dS);
        }
        return parameters;
    }

    public static ParameterValueGroup createParameters(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2, Matrix matrix, DatumShiftMethod datumShiftMethod) {
        ParameterDescriptorGroup parameterDescriptorGroup;
        boolean bl = coordinateSystem instanceof EllipsoidalCS;
        if (!(!bl ? coordinateSystem2 instanceof CartesianCS && coordinateSystem instanceof CartesianCS : coordinateSystem2 instanceof EllipsoidalCS)) {
            return null;
        }
        int n = coordinateSystem.getDimension();
        if (n != coordinateSystem2.getDimension()) {
            n = 4;
        }
        if (datumShiftMethod == DatumShiftMethod.NONE) {
            if (n <= 3) {
                return Affine.identity(n);
            }
            if (bl) {
                ParameterDescriptorGroup parameterDescriptorGroup2;
                switch (coordinateSystem.getDimension()) {
                    case 2: {
                        parameterDescriptorGroup2 = Geographic2Dto3D.PARAMETERS;
                        break;
                    }
                    case 3: {
                        parameterDescriptorGroup2 = Geographic3Dto2D.PARAMETERS;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return parameterDescriptorGroup2.createValue();
            }
            return null;
        }
        BursaWolfParameters bursaWolfParameters = new BursaWolfParameters(null, null);
        if (matrix != null) {
            try {
                bursaWolfParameters.setPositionVectorTransformation(matrix, 1.0E-6);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                GeocentricAffine.log("org.apache.sis.referencing.operation", "createParameters", illegalArgumentException);
                return null;
            }
        } else {
            datumShiftMethod = DatumShiftMethod.ABRIDGED_MOLODENSKY;
        }
        boolean bl2 = bursaWolfParameters.isTranslation();
        if (!bl) {
            datumShiftMethod = DatumShiftMethod.GEOCENTRIC_DOMAIN;
            parameterDescriptorGroup = bl2 ? GeocentricTranslation.PARAMETERS : PositionVector7Param.PARAMETERS;
        } else if (!bl2) {
            datumShiftMethod = DatumShiftMethod.GEOCENTRIC_DOMAIN;
            parameterDescriptorGroup = n >= 3 ? PositionVector7Param3D.PARAMETERS : PositionVector7Param2D.PARAMETERS;
        } else {
            switch (datumShiftMethod) {
                case GEOCENTRIC_DOMAIN: {
                    parameterDescriptorGroup = n >= 3 ? GeocentricTranslation3D.PARAMETERS : GeocentricTranslation2D.PARAMETERS;
                    break;
                }
                case MOLODENSKY: {
                    parameterDescriptorGroup = Molodensky.PARAMETERS;
                    break;
                }
                case ABRIDGED_MOLODENSKY: {
                    parameterDescriptorGroup = AbridgedMolodensky.PARAMETERS;
                    break;
                }
                default: {
                    throw new AssertionError((Object)datumShiftMethod);
                }
            }
        }
        Parameters parameters = GeocentricAffine.createParameters(parameterDescriptorGroup, bursaWolfParameters, bl2);
        switch (datumShiftMethod) {
            case MOLODENSKY: 
            case ABRIDGED_MOLODENSKY: {
                if (n > 3) break;
                parameters.getOrCreate(Molodensky.DIMENSION).setValue(n);
            }
        }
        return parameters;
    }

    public static void asDatumShift(List<Object> list) {
        int n = list.size() - 2;
        while (--n >= 0) {
            Object object;
            if (!GeocentricAffine.isOperation("Ellipsoid_To_Geocentric", list.get(n)) || !GeocentricAffine.isOperation("Geocentric_To_Ellipsoid", list.get(n + 2)) || !((object = list.get(n + 1)) instanceof LinearTransform)) continue;
            BursaWolfParameters bursaWolfParameters = new BursaWolfParameters(null, null);
            try {
                bursaWolfParameters.setPositionVectorTransformation(((LinearTransform)object).getMatrix(), 1.0E-6);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                GeocentricAffine.log("org.apache.sis.io.wkt", "asDatumShift", illegalArgumentException);
                continue;
            }
            boolean bl = bursaWolfParameters.isTranslation();
            final Parameters parameters = GeocentricAffine.createParameters(bl ? GeocentricTranslation.PARAMETERS : PositionVector7Param.PARAMETERS, bursaWolfParameters, bl);
            list.set(n + 1, new FormattableObject(){

                @Override
                protected String formatTo(Formatter formatter) {
                    WKTUtilities.appendParamMT(parameters, formatter);
                    return "Param_MT";
                }
            });
        }
    }

    private static boolean isOperation(String string, Object object) {
        return object instanceof Parameterized && IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)((Parameterized)object).getParameterDescriptors(), string);
    }

    private static void log(String string, String string2, Exception exception) {
        Logging.recoverableException((Logger)Logging.getLogger((String)string), GeocentricAffine.class, (String)string2, (Throwable)exception);
    }

    static {
        ParameterBuilder parameterBuilder = GeocentricAffine.builder();
        TX = GeocentricAffine.createShift((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8605")).addName("X-axis translation")).addName((Citation)Citations.OGC, "dx"));
        TY = GeocentricAffine.createShift((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8606")).addName("Y-axis translation")).addName((Citation)Citations.OGC, "dy"));
        TZ = GeocentricAffine.createShift((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8607")).addName("Z-axis translation")).addName((Citation)Citations.OGC, "dz"));
        RX = GeocentricAffine.createRotation((ParameterBuilder)parameterBuilder.addIdentifier("8608"), "X-axis rotation", "ex");
        RY = GeocentricAffine.createRotation((ParameterBuilder)parameterBuilder.addIdentifier("8609"), "Y-axis rotation", "ey");
        RZ = GeocentricAffine.createRotation((ParameterBuilder)parameterBuilder.addIdentifier("8610"), "Z-axis rotation", "ez");
        DS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8611")).addName("Scale difference")).addName((Citation)Citations.OGC, "ppm")).create(0.0, Units.PPM);
    }
}

