/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.util.Map;
import org.hibernate.cache.internal.NoCachingRegionFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class RegionFactoryInitiator
implements BasicServiceInitiator<RegionFactory> {
    public static final RegionFactoryInitiator INSTANCE = new RegionFactoryInitiator();
    public static final String IMPL_NAME = "hibernate.cache.region.factory_class";

    @Override
    public Class<RegionFactory> getServiceInitiated() {
        return RegionFactory.class;
    }

    @Override
    public RegionFactory initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        Object impl = configurationValues.get(IMPL_NAME);
        if (impl == null) {
            return new NoCachingRegionFactory();
        }
        if (this.getServiceInitiated().isInstance(impl)) {
            return (RegionFactory)impl;
        }
        Class customImplClass = null;
        customImplClass = Class.class.isInstance(impl) ? (Class)impl : registry.getService(ClassLoaderService.class).classForName(RegionFactoryInitiator.mapLegacyNames(impl.toString()));
        try {
            return (RegionFactory)customImplClass.newInstance();
        }
        catch (Exception e) {
            throw new ServiceException("Could not initialize custom RegionFactory impl [" + customImplClass.getName() + "]", e);
        }
    }

    public static String mapLegacyNames(String name) {
        if ("org.hibernate.cache.EhCacheRegionFactory".equals(name)) {
            return "org.hibernate.cache.ehcache.EhCacheRegionFactory";
        }
        if ("org.hibernate.cache.SingletonEhCacheRegionFactory".equals(name)) {
            return "org.hibernate.cache.ehcache.SingletonEhCacheRegionFactory";
        }
        return name;
    }
}

