/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.types;

import java.io.Serializable;
import org.picketlink.idm.common.exception.PolicyValidationException;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectType;

public class SimpleIdentityObject
implements IdentityObject,
Serializable {
    private final String name;
    private final String id;
    private final IdentityObjectType type;

    public SimpleIdentityObject(String name, String id, IdentityObjectType type) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.name = name;
        this.id = id;
        this.type = type;
    }

    public SimpleIdentityObject(String name, IdentityObjectType type) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.name = name;
        this.type = type;
        this.id = null;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public IdentityObjectType getIdentityType() {
        return this.type;
    }

    public void validatePolicy() throws PolicyValidationException {
    }

    public String toString() {
        return "IdentityObject[id=" + this.getId() + "; name=" + this.getName() + "; type=" + this.getIdentityType().getName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentityObject)) {
            return false;
        }
        IdentityObject that = (IdentityObject)o;
        if (this.name != null ? !this.name.equals(that.getName()) : that.getName() != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.getIdentityType()) : that.getIdentityType() != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

