/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.GenericScope;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeFilter;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.navigation.VisitMode;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeContext;
import org.exoplatform.portal.mop.user.UserNodeFilter;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserNodeListener;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.portal.mop.user.UserPortalException;
import org.exoplatform.portal.mop.user.Utils;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class UserPortalImpl
implements UserPortal {
    public static final Comparator<UserNavigation> USER_NAVIGATION_COMPARATOR = new Comparator<UserNavigation>(){

        @Override
        public int compare(UserNavigation nav1, UserNavigation nav2) {
            int priority2;
            int priority1 = nav1.getPriority();
            if (priority1 == (priority2 = nav2.getPriority())) {
                return 0;
            }
            if (priority1 == -1) {
                return 1;
            }
            if (priority2 == -1) {
                return -1;
            }
            return priority1 - priority2;
        }
    };
    private final Logger log = LoggerFactory.getLogger(UserPortalImpl.class);
    final UserPortalConfigService service;
    private final PortalConfig portalConfig;
    final UserPortalContext context;
    final String userName;
    private List<UserNavigation> navigations;
    private final String portalName;
    private final Locale portalLocale;

    public UserPortalImpl(UserPortalConfigService service, String portalName, PortalConfig portal, String userName, UserPortalContext context) {
        if (context == null) {
            throw new NullPointerException("No null context argument allowed");
        }
        String locale = portal.getLocale();
        this.portalLocale = locale != null ? new Locale(locale) : null;
        this.service = service;
        this.portalName = portalName;
        this.portalConfig = portal;
        this.userName = userName;
        this.context = context;
        this.navigations = null;
    }

    @Override
    public Locale getLocale() {
        return this.portalLocale;
    }

    public PortalConfig getPortalConfig() {
        return this.portalConfig;
    }

    @Override
    public List<UserNavigation> getNavigations() throws UserPortalException, NavigationServiceException {
        if (this.navigations == null) {
            NavigationContext globalPortalNav;
            ArrayList<UserNavigation> navigations = new ArrayList<UserNavigation>(this.userName == null ? 1 : 10);
            NavigationContext portalNav = this.service.getNavigationService().loadNavigation(new SiteKey(SiteType.PORTAL, this.portalName));
            if (portalNav != null && portalNav.getState() != null) {
                navigations.add(new UserNavigation(this, portalNav, this.service.getUserACL().hasEditPermission(this.portalConfig)));
            }
            if (this.userName != null) {
                NavigationContext userNavigation = this.service.getNavigationService().loadNavigation(SiteKey.user((String)this.userName));
                if (userNavigation != null && userNavigation.getState() != null) {
                    navigations.add(new UserNavigation(this, userNavigation, true));
                }
                if (this.service.getUserACL().getSuperUser().equals(this.userName)) {
                    List navCtxs = this.service.getNavigationService().loadNavigations(SiteType.GROUP);
                    for (NavigationContext navCtx : navCtxs) {
                        if (navCtx.getKey().getName().equals(this.service.getUserACL().getGuestsGroup())) continue;
                        navigations.add(new UserNavigation(this, navCtx, true));
                    }
                } else {
                    Collection groups;
                    block12: {
                        groups = null;
                        try {
                            ConversationState conv = ConversationState.getCurrent();
                            groups = conv != null && conv.getIdentity() != null && !IdentityConstants.ANONIM.equals(conv.getIdentity().getUserId()) && !IdentityConstants.SYSTEM.equals(conv.getIdentity().getUserId()) ? conv.getIdentity().getGroups() : this.service.getOrganizationService().getGroupHandler().findGroupsOfUser(this.userName);
                        }
                        catch (Exception e) {
                            if (!this.log.isDebugEnabled()) break block12;
                            this.log.debug((Object)"Could not retrieve groups", (Throwable)e);
                        }
                    }
                    if (groups != null) {
                        for (Object group : groups) {
                            NavigationContext groupNavigation;
                            String groupId = null;
                            groupId = group instanceof Group ? ((Group)group).getId().trim() : group.toString().trim();
                            if (groupId.equals(this.service.getUserACL().getGuestsGroup()) || (groupNavigation = this.service.getNavigationService().loadNavigation(SiteKey.group((String)groupId))) == null || groupNavigation.getState() == null) continue;
                            navigations.add(new UserNavigation(this, groupNavigation, this.service.getUserACL().hasEditPermissionOnNavigation(groupNavigation.getKey())));
                        }
                    }
                }
                Collections.sort(navigations, USER_NAVIGATION_COMPARATOR);
            }
            if ((globalPortalNav = this.service.getNavigationService().loadNavigation(new SiteKey(SiteType.PORTAL, this.service.getGlobalPortal()))) != null && globalPortalNav.getState() != null) {
                navigations.add(new UserNavigation(this, globalPortalNav, false));
            }
            this.navigations = Collections.unmodifiableList(navigations);
        }
        return this.navigations;
    }

    @Override
    public Collection<UserNode> getNodes(SiteType siteType, String excludedSiteName, Scope scope, UserNodeFilterConfig filterConfig) {
        ArrayList<UserNode> resultUserNodes = new ArrayList<UserNode>();
        HashSet<String> addedUserNodesURI = new HashSet<String>();
        List<UserNavigation> userNavigations = this.getNavigations();
        for (UserNavigation userNavigation : userNavigations) {
            SiteKey siteKey = userNavigation.getKey();
            if (siteKey.getType() != siteType || StringUtils.isNotBlank((CharSequence)excludedSiteName) && Pattern.matches(excludedSiteName, siteKey.getName())) continue;
            UserNode rootNode = this.getNode(userNavigation, scope, filterConfig, null);
            Collection<UserNode> userNodes = rootNode.getChildren();
            for (UserNode userNode : userNodes) {
                if (addedUserNodesURI.contains(userNode.getURI())) continue;
                addedUserNodesURI.add(userNode.getURI());
                resultUserNodes.add(userNode);
            }
        }
        return resultUserNodes;
    }

    @Override
    public Collection<UserNode> getNodes(SiteType siteType, Scope scope, UserNodeFilterConfig filterConfig) {
        return this.getNodes(siteType, null, scope, filterConfig);
    }

    @Override
    public UserNavigation getNavigation(SiteKey key) throws NullPointerException, UserPortalException, NavigationServiceException {
        if (key == null) {
            throw new NullPointerException("No null key accepted");
        }
        for (UserNavigation navigation : this.getNavigations()) {
            if (!navigation.getKey().equals((Object)key)) continue;
            return navigation;
        }
        return null;
    }

    @Override
    public void refresh() {
        this.navigations = null;
    }

    @Override
    public UserNode getNode(UserNavigation userNavigation, Scope scope, UserNodeFilterConfig filterConfig, NodeChangeListener<UserNode> listener) throws NullPointerException, UserPortalException, NavigationServiceException {
        UserNodeContext context = new UserNodeContext(userNavigation, filterConfig);
        NodeContext nodeContext = this.service.getNavigationService().loadNode((NodeModel)context, userNavigation.navigation, scope, (NodeChangeListener)new UserNodeListener(listener));
        if (nodeContext != null) {
            return ((UserNode)nodeContext.getNode()).filter();
        }
        return null;
    }

    @Override
    public void updateNode(UserNode node, Scope scope, NodeChangeListener<UserNode> listener) throws NullPointerException, IllegalArgumentException, UserPortalException, NavigationServiceException {
        if (node == null) {
            throw new NullPointerException("No null node accepted");
        }
        this.service.getNavigationService().updateNode(node.context, scope, (NodeChangeListener)new UserNodeListener(listener));
        node.filter();
    }

    @Override
    public void rebaseNode(UserNode node, Scope scope, NodeChangeListener<UserNode> listener) throws NullPointerException, IllegalArgumentException, UserPortalException, NavigationServiceException {
        if (node == null) {
            throw new NullPointerException("No null node accepted");
        }
        this.service.getNavigationService().rebaseNode(node.context, scope, (NodeChangeListener)new UserNodeListener(listener));
        node.filter();
    }

    @Override
    public void saveNode(UserNode node, NodeChangeListener<UserNode> listener) throws NullPointerException, UserPortalException, NavigationServiceException {
        if (node == null) {
            throw new NullPointerException("No null node accepted");
        }
        this.service.getNavigationService().saveNode(node.context, (NodeChangeListener)new UserNodeListener(listener));
        this.navigations = null;
        node.filter();
    }

    @Override
    public UserNode getDefaultPath(UserNodeFilterConfig filterConfig) throws UserPortalException, NavigationServiceException {
        for (UserNavigation userNavigation : this.getNavigations()) {
            UserNode node = this.getDefaultPath(userNavigation, filterConfig);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public UserNode getDefaultPath(UserNavigation userNavigation, UserNodeFilterConfig filterConfig) throws UserPortalException, NavigationServiceException {
        NavigationContext navigation = userNavigation.navigation;
        if (navigation.getState() != null) {
            UserNodeContext context = new UserNodeContext(userNavigation, null);
            NodeContext nodeContext = this.service.getNavigationService().loadNode((NodeModel)context, navigation, Scope.CHILDREN, null);
            if (nodeContext != null) {
                UserNode root = (UserNode)nodeContext.getNode();
                if (filterConfig == null) {
                    filterConfig = UserNodeFilterConfig.builder().build();
                }
                UserNodeFilter filter = new UserNodeFilter(userNavigation.portal, filterConfig);
                for (UserNode node : root.getChildren()) {
                    if (!node.context.accept((NodeFilter)filter)) continue;
                    return node;
                }
            }
        }
        return null;
    }

    @Override
    public UserNode resolvePath(UserNodeFilterConfig filterConfig, String path) throws NullPointerException, UserPortalException, NavigationServiceException {
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        String[] segments = Utils.parsePath(path);
        if (segments == null) {
            return this.getDefaultPath(filterConfig);
        }
        filterConfig = filterConfig == null ? UserNodeFilterConfig.builder().build() : UserNodeFilterConfig.builder(filterConfig).build();
        filterConfig.path = segments;
        List<UserNavigation> navigations = this.getNavigations();
        MatchingScope best = null;
        for (UserNavigation navigation : navigations) {
            MatchingScope scope = new MatchingScope(navigation, filterConfig, segments);
            scope.resolve();
            if (scope.score == segments.length) {
                best = scope;
                break;
            }
            if (best == null) {
                best = scope;
                continue;
            }
            if (scope.score <= best.score) continue;
            best = scope;
        }
        if (best != null && best.score > 0) {
            UserNode ret = best.userNode;
            if (ret != null) {
                ret.owner.filterConfig.path = null;
            }
            return ret;
        }
        return this.getDefaultPath(null);
    }

    @Override
    public UserNode resolvePath(UserNavigation navigation, UserNodeFilterConfig filterConfig, String path) throws NullPointerException, UserPortalException, NavigationServiceException {
        if (navigation == null) {
            throw new NullPointerException("No null navigation accepted");
        }
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        String[] segments = Utils.parsePath(path);
        if (segments == null) {
            return null;
        }
        filterConfig = filterConfig == null ? UserNodeFilterConfig.builder().build() : UserNodeFilterConfig.builder(filterConfig).build();
        filterConfig.path = segments;
        MatchingScope scope = new MatchingScope(navigation, filterConfig, segments);
        scope.resolve();
        if (scope.score > 0) {
            UserNode globalNode;
            UserNode ret = scope.userNode;
            if (ret != null && !StringUtils.equals((CharSequence)scope.userNode.getURI(), (CharSequence)ret.getURI()) && (globalNode = this.getGlobalUserNode(filterConfig, navigation.getKey(), segments)) != null) {
                return globalNode;
            }
            if (ret != null) {
                ret.owner.filterConfig.path = null;
            }
            return ret;
        }
        return this.getGlobalUserNode(filterConfig, navigation.getKey(), segments);
    }

    private UserNode getGlobalUserNode(UserNodeFilterConfig filterConfig, SiteKey siteKey, String[] segments) {
        if (siteKey.getType() != SiteType.PORTAL) {
            return null;
        }
        UserNavigation globalNavigation = this.getNavigation(SiteKey.portal((String)this.service.getGlobalPortal()));
        if (globalNavigation != null) {
            MatchingScope globalScope = new MatchingScope(globalNavigation, filterConfig, segments);
            globalScope.resolve();
            if (globalScope.score > 0) {
                UserNode globalNode = globalScope.userNode;
                if (globalNode != null) {
                    globalNode.owner.filterConfig.path = null;
                }
                if (globalNode != null && StringUtils.equals((CharSequence)globalScope.userNode.getURI(), (CharSequence)globalNode.getURI())) {
                    return globalNode;
                }
            }
        }
        return null;
    }

    private class MatchingScope
    extends GenericScope.Branch.Visitor
    implements Scope {
        final UserNavigation userNavigation;
        final UserNodeFilterConfig filterConfig;
        final String[] match;
        int score;
        String id;
        UserNode userNode;

        MatchingScope(UserNavigation userNavigation, UserNodeFilterConfig filterConfig, String[] match) {
            this.userNavigation = userNavigation;
            this.filterConfig = filterConfig;
            this.match = match;
        }

        public Scope.Visitor get() {
            return this;
        }

        protected int getSize() {
            return this.match.length;
        }

        protected String getName(int index) {
            return this.match[index];
        }

        protected Scope.Visitor getFederated() {
            return Scope.CHILDREN.get();
        }

        void resolve() throws NavigationServiceException {
            UserNodeContext context = new UserNodeContext(this.userNavigation, this.filterConfig);
            NodeContext nodeContext = UserPortalImpl.this.service.getNavigationService().loadNode((NodeModel)context, this.userNavigation.navigation, (Scope)this, null);
            if (this.score > 0) {
                this.userNode = ((UserNode)nodeContext.getNode()).filter().find(this.id);
            }
        }

        public VisitMode enter(int depth, String id, String name, NodeState state) {
            VisitMode vm = super.enter(depth, id, name, state);
            if (depth == 0) {
                this.score = 0;
                this.id = null;
            } else if (vm == VisitMode.ALL_CHILDREN) {
                this.id = id;
                ++this.score;
            }
            return vm;
        }
    }
}

