/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.infinispan.distributed;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.services.cache.CacheInfo;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.ispn.AbstractMapper;
import org.exoplatform.services.ispn.DistributedCacheManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;

public class DistributedExoCache<K extends Serializable, V>
implements ExoCache<K, V> {
    private static final Log LOG = ExoLogger.getLogger(DistributedExoCache.class);
    public static final String CACHE_NAME = "eXoCache";
    private final AtomicInteger hits = new AtomicInteger(0);
    private final AtomicInteger misses = new AtomicInteger(0);
    private String label;
    private String name;
    private final String fullName;
    private boolean distributed;
    private boolean replicated;
    private boolean logEnabled;
    private static final ConcurrentMap<Cache, ConcurrentMap<String, List<ListenerContext>>> ALL_LISTENERS = new ConcurrentHashMap<Cache, ConcurrentMap<String, List<ListenerContext>>>();
    protected final AdvancedCache<CacheKey<K>, V> cache;

    public DistributedExoCache(ExoContainerContext ctx, ExoCacheConfig config, Cache<K, V> cache) {
        this.fullName = ctx.getName() + "-" + config.getName();
        this.cache = cache.getAdvancedCache();
        this.setDistributed(config.isDistributed());
        this.setLabel(config.getLabel());
        this.setName(config.getName());
        this.setLogEnabled(config.isLogEnabled());
        this.setReplicated(config.isRepicated());
    }

    AdvancedCache<CacheKey<K>, V> getCache() {
        return this.cache;
    }

    String getFullName() {
        return this.fullName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheListener(CacheListener<? super K, ? super V> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener cannot be null");
        }
        List<ListenerContext> lListeners = this.getListeners(this.fullName);
        if (lListeners == null) {
            List<ListenerContext> oldValue;
            lListeners = new CopyOnWriteArrayList<ListenerContext>();
            boolean alreadyAdded = false;
            ConcurrentMap<String, List<ListenerContext>> listeners = this.getOrCreateListeners();
            if (listeners.isEmpty()) {
                ConcurrentMap<String, List<ListenerContext>> concurrentMap = listeners;
                synchronized (concurrentMap) {
                    if (listeners.isEmpty()) {
                        this.cache.addListener((Object)new CacheEventListener());
                        listeners.put(this.fullName, lListeners);
                        alreadyAdded = true;
                    }
                }
            }
            if (!alreadyAdded && (oldValue = listeners.putIfAbsent(this.fullName, lListeners)) != null) {
                lListeners = oldValue;
            }
        }
        lListeners.add(new ListenerContext<K, V>(listener, this));
    }

    private ConcurrentMap<String, List<ListenerContext>> getOrCreateListeners() {
        ConcurrentMap oldValue;
        ConcurrentMap listeners = (ConcurrentHashMap)ALL_LISTENERS.get(this.cache);
        if (listeners == null && (oldValue = (ConcurrentMap)ALL_LISTENERS.putIfAbsent((Cache)this.cache, listeners = new ConcurrentHashMap())) != null) {
            listeners = oldValue;
        }
        return listeners;
    }

    private List<ListenerContext> getListeners(String fullName) {
        ConcurrentMap listeners = (ConcurrentMap)ALL_LISTENERS.get(this.cache);
        return listeners == null ? null : (List)listeners.get(fullName);
    }

    public void clearCache() {
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                MapReduceTask task = new MapReduceTask(DistributedExoCache.this.cache);
                task.mappedWith(new ClearCacheMapper(DistributedExoCache.this.fullName)).reducedWith((Reducer)new ClearCacheReducer());
                task.execute();
                return null;
            }
        });
        this.onClearCache();
    }

    public V get(Serializable name) {
        if (name == null) {
            return null;
        }
        final CacheKey<Serializable> key = new CacheKey<Serializable>(this.fullName, name);
        Object result = SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<V>(){

            @Override
            public V run() {
                return DistributedExoCache.this.cache.get((Object)key);
            }
        });
        if (result == null) {
            this.misses.incrementAndGet();
        } else {
            this.hits.incrementAndGet();
        }
        this.onGet(key, result);
        return (V)result;
    }

    public int getCacheHit() {
        return this.hits.get();
    }

    public int getCacheMiss() {
        return this.misses.get();
    }

    public int getCacheSize() {
        Map map = (Map)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> run() {
                MapReduceTask task = new MapReduceTask(DistributedExoCache.this.cache);
                task.mappedWith(new GetSizeMapper(DistributedExoCache.this.fullName)).reducedWith(new GetSizeReducer());
                return task.execute();
            }
        });
        int sum = 0;
        for (Integer i : map.values()) {
            sum += i.intValue();
        }
        return sum;
    }

    public List<V> getCachedObjects() {
        Map map = (Map)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Map<String, List<V>>>(){

            @Override
            public Map<String, List<V>> run() {
                MapReduceTask task = new MapReduceTask(DistributedExoCache.this.cache);
                task.mappedWith(new GetCachedObjectsMapper(DistributedExoCache.this.fullName)).reducedWith(new GetCachedObjectsReducer());
                return task.execute();
            }
        });
        ArrayList result = new ArrayList();
        for (List vals : map.values()) {
            result.addAll(vals);
        }
        return result;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public void put(final K key, final V value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("No null cache key accepted");
        }
        if (value == null) {
            return;
        }
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                DistributedExoCache.this.putOnly(key, value);
                return null;
            }
        });
        this.onPut(key, value);
    }

    protected void putOnly(K key, V value) {
        this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES}).put(new CacheKey<K>(this.fullName, key), value);
    }

    public void putMap(final Map<? extends K, ? extends V> objs) throws IllegalArgumentException {
        if (objs == null) {
            throw new IllegalArgumentException("No null map accepted");
        }
        for (Serializable name : objs.keySet()) {
            if (name != null) continue;
            throw new IllegalArgumentException("No null cache key accepted");
        }
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                DistributedExoCache.this.cache.startBatch();
                try {
                    LinkedHashMap map = new LinkedHashMap();
                    for (Map.Entry entry : objs.entrySet()) {
                        map.put(new CacheKey<Serializable>(DistributedExoCache.this.fullName, (Serializable)entry.getKey()), entry.getValue());
                    }
                    DistributedExoCache.this.cache.putAll(map);
                    DistributedExoCache.this.cache.endBatch(true);
                    for (Map.Entry entry : objs.entrySet()) {
                        DistributedExoCache.this.onPut((Serializable)entry.getKey(), entry.getValue());
                    }
                }
                catch (Exception e) {
                    DistributedExoCache.this.cache.endBatch(false);
                    LOG.warn((Object)"An error occurs while executing the putMap method", (Throwable)e);
                }
                return null;
            }
        });
    }

    public V remove(Serializable name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("No null cache key accepted");
        }
        final CacheKey<Serializable> key = new CacheKey<Serializable>(this.fullName, name);
        Object result = SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<V>(){

            @Override
            public V run() {
                return DistributedExoCache.this.cache.remove((Object)key);
            }
        });
        this.onRemove(key, result);
        return (V)result;
    }

    public List<V> removeCachedObjects() {
        List<V> list = this.getCachedObjects();
        this.clearCache();
        return list;
    }

    public void select(CachedObjectSelector<? super K, ? super V> selector) throws Exception {
        if (selector == null) {
            throw new IllegalArgumentException("No null selector");
        }
        Map map = (Map)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Map<K, V>>(){

            @Override
            public Map<K, V> run() {
                MapReduceTask task = new MapReduceTask(DistributedExoCache.this.cache);
                task.mappedWith(new GetEntriesMapper(DistributedExoCache.this.fullName)).reducedWith(new GetEntriesReducer());
                return task.execute();
            }
        });
        for (Serializable key : map.keySet()) {
            Object value;
            ObjectCacheInfo info;
            if (key == null || !selector.select(key, info = new ObjectCacheInfo<V>(value = map.get(key)){
                final /* synthetic */ Object val$value;
                {
                    this.val$value = object;
                }

                public V get() {
                    return this.val$value;
                }

                public long getExpireTime() {
                    return -1L;
                }
            })) continue;
            selector.onSelect((ExoCache)this, key, info);
        }
    }

    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    void onExpire(CacheKey<K> key, V obj) {
        List<ListenerContext> listeners = this.getListeners(key.getFullName());
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (ListenerContext context : listeners) {
            try {
                context.onExpire((Serializable)key.getKey(), obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onRemove(CacheKey<K> key, V obj) {
        List<ListenerContext> listeners = this.getListeners(key.getFullName());
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (ListenerContext context : listeners) {
            try {
                context.onRemove(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onPut(CacheKey<K> key, V obj) {
        this.onPut(key.getFullName(), (Serializable)key.getKey(), obj);
    }

    public void onPut(K key, V obj) {
        this.onPut(this.fullName, key, obj);
    }

    void onPut(String fullName, K key, V obj) {
        List<ListenerContext> listeners = this.getListeners(fullName);
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (ListenerContext context : listeners) {
            try {
                context.onPut(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onGet(CacheKey<K> key, V obj) {
        List<ListenerContext> listeners = this.getListeners(key.getFullName());
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (ListenerContext context : listeners) {
            try {
                context.onGet(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    public void onClearCache() {
        List<ListenerContext> listeners = this.getListeners(this.fullName);
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (ListenerContext context : listeners) {
            try {
                context.onClearCache();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    public void setMaxSize(int max) {
        throw new UnsupportedOperationException("The configuration of the cache cannot not be modified");
    }

    public void setLiveTime(long period) {
        throw new UnsupportedOperationException("The configuration of the cache cannot not be modified");
    }

    @ManagedName(value="MaxEntries")
    @ManagedDescription(value="Maximum number of entries in a cache instance. -1 means no limit.")
    public int getMaxSize() {
        return Math.toIntExact(this.cache.getCacheConfiguration().eviction().maxEntries());
    }

    @ManagedName(value="Lifespan")
    @ManagedDescription(value="Maximum lifespan of a cache entry, after which the entry is expired cluster-wide. -1 means the entries never expire.")
    public long getLiveTime() {
        return this.cache.getCacheConfiguration().expiration().lifespan();
    }

    @Managed
    @ManagedName(value="MaxIdle")
    @ManagedDescription(value="Maximum idle time a cache entry will be maintained in the cache. If the idle time is exceeded, the entry will be expired cluster-wide. -1 means the entries never expire.")
    public long getMaxIdle() {
        return this.cache.getCacheConfiguration().expiration().maxIdle();
    }

    @Managed
    @ManagedName(value="WakeUpInterval")
    @ManagedDescription(value="Interval between subsequent eviction runs. If you wish to disable the periodic eviction process altogether, set wakeupInterval to -1.")
    public long getWakeUpInterval() {
        return this.cache.getCacheConfiguration().expiration().wakeUpInterval();
    }

    public static class GetEntriesReducer<K, V>
    implements Reducer<K, V> {
        private static final long serialVersionUID = 5153826700048219537L;

        public V reduce(K reducedKey, Iterator<V> iter) {
            return iter == null || !iter.hasNext() ? null : (V)iter.next();
        }
    }

    public static class GetEntriesMapper<K, V>
    extends AbstractExoCacheMapper<K, V, K, V> {
        public GetEntriesMapper() {
        }

        public GetEntriesMapper(String fullName) {
            super(fullName);
        }

        @Override
        protected void _map(CacheKey<K> key, V value, Collector<K, V> collector) {
            collector.emit(key.getKey(), value);
        }
    }

    public static class ClearCacheReducer
    implements Reducer<Void, Void> {
        private static final long serialVersionUID = -8111087186325793256L;

        public Void reduce(Void reducedKey, Iterator<Void> iter) {
            return null;
        }
    }

    public static class ClearCacheMapper<K, V>
    extends AbstractExoCacheMapper<K, V, Void, Void> {
        public ClearCacheMapper() {
        }

        public ClearCacheMapper(String fullName) {
            super(fullName);
        }

        @Override
        protected void _map(CacheKey<K> key, V value, Collector<Void, Void> collector) {
            ExoContainer container = ExoContainerContext.getTopContainer();
            if (container == null) {
                LOG.error((Object)"The top container could not be found");
                return;
            }
            DistributedCacheManager dcm = (DistributedCacheManager)container.getComponentInstanceOfType(DistributedCacheManager.class);
            if (dcm == null) {
                LOG.error((Object)"The DistributedCacheManager could not be found at top container level, please configure it.");
                return;
            }
            Cache cache = dcm.getCache(DistributedExoCache.CACHE_NAME);
            cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.FAIL_SILENTLY}).remove(key);
        }
    }

    public static class GetCachedObjectsReducer<K, V>
    implements Reducer<K, List<V>> {
        private static final long serialVersionUID = 8069024420056440405L;

        public List<V> reduce(K reducedKey, Iterator<List<V>> iter) {
            ArrayList<V> values = new ArrayList<V>();
            while (iter.hasNext()) {
                List<V> vals = iter.next();
                values.addAll(vals);
            }
            return values;
        }
    }

    public static class GetCachedObjectsMapper<K, V>
    extends AbstractExoCacheMapper<K, V, String, List<V>> {
        public GetCachedObjectsMapper() {
        }

        public GetCachedObjectsMapper(String fullName) {
            super(fullName);
        }

        @Override
        protected void _map(CacheKey<K> key, V value, Collector<String, List<V>> collector) {
            collector.emit((Object)"values", Collections.singletonList(value));
        }
    }

    public static class GetSizeReducer<K>
    implements Reducer<K, Integer> {
        private static final long serialVersionUID = -5264142863835473112L;

        public Integer reduce(K reducedKey, Iterator<Integer> iter) {
            int sum = 0;
            while (iter.hasNext()) {
                Integer i = iter.next();
                sum += i.intValue();
            }
            return sum;
        }
    }

    public static class GetSizeMapper<K, V>
    extends AbstractExoCacheMapper<K, V, String, Integer> {
        public GetSizeMapper() {
        }

        public GetSizeMapper(String fullName) {
            super(fullName);
        }

        @Override
        protected void _map(CacheKey<K> key, V value, Collector<String, Integer> collector) {
            collector.emit((Object)"total", (Object)1);
        }
    }

    private static abstract class AbstractExoCacheMapper<K, V, KOut, VOut>
    extends AbstractMapper<CacheKey<K>, V, KOut, VOut>
    implements Externalizable {
        private String fullName;
        private static final long serialVersionUID = 7962676854308932222L;

        public AbstractExoCacheMapper() {
        }

        public AbstractExoCacheMapper(String fullName) {
            this.fullName = fullName;
        }

        @Override
        protected boolean isValid(CacheKey<K> key) {
            return this.fullName.equals(key.getFullName());
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            byte[] buf = this.fullName.getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            byte[] buf = new byte[in.readInt()];
            in.readFully(buf);
            this.fullName = new String(buf, "UTF-8");
        }
    }

    public static class CacheKey<K>
    implements Externalizable {
        private K key;
        private String fullName;

        public CacheKey() {
        }

        public CacheKey(String fullName, K key) {
            this.fullName = fullName;
            this.key = key;
        }

        K getKey() {
            return this.key;
        }

        String getFullName() {
            return this.fullName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fullName == null ? 0 : this.fullName.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName)) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }

        public String toString() {
            return "CacheKey [fullName=" + this.fullName + ", key=" + this.key + "]";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            byte[] buf = this.fullName.getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
            out.writeObject(this.key);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            byte[] buf = new byte[in.readInt()];
            in.readFully(buf);
            this.fullName = new String(buf, "UTF-8");
            this.key = in.readObject();
        }
    }

    private static class ListenerContext<K extends Serializable, V>
    implements CacheListenerContext,
    CacheInfo {
        private final ExoCache<K, V> cache;
        final CacheListener<? super K, ? super V> listener;

        public ListenerContext(CacheListener<? super K, ? super V> listener, ExoCache<K, V> cache) {
            this.listener = listener;
            this.cache = cache;
        }

        public CacheInfo getCacheInfo() {
            return this;
        }

        public String getName() {
            return this.cache.getName();
        }

        public int getMaxSize() {
            return this.cache.getMaxSize();
        }

        public long getLiveTime() {
            return this.cache.getLiveTime();
        }

        public int getSize() {
            return this.cache.getCacheSize();
        }

        void onExpire(K key, V obj) throws Exception {
            this.listener.onExpire((CacheListenerContext)this, key, obj);
        }

        void onRemove(K key, V obj) throws Exception {
            this.listener.onRemove((CacheListenerContext)this, key, obj);
        }

        void onPut(K key, V obj) throws Exception {
            this.listener.onPut((CacheListenerContext)this, key, obj);
        }

        void onGet(K key, V obj) throws Exception {
            this.listener.onGet((CacheListenerContext)this, key, obj);
        }

        void onClearCache() throws Exception {
            this.listener.onClearCache((CacheListenerContext)this);
        }
    }

    @Listener
    public class CacheEventListener {
        @CacheEntriesEvicted
        public void cacheEntryEvicted(CacheEntriesEvictedEvent<CacheKey<K>, V> evt) {
            if (evt.isPre()) {
                for (Map.Entry entry : evt.getEntries().entrySet()) {
                    DistributedExoCache.this.onExpire((CacheKey)entry.getKey(), entry.getValue());
                }
            }
        }

        @CacheEntryRemoved
        public void cacheEntryRemoved(CacheEntryRemovedEvent<CacheKey<K>, V> evt) {
            if (evt.isPre() && !evt.isOriginLocal()) {
                CacheKey key = (CacheKey)evt.getKey();
                Object value = evt.getValue();
                DistributedExoCache.this.onRemove(key, value);
            }
        }

        @CacheEntryModified
        public void cacheEntryModified(CacheEntryModifiedEvent<CacheKey<K>, V> evt) {
            if (!evt.isOriginLocal() && !evt.isPre()) {
                CacheKey key = (CacheKey)evt.getKey();
                Object value = evt.getValue();
                DistributedExoCache.this.onPut(key, value);
            }
        }

        @CacheEntryCreated
        public void cacheEntrCreated(CacheEntryCreatedEvent<CacheKey<K>, V> evt) {
            if (!evt.isOriginLocal() && !evt.isPre()) {
                CacheKey key = (CacheKey)evt.getKey();
                Object value = evt.getValue();
                DistributedExoCache.this.onPut(key, value);
            }
        }
    }
}

