/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import javax.measure.Unit;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AxisFilter;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public enum AxesConvention implements AxisFilter
{
    NORMALIZED{

        @Override
        public Unit<?> getUnitReplacement(CoordinateSystemAxis coordinateSystemAxis, Unit<?> unit) {
            if (Units.isLinear(unit)) {
                unit = Units.METRE;
            } else if (Units.isAngular((Unit)unit)) {
                unit = Units.DEGREE;
            } else if (Units.isTemporal((Unit)unit)) {
                unit = Units.DAY;
            }
            return unit;
        }

        @Override
        public AxisDirection getDirectionReplacement(CoordinateSystemAxis coordinateSystemAxis, AxisDirection axisDirection) {
            if (!AxisDirections.isIntercardinal(axisDirection) && (coordinateSystemAxis == null || coordinateSystemAxis.getMinimumValue() < 0.0)) {
                return AxisDirections.absolute(axisDirection);
            }
            return axisDirection;
        }
    }
    ,
    DISPLAY_ORIENTED{

        @Override
        public AxisDirection getDirectionReplacement(CoordinateSystemAxis coordinateSystemAxis, AxisDirection axisDirection) {
            return NORMALIZED.getDirectionReplacement(coordinateSystemAxis, axisDirection);
        }
    }
    ,
    RIGHT_HANDED,
    POSITIVE_RANGE;

    @Deprecated
    public static final AxesConvention CONVENTIONALLY_ORIENTED;

    static {
        CONVENTIONALLY_ORIENTED = DISPLAY_ORIENTED;
    }
}

