/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.dlp.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.dlp.dto.DlpPositiveItem;
import org.exoplatform.commons.dlp.processor.DlpOperationProcessor;
import org.exoplatform.commons.dlp.service.DlpPositiveItemService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.rest.CollectionEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/dlp/items")
@Api(value="/dlp/items", description="Manages Dlp positive items")
public class DlpItemRestServices
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(DlpItemRestServices.class);
    private DlpPositiveItemService dlpPositiveItemService;
    private DlpOperationProcessor dlpOperationProcessor;

    public DlpItemRestServices(DlpPositiveItemService dlpPositiveItemService, DlpOperationProcessor dlpOperationProcessor) {
        this.dlpPositiveItemService = dlpPositiveItemService;
        this.dlpOperationProcessor = dlpOperationProcessor;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves the list of dlp positive items", httpMethod="GET", response=Response.class, produces="application/json", notes="Return list of dlp positive items in json format")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getDlpPositiveItems(@ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit) {
        if (!this.isDlpAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            List<DlpPositiveItem> dlpPositiveItems = this.dlpPositiveItemService.getDlpPositivesItems(offset, limit);
            Long size = this.dlpPositiveItemService.getDlpPositiveItemsCount();
            CollectionEntity collectionDlpPositiveItem = new CollectionEntity(dlpPositiveItems, offset, limit, size.intValue());
            return Response.ok((Object)collectionDlpPositiveItem).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting dlp positive items", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="/item/{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Delete a document by id", httpMethod="DELETE", response=Response.class, notes="This delete the document if the authenticated user is a super manager")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteDlpDocumentById(@ApiParam(value="Document id", required=true) @PathParam(value="id") Long id) {
        if (!this.isDlpAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.dlpPositiveItemService.deleteDlpPositiveItem(id);
        return Response.ok().build();
    }

    @GET
    @Path(value="/keywords")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves the list of dlp keywords", httpMethod="GET", response=Response.class, produces="application/json", notes="Return list of dlp keywords in json format")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getDlpKeywords() {
        if (!this.isDlpAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            String keywords = this.dlpOperationProcessor.getKeywords();
            return Response.ok((Object)keywords).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting dlp keywords", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/keywords")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="set dlp keywords", httpMethod="POST", response=Response.class, produces="application/json", notes="set the dlp keywords")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response setDlpKeywords(@ApiParam(value="keywords", required=true) String keywords) {
        if (!this.isDlpAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.dlpOperationProcessor.setKeywords(keywords);
            return Response.ok().entity((Object)("{\"result\":\"" + keywords + "\"}")).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while setting dlp keywords", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="item/restore/{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Restore the dlp positive items", httpMethod="PUT", response=Response.class, produces="application/json", notes="Return the restored positive item")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response restoreDlpPositiveItems(@ApiParam(value="Document id", required=true) @PathParam(value="id") Long id) {
        if (!this.isDlpAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.dlpPositiveItemService.restoreDlpPositiveItem(id);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while restoring dlp positive items", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private boolean isDlpAdmin() {
        UserACL userACL = (UserACL)CommonsUtils.getService(UserACL.class);
        return userACL.isSuperUser() || userACL.isUserInGroup(userACL.getDlpGroups());
    }
}

