/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.entity;

import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.PermissionEntity;

@Entity(name="WikiWikiEntity")
@ExoEntity
@Table(name="WIKI_WIKIS")
@NamedQueries(value={@NamedQuery(name="wiki.getAllIds", query="SELECT w.id FROM WikiWikiEntity w ORDER BY w.id"), @NamedQuery(name="wiki.getWikisByType", query="SELECT w FROM WikiWikiEntity w WHERE w.type = :type"), @NamedQuery(name="wiki.getWikiByTypeAndOwner", query="SELECT w FROM WikiWikiEntity w WHERE w.type = :type AND w.owner = :owner")})
public class WikiEntity {
    @Id
    @Column(name="WIKI_ID")
    @SequenceGenerator(name="SEQ_WIKI_WIKIS_WIKI_ID", sequenceName="SEQ_WIKI_WIKIS_WIKI_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WIKI_WIKIS_WIKI_ID")
    private long id;
    @Column(name="NAME")
    private String name;
    @Column(name="OWNER")
    private String owner;
    @Column(name="TYPE")
    private String type;
    @OneToOne
    @JoinColumn(name="WIKI_HOME")
    private PageEntity wikiHome;
    @ElementCollection
    @CollectionTable(name="WIKI_WIKI_PERMISSIONS", joinColumns={@JoinColumn(name="WIKI_ID")})
    private List<PermissionEntity> permissions;
    @Column(name="SYNTAX")
    private String syntax;
    @Column(name="ALLOW_MULTI_SYNTAX")
    private boolean allowMultipleSyntax;

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public WikiEntity setName(String name) {
        this.name = name;
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public WikiEntity setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public WikiEntity setType(String type) {
        this.type = type;
        return this;
    }

    public PageEntity getWikiHome() {
        return this.wikiHome;
    }

    public WikiEntity setWikiHome(PageEntity wikiHome) {
        this.wikiHome = wikiHome;
        return this;
    }

    public List<PermissionEntity> getPermissions() {
        return this.permissions;
    }

    public WikiEntity setPermissions(List<PermissionEntity> permissions) {
        this.permissions = permissions;
        return this;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    public boolean isAllowMultipleSyntax() {
        return this.allowMultipleSyntax;
    }

    public void setAllowMultipleSyntax(boolean allowMultipleSyntax) {
        this.allowMultipleSyntax = allowMultipleSyntax;
    }
}

