/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router.regex;

import java.util.regex.Pattern;

public abstract class RE {
    public static final Match[] NO_MATCHES = new Match[0];
    public static final Match NULL_MATCH = new Match(-1, -1, null);

    public abstract String getPattern();

    public abstract Matcher matcher();

    public static class Java
    extends RE {
        private final Pattern pattern;

        public Java(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public Matcher matcher() {
            return new Matcher(){
                private java.util.regex.Matcher impl;

                private java.util.regex.Matcher get(CharSequence s) {
                    if (this.impl == null) {
                        this.impl = Java.this.pattern.matcher(s);
                    } else {
                        this.impl.reset(s);
                    }
                    return this.impl;
                }

                @Override
                public boolean matches(CharSequence s) {
                    return this.get(s).matches();
                }

                @Override
                public Match[] find(CharSequence s) {
                    java.util.regex.Matcher matcher = this.get(s);
                    if (matcher.find()) {
                        Match[] matches = new Match[1 + matcher.groupCount()];
                        for (int i = 0; i <= matcher.groupCount(); ++i) {
                            matches[i] = matcher.group() != null ? new Match(matcher.start(i), matcher.end(i), matcher.group(i)) : NULL_MATCH;
                        }
                        return matches;
                    }
                    return NO_MATCHES;
                }
            };
        }

        @Override
        public String getPattern() {
            return this.pattern.pattern();
        }
    }

    public static class Match {
        private final int start;
        private final int end;
        private final String value;

        protected Match(int start, int end, String value) {
            this.start = start;
            this.end = end;
            this.value = value;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static abstract class Matcher {
        public abstract boolean matches(CharSequence var1);

        public abstract Match[] find(CharSequence var1);
    }
}

