/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.referencing.factory.FactoryDataException;
import org.apache.sis.referencing.factory.MissingFactoryResourceException;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.FactoryException;

class DatumShiftGridLoader {
    static final double DEGREES_TO_SECONDS = 3600.0;
    static final double SECOND_PRECISION = 1.0E-4;
    final Path file;
    private final ReadableByteChannel channel;
    final ByteBuffer buffer;

    DatumShiftGridLoader(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, Path path) throws IOException {
        this.file = path;
        this.buffer = byteBuffer;
        this.channel = readableByteChannel;
        readableByteChannel.read(byteBuffer);
        byteBuffer.flip();
    }

    final void ensureBufferContains(int n) throws IOException {
        assert (n >= 0 && n <= this.buffer.capacity()) : n;
        if ((n -= this.buffer.remaining()) > 0) {
            int n2;
            this.buffer.compact();
            do {
                if ((n2 = this.channel.read(this.buffer)) > 0) continue;
                if (n2 != 0) {
                    throw new EOFException(Errors.format((short)137, (Object)this.file));
                }
                throw new IOException(Errors.format((short)12, (Object)this.file));
            } while ((n -= n2) > 0);
            this.buffer.flip();
        }
    }

    final void skip(int n) throws IOException {
        int n2;
        while ((n2 = this.buffer.position() + n) > this.buffer.limit()) {
            this.buffer.clear();
            this.ensureBufferContains(Math.min(n -= this.buffer.remaining(), this.buffer.capacity()));
        }
        this.buffer.position(n2);
    }

    static void log(Class<?> clazz, Object object) {
        LogRecord logRecord = Resources.forLocale(null).getLogRecord(Level.FINE, (short)32, object);
        logRecord.setLoggerName("org.apache.sis.referencing.operation");
        Logging.log(clazz, (String)"createMathTransform", (LogRecord)logRecord);
    }

    static FactoryException canNotLoad(String string, Path path, Exception exception) {
        String string2 = Errors.format((short)10, (Object)string, (Object)path);
        if (exception instanceof NoSuchFileException) {
            return new MissingFactoryResourceException(string2, exception);
        }
        return new FactoryDataException(string2, exception);
    }
}

