/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.portal.application.StandaloneAppRequestContext;
import org.exoplatform.web.login.LoginServlet;
import org.exoplatform.web.login.LogoutControl;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/portal/webui/application/UIStandaloneAppContainer.gtmpl", events={@EventConfig(listeners={LogoutActionListener.class}, csrfCheck=false)})
public class UIStandaloneAppContainer
extends UIContainer {
    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    public static class LogoutActionListener
    extends EventListener<UIComponent> {
        public void execute(Event<UIComponent> event) throws Exception {
            AbstractTokenService tokenService;
            StandaloneAppRequestContext context = (StandaloneAppRequestContext)event.getRequestContext();
            HttpServletRequest req = context.getRequest();
            String token = this.getTokenCookie(req);
            if (token != null) {
                tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                tokenService.deleteToken((Object)token);
            }
            if ((token = LoginServlet.getOauthRememberMeTokenCookie((HttpServletRequest)req)) != null) {
                tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                tokenService.deleteToken((Object)token);
            }
            LogoutControl.wantLogout();
            Cookie cookie = new Cookie("rememberme", "");
            cookie.setPath(req.getContextPath());
            cookie.setMaxAge(0);
            context.getResponse().addCookie(cookie);
            Cookie oauthCookie = new Cookie("oauth_rememberme", "");
            oauthCookie.setPath(req.getContextPath());
            oauthCookie.setMaxAge(0);
            context.getResponse().addCookie(oauthCookie);
            context.sendRedirect(req.getRequestURI());
        }

        private String getTokenCookie(HttpServletRequest req) {
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!"rememberme".equals(cookie.getName())) continue;
                    return cookie.getValue();
                }
            }
            return null;
        }
    }
}

