/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.util.Arrays;
import org.apache.sis.coverage.MismatchedCoverageRangeException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.internal.coverage.ColorModelFactory;
import org.apache.sis.internal.coverage.RasterFactory;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;

public class ImageRenderer {
    private final long offsetX;
    private final long offsetY;
    private final int imageX;
    private final int imageY;
    private final int width;
    private final int height;
    private final int pixelStride;
    private final int scanlineStride;
    private int strideFactor;
    private final SampleDimension[] bands;
    private int[] bandOffsets;
    private int[] bankIndices;
    private int visibleBand;
    private DataBuffer buffer;

    public ImageRenderer(GridCoverage gridCoverage, GridExtent gridExtent) {
        ArgumentChecks.ensureNonNull((String)"coverage", (Object)gridCoverage);
        this.bands = (SampleDimension[])CollectionsExt.toArray(gridCoverage.getSampleDimensions(), SampleDimension.class);
        GridExtent gridExtent2 = gridCoverage.getGridGeometry().getExtent();
        if (gridExtent != null) {
            int n = gridExtent.getDimension();
            if (gridExtent2.getDimension() != n) {
                throw new MismatchedDimensionException(Errors.format((short)81, (Object)"target", (Object)gridExtent2.getDimension(), (Object)n));
            }
        } else {
            gridExtent = gridExtent2;
        }
        int[] nArray = gridExtent.getSubspaceDimensions(2);
        int n = nArray[0];
        int n2 = nArray[1];
        long l = gridExtent2.getLow(n);
        long l2 = gridExtent2.getLow(n2);
        long l3 = gridExtent.getLow(n);
        long l4 = gridExtent.getLow(n2);
        long l5 = Math.max(l3, l);
        long l6 = Math.max(l4, l2);
        long l7 = Math.min(gridExtent.getHigh(n), gridExtent2.getHigh(n));
        long l8 = Math.min(gridExtent.getHigh(n2), gridExtent2.getHigh(n2));
        if (l7 < l5 || l8 < l6) {
            int n3 = l7 < l5 ? n : n2;
            throw new DisjointExtentException(gridExtent2.getAxisIdentification(n3, n3), gridExtent2.getLow(n3), gridExtent2.getHigh(n3), gridExtent.getLow(n3), gridExtent.getHigh(n3));
        }
        this.width = Math.incrementExact(Math.toIntExact(l7 - l5));
        this.height = Math.incrementExact(Math.toIntExact(l8 - l6));
        this.imageX = Math.toIntExact(Math.subtractExact(l3, l5));
        this.imageY = Math.toIntExact(Math.subtractExact(l4, l6));
        this.offsetX = Math.subtractExact(l5, l);
        this.offsetY = Math.subtractExact(l6, l2);
        long l9 = 1L;
        for (int i = 0; i < n; ++i) {
            l9 = Math.multiplyExact(l9, gridExtent2.getSize(i));
        }
        long l10 = l9;
        for (int i = n; i < n2; ++i) {
            l10 = Math.multiplyExact(l10, gridExtent2.getSize(i));
        }
        this.pixelStride = Math.toIntExact(l9);
        this.scanlineStride = Math.toIntExact(l10);
    }

    public final int getNumBands() {
        return this.bands.length;
    }

    private void ensureExpectedBandCount(int n, boolean bl) {
        int n2;
        if (!(n == 1 & bl) && n != (n2 = this.getNumBands())) {
            throw new MismatchedCoverageRangeException(Resources.format((short)49, n2, n));
        }
    }

    public final Rectangle getBounds() {
        return new Rectangle(this.imageX, this.imageY, this.width, this.height);
    }

    public void setData(DataBuffer dataBuffer) {
        ArgumentChecks.ensureNonNull((String)"data", (Object)dataBuffer);
        this.ensureExpectedBandCount(dataBuffer.getNumBanks(), true);
        this.buffer = dataBuffer;
    }

    public void setData(int n, Buffer ... bufferArray) {
        ArgumentChecks.ensureNonNull((String)"data", (Object)bufferArray);
        this.ensureExpectedBandCount(bufferArray.length, true);
        DataBuffer dataBuffer = RasterFactory.wrap(n, bufferArray);
        if (dataBuffer == null) {
            throw new IllegalArgumentException(Resources.format((short)50, n));
        }
        this.setData(dataBuffer);
    }

    public void setData(Vector ... vectorArray) {
        ArgumentChecks.ensureNonNull((String)"data", (Object)vectorArray);
        this.ensureExpectedBandCount(vectorArray.length, true);
        Buffer[] bufferArray = new Buffer[vectorArray.length];
        int n = 32;
        for (int i = 0; i < vectorArray.length; ++i) {
            Vector vector = vectorArray[i];
            ArgumentChecks.ensureNonNullElement((String)"data", (int)i, (Object)vector);
            int n2 = RasterFactory.getType(vector.getElementType(), vector.isUnsigned());
            if (n != n2) {
                if (i != 0) {
                    throw new RasterFormatException(Resources.format((short)39));
                }
                n = n2;
            }
            bufferArray[i] = (Buffer)vector.buffer().orElseThrow(UnsupportedOperationException::new);
        }
        this.setData(n, bufferArray);
    }

    public void setInterleavedPixelOffsets(int n, int[] nArray) {
        ArgumentChecks.ensureStrictlyPositive((String)"pixelStride", (int)n);
        ArgumentChecks.ensureNonNull((String)"bandOffsets", (Object)nArray);
        this.ensureExpectedBandCount(nArray.length, false);
        this.strideFactor = n;
        this.bandOffsets = (int[])nArray.clone();
    }

    public WritableRaster raster() {
        int n;
        boolean bl;
        if (this.buffer == null) {
            throw new IllegalStateException(Resources.format((short)53));
        }
        boolean bl2 = bl = this.buffer.getNumBanks() == 1;
        if (this.bandOffsets == null) {
            this.strideFactor = bl ? this.getNumBands() : 1;
        }
        int n2 = Math.multiplyExact(this.scanlineStride, this.strideFactor);
        int n3 = this.pixelStride * this.strideFactor;
        int[] nArray = new int[this.getNumBands()];
        Arrays.fill(nArray, Math.toIntExact(Math.addExact(Math.multiplyExact(this.offsetX, (long)n3), Math.multiplyExact(this.offsetY, (long)n2))));
        if (this.bandOffsets != null) {
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = Math.addExact(nArray[n], this.bandOffsets[n]);
            }
        } else if (bl) {
            for (n = 1; n < nArray.length; ++n) {
                nArray[n] = Math.addExact(nArray[n], n);
            }
        }
        Point point = new Point(this.imageX, this.imageY);
        return RasterFactory.createRaster(this.buffer, this.width, this.height, n3, n2, this.bankIndices, nArray, point);
    }

    public RenderedImage image() {
        WritableRaster writableRaster = this.raster();
        ColorModel colorModel = ColorModelFactory.createColorModel(this.bands, this.visibleBand, this.buffer.getDataType(), ColorModelFactory.GRAYSCALE);
        return new BufferedImage(colorModel, writableRaster, false, null);
    }
}

