/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.social.core.jpa.storage.entity.MetadataEntity;

@Entity(name="SocMetadataItemEntity")
@ExoEntity
@Table(name="SOC_METADATA_ITEMS")
@NamedQueries(value={@NamedQuery(name="SocMetadataItemEntity.getMetadataItemsByObject", query="SELECT mi FROM SocMetadataItemEntity mi WHERE  mi.objectType = :objectType AND mi.objectId = :objectId ORDER BY mi.createdDate DESC, mi.id DESC"), @NamedQuery(name="SocMetadataItemEntity.getMetadataNamesByObject", query="SELECT mi.metadata.name FROM SocMetadataItemEntity mi WHERE  mi.objectType = :objectType AND mi.objectId = :objectId"), @NamedQuery(name="SocMetadataItemEntity.getMetadataItemsByMetadataAndObject", query="SELECT mi FROM SocMetadataItemEntity mi WHERE  mi.metadata.id = :metadataId AND mi.objectType = :objectType AND mi.objectId = :objectId"), @NamedQuery(name="SocMetadataItemEntity.getMetadataItemsByMetadataTypeAndObject", query="SELECT mi FROM SocMetadataItemEntity mi WHERE  mi.metadata.type = :metadataType AND mi.objectType = :objectType AND mi.objectId = :objectId"), @NamedQuery(name="SocMetadataItemEntity.getMetadataObjectIds", query="SELECT mi.objectId, mi.createdDate, mi.id FROM SocMetadataItemEntity mi WHERE  mi.metadata.type = :metadataType AND mi.metadata.name = :metadataName AND mi.objectType = :objectType ORDER BY mi.createdDate DESC, mi.id DESC"), @NamedQuery(name="SocMetadataItemEntity.deleteMetadataItemsByObject", query="DELETE FROM SocMetadataItemEntity mi WHERE  mi.objectType = :objectType AND mi.objectId = :objectId"), @NamedQuery(name="SocMetadataItemEntity.getMetadataItemsByMetadataTypeAndNameAndObject", query="SELECT mi FROM SocMetadataItemEntity mi WHERE  mi.metadata.type = :metadataType AND mi.metadata.name = :metadataName AND mi.objectType = :objectType ORDER BY mi.createdDate DESC, mi.id DESC"), @NamedQuery(name="SocMetadataItemEntity.getMetadataItemsByMetadataTypeAndCreator", query="SELECT mi FROM SocMetadataItemEntity mi WHERE  mi.metadata.type = :metadataType AND mi.creatorId = :creatorId ORDER BY mi.createdDate DESC, mi.id DESC"), @NamedQuery(name="SocMetadataItemEntity.countMetadataItemsByMetadataTypeAndCreator", query="SELECT count(mi.id) FROM SocMetadataItemEntity mi WHERE  mi.metadata.type = :metadataType AND mi.creatorId = :creatorId"), @NamedQuery(name="SocMetadataItemEntity.deleteMetadataItemsByParentObject", query="DELETE FROM SocMetadataItemEntity mi WHERE  mi.objectType = :objectType AND mi.parentObjectId = :parentObjectId"), @NamedQuery(name="SocMetadataItemEntity.deleteMetadataItemById", query="DELETE FROM SocMetadataItemEntity mi WHERE  mi.id = :id")})
public class MetadataItemEntity
implements Serializable {
    private static final long serialVersionUID = 5011906982712067379L;
    @Id
    @SequenceGenerator(name="SEQ_SOC_METADATA_ITEM_ID", sequenceName="SEQ_SOC_METADATA_ITEM_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SOC_METADATA_ITEM_ID")
    @Column(name="METADATA_ITEM_ID")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="METADATA_ID", nullable=false)
    private MetadataEntity metadata;
    @Column(name="OBJECT_TYPE", nullable=false)
    private String objectType;
    @Column(name="OBJECT_ID", nullable=false)
    private String objectId;
    @Column(name="PARENT_OBJECT_ID")
    private String parentObjectId;
    @Column(name="CREATOR_ID", nullable=false)
    private long creatorId;
    @Column(name="CREATED_DATE", nullable=false)
    private Date createdDate;
    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="NAME")
    @Column(name="VALUE")
    @CollectionTable(name="SOC_METADATA_ITEMS_PROPERTIES", joinColumns={@JoinColumn(name="METADATA_ITEM_ID")})
    private Map<String, String> properties;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MetadataEntity getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataEntity metadata) {
        this.metadata = metadata;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getParentObjectId() {
        return this.parentObjectId;
    }

    public void setParentObjectId(String parentObjectId) {
        this.parentObjectId = parentObjectId;
    }

    public long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(long creatorId) {
        this.creatorId = creatorId;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

