/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.MetadataVisitor;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.Emptiable;
import org.opengis.util.CodeList;

final class Pruner
extends MetadataVisitor<Boolean> {
    private static final ThreadLocal<Pruner> VISITORS = ThreadLocal.withInitial(Pruner::new);
    private boolean prune;
    private boolean isEmpty;

    private Pruner() {
    }

    @Override
    final ThreadLocal<Pruner> creator() {
        return VISITORS;
    }

    static boolean isEmpty(AbstractMetadata abstractMetadata, boolean bl) {
        Pruner pruner = VISITORS.get();
        boolean bl2 = pruner.prune;
        pruner.prune = bl;
        Boolean bl3 = (Boolean)pruner.walk(abstractMetadata.getStandard(), abstractMetadata.getInterface(), abstractMetadata, false);
        pruner.prune = bl2;
        return bl3 != null && bl3 != false;
    }

    @Override
    MetadataVisitor.Filter preVisit(PropertyAccessor propertyAccessor) {
        this.isEmpty = true;
        return MetadataVisitor.Filter.NON_EMPTY;
    }

    @Override
    Object visit(Class<?> clazz, Object object) {
        boolean bl = this.isEmpty;
        boolean bl2 = true;
        Collection collection = CollectionsExt.toCollection((Object)object);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!ValueExistencePolicy.isNullOrEmpty(e)) {
                Object object2;
                boolean bl3 = false;
                if (e instanceof AbstractMetadata) {
                    object2 = (AbstractMetadata)e;
                    if (this.prune) {
                        ((AbstractMetadata)object2).prune();
                    }
                    bl3 = ((AbstractMetadata)object2).isEmpty();
                } else if (!this.prune && e instanceof Emptiable) {
                    bl3 = ((Emptiable)e).isEmpty();
                } else if (!(e instanceof Enum) && !(e instanceof CodeList)) {
                    object2 = MetadataStandard.forClass(e.getClass());
                    if (object2 != null) {
                        Boolean bl4 = (Boolean)this.walk((MetadataStandard)object2, clazz, e, false);
                        if (bl4 != null && !(bl3 = bl4.booleanValue()) && e instanceof Emptiable) {
                            bl3 = ((Emptiable)e).isEmpty();
                        }
                    } else if (e instanceof Number) {
                        bl3 = Double.isNaN(((Number)e).doubleValue());
                    } else if (e instanceof Boolean) {
                        boolean bl5 = bl3 = (Boolean)e == false;
                    }
                }
                if (!bl3) {
                    if (!this.prune) {
                        this.isEmpty = false;
                        return SKIP_SIBLINGS;
                    }
                    bl2 = false;
                    continue;
                }
            }
            if (!this.prune || collection != object) continue;
            iterator.remove();
        }
        this.isEmpty = bl & bl2;
        return bl2 & this.prune ? null : object;
    }

    @Override
    Boolean result() {
        return this.isEmpty;
    }
}

