/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.config.NavigationCategoryPlugin;

public class NavigationCategoryService {
    private Map<String, Integer> navigationCategoriesOrder = new HashMap<String, Integer>();
    private Map<String, Integer> navigationUriOrder = new HashMap<String, Integer>();
    private Map<String, String> navigationCategories = new HashMap<String, String>();
    private AtomicInteger orderIndex = new AtomicInteger(1);

    public void addPlugin(NavigationCategoryPlugin navigationCategoryPlugin) {
        String category = navigationCategoryPlugin.getCategory();
        int categoryOrder = navigationCategoryPlugin.getCategoryOrder();
        if (categoryOrder > 0) {
            this.navigationCategoriesOrder.put(category, categoryOrder);
        } else {
            this.navigationCategoriesOrder.computeIfAbsent(category, key -> this.orderIndex.getAndIncrement());
        }
        String uri = navigationCategoryPlugin.getUri();
        int uriOrder = navigationCategoryPlugin.getUriOrder();
        if (uriOrder > 0) {
            this.navigationUriOrder.put(uri, uriOrder);
        } else {
            this.navigationUriOrder.computeIfAbsent(uri, key -> this.orderIndex.getAndIncrement());
        }
        this.navigationCategories.put(uri, category);
    }

    public SortedMap<String, String> getNavigationCategories() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(this::sortCategories);
        treeMap.putAll(this.navigationCategories);
        return treeMap;
    }

    public Map<String, Integer> getNavigationCategoriesOrder() {
        return Collections.unmodifiableMap(this.navigationCategoriesOrder);
    }

    public Map<String, Integer> getNavigationUriOrder() {
        return Collections.unmodifiableMap(this.navigationUriOrder);
    }

    private int sortCategories(String key1, String key2) {
        String cat2;
        if (StringUtils.equals((String)key1, (String)key2)) {
            return 0;
        }
        if (StringUtils.isBlank((String)key1)) {
            return -1;
        }
        if (StringUtils.isBlank((String)key2)) {
            return 1;
        }
        String cat1 = this.navigationCategories.get(key1);
        if (StringUtils.equals((String)cat1, (String)(cat2 = this.navigationCategories.get(key2)))) {
            if (this.navigationUriOrder.containsKey(key1) && this.navigationUriOrder.containsKey(key2)) {
                return this.navigationUriOrder.get(key1) - this.navigationUriOrder.get(key2);
            }
            return 0;
        }
        if (StringUtils.isBlank((String)cat1)) {
            return -1;
        }
        if (StringUtils.isBlank((String)cat2)) {
            return 1;
        }
        int diff = this.navigationCategoriesOrder.get(cat1) - this.navigationCategoriesOrder.get(cat2);
        if (diff == 0) {
            return cat1.compareTo(cat2);
        }
        return diff;
    }
}

