/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.externalstore.model;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;

public class IDMEntityType<T> {
    public static final IDMEntityType<User> USER = new IDMEntityType<User>("User", User.class);
    public static final IDMEntityType<UserProfile> USER_PROFILE = new IDMEntityType<UserProfile>("UserProfile", UserProfile.class);
    public static final IDMEntityType<Group> GROUP = new IDMEntityType<Group>("Group", Group.class);
    public static final IDMEntityType<MembershipType> ROLE = new IDMEntityType<MembershipType>("MembershipType", MembershipType.class);
    public static final IDMEntityType<Membership> MEMBERSHIP = new IDMEntityType<Membership>("Membership", Membership.class);
    public static final IDMEntityType<Set> USER_MEMBERSHIPS = new IDMEntityType<Set>("User memberships", Set.class);
    public static final IDMEntityType<List> GROUP_MEMBERSHIPS = new IDMEntityType<List>("Group memberships", List.class);
    private final Class<T> classType;
    private final int typeIndex;
    private final String name;

    public IDMEntityType(String name, Class<T> classType) {
        if (classType == null) {
            throw new IllegalArgumentException("classType parameter is mandatory");
        }
        if (name == null) {
            throw new IllegalArgumentException("entity type name parameter is mandatory");
        }
        this.classType = classType;
        this.name = name;
        this.typeIndex = this.classType.isAssignableFrom(User.class) ? 1 : (this.classType.isAssignableFrom(Group.class) ? 2 : (this.classType.isAssignableFrom(MembershipType.class) ? 3 : (this.classType.isAssignableFrom(Membership.class) ? 4 : (this.classType.isAssignableFrom(UserProfile.class) ? 5 : (this.classType.isAssignableFrom(Set.class) ? 6 : (this.classType.isAssignableFrom(List.class) ? 7 : 0))))));
    }

    public Class<T> getClassType() {
        return this.classType;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public String getName() {
        return this.name;
    }

    public static IDMEntityType<?> getEntityType(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof User) {
            return USER;
        }
        if (obj instanceof Group) {
            return GROUP;
        }
        if (obj instanceof MembershipType) {
            return ROLE;
        }
        if (obj instanceof Membership) {
            return MEMBERSHIP;
        }
        if (obj instanceof UserProfile) {
            return USER_PROFILE;
        }
        if (obj instanceof Set) {
            return USER_MEMBERSHIPS;
        }
        if (obj instanceof List) {
            return GROUP_MEMBERSHIPS;
        }
        return null;
    }

    public static IDMEntityType<?> getEntityType(int typeIndex) {
        if (typeIndex == USER.getTypeIndex()) {
            return USER;
        }
        if (typeIndex == GROUP.getTypeIndex()) {
            return GROUP;
        }
        if (typeIndex == ROLE.getTypeIndex()) {
            return ROLE;
        }
        if (typeIndex == MEMBERSHIP.getTypeIndex()) {
            return MEMBERSHIP;
        }
        if (typeIndex == USER_PROFILE.getTypeIndex()) {
            return USER_PROFILE;
        }
        if (typeIndex == USER_MEMBERSHIPS.getTypeIndex()) {
            return USER_MEMBERSHIPS;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IDMEntityType)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        IDMEntityType other = (IDMEntityType)obj;
        return Objects.equals(this.getClassType(), other.getClassType());
    }

    public String toString() {
        return this.getClassType().getName();
    }

    public int hashCode() {
        return this.classType == null ? 0 : this.classType.hashCode();
    }
}

