/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.expression.Alias;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.AllColumns;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.AllTableColumns;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectBody;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectExpressionItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SetOperationList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.values.ValuesStatement;

public class AddAliasesVisitor
implements SelectItemVisitor,
SelectVisitor {
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";
    private List<String> aliases = new LinkedList<String>();
    private boolean firstRun = true;
    private int counter = 0;
    private String prefix = "A";

    @Override
    public void visit(PlainSelect plainSelect) {
        this.firstRun = true;
        this.counter = 0;
        this.aliases.clear();
        Iterator<SelectItem> iterator = plainSelect.getSelectItems().iterator();
        while (iterator.hasNext()) {
            iterator.next().accept(this);
        }
        this.firstRun = false;
        iterator = plainSelect.getSelectItems().iterator();
        while (iterator.hasNext()) {
            iterator.next().accept(this);
        }
    }

    @Override
    public void visit(SetOperationList object) {
        object = ((SetOperationList)object).getSelects().iterator();
        while (object.hasNext()) {
            ((SelectBody)object.next()).accept(this);
        }
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
    }

    @Override
    public void visit(SelectExpressionItem selectExpressionItem) {
        if (this.firstRun) {
            if (selectExpressionItem.getAlias() != null) {
                this.aliases.add(selectExpressionItem.getAlias().getName().toUpperCase());
                return;
            }
        } else if (selectExpressionItem.getAlias() == null) {
            String string;
            while (this.aliases.contains(string = this.getNextAlias().toUpperCase())) {
            }
            this.aliases.add(string);
            selectExpressionItem.setAlias(new Alias(string));
            return;
        }
    }

    protected String getNextAlias() {
        ++this.counter;
        return this.prefix + this.counter;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    @Override
    public void visit(WithItem withItem) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(AllColumns allColumns) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(ValuesStatement valuesStatement) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }
}

