/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import ucar.nc2.grib.GribLevelType;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.nc2.time.CalendarPeriod;
import ucar.unidata.util.StringUtil2;

public class Grib2Utils {
    public static String clean(String s) {
        StringBuilder sb = new StringBuilder(s);
        StringUtil2.replace((StringBuilder)sb, (String)"/. ", (String)"-p_");
        StringUtil2.remove((StringBuilder)sb, (String)"(),;");
        char c = sb.charAt(0);
        if (Character.isLetter(c)) {
            if (Character.isLowerCase(c)) {
                sb.setCharAt(0, Character.toUpperCase(c));
            }
        } else {
            sb.insert(0, 'N');
        }
        return sb.toString().trim();
    }

    public static String getVariableName(Grib2Record gr) {
        String s = WmoCodeTable.getParameterName(gr.getDiscipline(), gr.getPDS().getParameterCategory(), gr.getPDS().getParameterNumber());
        if (s == null) {
            s = "U" + gr.getDiscipline() + "-" + gr.getPDS().getParameterCategory() + "-" + gr.getPDS().getParameterNumber();
        }
        return s;
    }

    public static CalendarPeriod getCalendarPeriod(int timeUnit) {
        switch (timeUnit) {
            case 0: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Minute);
            }
            case 1: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
            }
            case 2: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Day);
            }
            case 3: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Month);
            }
            case 4: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Year);
            }
            case 5: {
                return CalendarPeriod.of((int)10, (CalendarPeriod.Field)CalendarPeriod.Field.Year);
            }
            case 6: {
                return CalendarPeriod.of((int)30, (CalendarPeriod.Field)CalendarPeriod.Field.Year);
            }
            case 7: {
                return CalendarPeriod.of((int)100, (CalendarPeriod.Field)CalendarPeriod.Field.Year);
            }
            case 10: {
                return CalendarPeriod.of((int)3, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
            }
            case 11: {
                return CalendarPeriod.of((int)6, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
            }
            case 12: {
                return CalendarPeriod.of((int)12, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
            }
            case 13: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Second);
            }
        }
        return null;
    }

    public static VertCoord.VertUnit getLevelUnit(int code) {
        switch (code) {
            case 11: 
            case 12: {
                return new GribLevelType(code, "m", null, true);
            }
            case 20: {
                return new GribLevelType(code, "K", null, false);
            }
            case 100: {
                return new GribLevelType(code, "Pa", null, false);
            }
            case 102: {
                return new GribLevelType(code, "m", "mean sea level", true);
            }
            case 103: {
                return new GribLevelType(code, "m", "ground", true);
            }
            case 104: 
            case 105: {
                return new GribLevelType(code, "sigma", null, false);
            }
            case 106: {
                return new GribLevelType(code, "m", "land surface", false);
            }
            case 107: {
                return new GribLevelType(code, "K", null, true);
            }
            case 108: {
                return new GribLevelType(code, "Pa", "ground", true);
            }
            case 109: {
                return new GribLevelType(code, "K m2 kg-1 s-1", null, true);
            }
            case 117: {
                return new GribLevelType(code, "m", null, true);
            }
            case 119: {
                return new GribLevelType(code, "Pa", null, false);
            }
            case 160: {
                return new GribLevelType(code, "m", "sea level", false);
            }
            case 235: {
                return new GribLevelType(code, "0.1 C", null, true);
            }
            case 237: {
                return new GribLevelType(code, "m", null, true);
            }
            case 238: {
                return new GribLevelType(code, "m", null, true);
            }
        }
        return new GribLevelType(code, null, null, true);
    }

    public static boolean isLevelUsed(int code) {
        VertCoord.VertUnit vunit = Grib2Utils.getLevelUnit(code);
        return vunit.isVerticalCoordinate();
    }

    public static boolean isLayer(Grib2Pds pds) {
        return pds.getLevelType2() != 255 && pds.getLevelType2() != 0;
    }

    public static boolean isLatLon(int gridTemplate, int center) {
        return gridTemplate < 4 || gridTemplate >= 40 && gridTemplate < 44;
    }

    public static boolean isLatLon2D(int gridTemplate, int center) {
        return center == 7 && gridTemplate == 204;
    }

    public static LatLonCoordType getLatLon2DcoordType(String desc) {
        Object type = desc.contains("u-component") ? LatLonCoordType.U : (desc.contains("v-component") ? LatLonCoordType.V : (desc.contains("Latitude of") || desc.contains("Longitude of") ? null : LatLonCoordType.P));
        return type;
    }

    public static String cleanupHeader(byte[] raw) {
        String result = StringUtil2.cleanup((byte[])raw);
        int pos = result.indexOf("data");
        if (pos > 0) {
            result = result.substring(pos);
        }
        return result;
    }

    public static enum LatLonCoordType {
        U,
        V,
        P;

    }
}

