/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.es.service;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.api.service.AnalyticsService;
import org.exoplatform.analytics.api.service.StatisticUIWatcherPlugin;
import org.exoplatform.analytics.api.service.StatisticWatcher;
import org.exoplatform.analytics.es.AnalyticsESClient;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.model.StatisticFieldMapping;
import org.exoplatform.analytics.model.StatisticFieldValue;
import org.exoplatform.analytics.model.chart.ChartAggregationLabel;
import org.exoplatform.analytics.model.chart.ChartAggregationResult;
import org.exoplatform.analytics.model.chart.ChartAggregationValue;
import org.exoplatform.analytics.model.chart.ChartData;
import org.exoplatform.analytics.model.chart.ChartDataList;
import org.exoplatform.analytics.model.chart.PercentageChartResult;
import org.exoplatform.analytics.model.chart.PercentageChartValue;
import org.exoplatform.analytics.model.chart.TableColumnItemValue;
import org.exoplatform.analytics.model.chart.TableColumnResult;
import org.exoplatform.analytics.model.filter.AnalyticsFilter;
import org.exoplatform.analytics.model.filter.AnalyticsPercentageFilter;
import org.exoplatform.analytics.model.filter.AnalyticsPeriod;
import org.exoplatform.analytics.model.filter.AnalyticsPeriodType;
import org.exoplatform.analytics.model.filter.AnalyticsTableColumnFilter;
import org.exoplatform.analytics.model.filter.AnalyticsTableFilter;
import org.exoplatform.analytics.model.filter.aggregation.AnalyticsAggregation;
import org.exoplatform.analytics.model.filter.aggregation.AnalyticsAggregationType;
import org.exoplatform.analytics.model.filter.aggregation.AnalyticsPercentageLimit;
import org.exoplatform.analytics.model.filter.search.AnalyticsFieldFilter;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.picocontainer.Startable;

public class ESAnalyticsService
implements AnalyticsService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(ESAnalyticsService.class);
    private static final String ANALYTICS_ADMIN_PERMISSION_PARAM_NAME = "exo.analytics.admin.permissions";
    private static final String ANALYTICS_VIEW_ALL_PERMISSION_PARAM_NAME = "exo.analytics.viewall.permissions";
    private static final String ANALYTICS_VIEW_PERMISSION_PARAM_NAME = "exo.analytics.view.permissions";
    private static final String RETURNED_AGGREGATION_DOCS_COUNT_PARAM_NAME = "exo.analytics.aggregation.terms.doc_size";
    private static final String AGGREGATION_KEYS_SEPARATOR = "-";
    private static final String AGGREGATION_RESULT_PARAM = "aggregation_result";
    private static final String AGGREGATION_RESULT_VALUE_PARAM = "aggregation_result_value";
    private static final String AGGREGATION_BUCKETS_VALUE_PARAM = "aggregation_buckets_value";
    private static final Context CONTEXT = Context.GLOBAL.id("ANALYTICS");
    private static final Scope ES_SCOPE = Scope.GLOBAL.id("elasticsearch");
    private static final String ES_AGGREGATED_MAPPING = "ES_AGGREGATED_MAPPING";
    private List<StatisticUIWatcherPlugin> uiWatcherPlugins = new ArrayList<StatisticUIWatcherPlugin>();
    private List<StatisticWatcher> uiWatchers = new ArrayList<StatisticWatcher>();
    private AnalyticsESClient esClient;
    private SettingService settingService;
    private Map<String, StatisticFieldMapping> esMappings = new HashMap<String, StatisticFieldMapping>();
    private ScheduledExecutorService esMappingUpdater = Executors.newScheduledThreadPool(1);
    private List<String> administratorsPermissions;
    private List<String> viewAllPermissions;
    private List<String> viewPermissions;
    private int aggregationReturnedDocumentsSize = 1000;

    public ESAnalyticsService(AnalyticsESClient esClient, SettingService settingService, InitParams params) {
        this.esClient = esClient;
        this.settingService = settingService;
        this.administratorsPermissions = params != null && params.containsKey((Object)ANALYTICS_ADMIN_PERMISSION_PARAM_NAME) ? params.getValuesParam(ANALYTICS_ADMIN_PERMISSION_PARAM_NAME).getValues() : Collections.emptyList();
        this.viewAllPermissions = params != null && params.containsKey((Object)ANALYTICS_VIEW_ALL_PERMISSION_PARAM_NAME) ? params.getValuesParam(ANALYTICS_VIEW_ALL_PERMISSION_PARAM_NAME).getValues() : Collections.emptyList();
        this.viewPermissions = params != null && params.containsKey((Object)ANALYTICS_VIEW_PERMISSION_PARAM_NAME) ? params.getValuesParam(ANALYTICS_VIEW_PERMISSION_PARAM_NAME).getValues() : Collections.emptyList();
        if (params != null && params.containsKey((Object)RETURNED_AGGREGATION_DOCS_COUNT_PARAM_NAME)) {
            this.aggregationReturnedDocumentsSize = Integer.parseInt(params.getValueParam(RETURNED_AGGREGATION_DOCS_COUNT_PARAM_NAME).getValue());
        }
    }

    public void start() {
        this.esMappingUpdater.scheduleAtFixedRate(() -> {
            PortalContainer container = PortalContainer.getInstance();
            ExoContainerContext.setCurrentContainer((ExoContainer)container);
            RequestLifeCycle.begin((ExoContainer)container);
            try {
                this.retrieveMapping(true);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while getting mapping from elasticsearch", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }, 1L, 2L, TimeUnit.MINUTES);
    }

    public void stop() {
        this.esMappingUpdater.shutdown();
    }

    public Set<StatisticFieldMapping> retrieveMapping(boolean forceRefresh) {
        if (!forceRefresh) {
            if (this.esMappings.isEmpty()) {
                this.readFieldsMapping();
            }
            return new HashSet<StatisticFieldMapping>(this.esMappings.values());
        }
        try {
            String mappingJsonString = this.esClient.retrieveAllAnalyticsIndexesMapping();
            if (StringUtils.isBlank((CharSequence)mappingJsonString)) {
                return new HashSet<StatisticFieldMapping>(this.esMappings.values());
            }
            JSONObject result = new JSONObject(mappingJsonString);
            JSONObject mappingObject = AnalyticsUtils.getJSONObject((JSONObject)result, (int)0, (String[])new String[]{null, "mappings", "properties"});
            if (mappingObject != null) {
                String[] fieldNames;
                for (String fieldName : fieldNames = JSONObject.getNames((JSONObject)mappingObject)) {
                    JSONObject esField = mappingObject.getJSONObject(fieldName);
                    String fieldType = esField.getString("type");
                    JSONObject keywordField = AnalyticsUtils.getJSONObject((JSONObject)esField, (int)0, (String[])new String[]{"fields", "keyword"});
                    StatisticFieldMapping esFieldMapping = new StatisticFieldMapping(fieldName, fieldType, keywordField != null);
                    this.esMappings.put(fieldName, esFieldMapping);
                }
            }
            this.addESDateSubField("hourOfDay");
            this.addESDateSubField("dayOfMonth");
            this.addESDateSubField("dayOfWeek");
            this.addESDateSubField("dayOfYear");
            this.addESDateSubField("monthOfYear");
            this.addESDateSubField("year");
            this.storeFieldsMappings();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting mapping of analytics", (Throwable)e);
        }
        return new HashSet<StatisticFieldMapping>(this.esMappings.values());
    }

    public List<StatisticFieldValue> retrieveFieldValues(String field, int limit) {
        StatisticFieldMapping fieldMapping = this.getFieldMapping(field);
        if (fieldMapping == null || !fieldMapping.isAggregation()) {
            return Collections.emptyList();
        }
        String esQuery = this.buildAnalyticsQuery(Collections.singletonList(new AnalyticsAggregation(AnalyticsAggregationType.TERMS, fieldMapping.getAggregationFieldName(), "desc", null, (long)limit)), null, null, 0L, 0L);
        String jsonResponse = this.esClient.sendRequest(esQuery);
        try {
            return this.buildFieldValuesResponse(jsonResponse);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error parsing results for field: " + field + ", response: " + jsonResponse, e);
        }
    }

    public PercentageChartResult computePercentageChartData(AnalyticsPercentageFilter percentageFilter) {
        if (percentageFilter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        AnalyticsPeriod currentPeriod = percentageFilter.getCurrentAnalyticsPeriod();
        AnalyticsPeriod previousPeriod = percentageFilter.getPreviousAnalyticsPeriod();
        PercentageChartResult percentageChartResult = new PercentageChartResult();
        AnalyticsPercentageLimit percentageLimit = percentageFilter.getPercentageLimit();
        if (percentageLimit != null) {
            long previousPeriodLimit;
            this.computePercentageLimits(percentageFilter, percentageChartResult, currentPeriod, previousPeriod);
            long currentPeriodLimit = percentageFilter.getCurrentPeriodLimit();
            if (currentPeriodLimit > 0L) {
                this.computePercentageValuesPerPeriod(percentageChartResult, percentageFilter.computeValueFilter(currentPeriod, currentPeriodLimit), currentPeriod, null, true, true);
            }
            if ((previousPeriodLimit = percentageFilter.getPreviousPeriodLimit()) > 0L) {
                this.computePercentageValuesPerPeriod(percentageChartResult, percentageFilter.computeValueFilter(previousPeriod, previousPeriodLimit), null, previousPeriod, true, true);
            }
        } else {
            this.computePercentageValuesPerPeriod(percentageChartResult, percentageFilter.computeValueFilter(), currentPeriod, previousPeriod, true, false);
        }
        this.computePercentageValuesPerPeriod(percentageChartResult, percentageFilter.computeThresholdFilter(), currentPeriod, previousPeriod, false, false);
        return percentageChartResult;
    }

    public TableColumnResult computeTableColumnData(TableColumnResult columnResult, AnalyticsTableFilter tableFilter, AnalyticsFilter filter, AnalyticsPeriod period, AnalyticsPeriodType periodType, int columnIndex, boolean isValue) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        if (filter.getAggregations() == null || filter.getAggregations().isEmpty()) {
            throw new IllegalArgumentException("Filter aggregations is mandatory");
        }
        String esQueryString = this.buildAnalyticsQuery(filter.getAggregations(), filter.getFilters(), filter.zoneId(), filter.getOffset(), filter.getLimit());
        String jsonResponse = this.esClient.sendRequest(esQueryString);
        try {
            return this.buildTableColumnDataFromESResponse(columnResult, tableFilter, period, periodType, columnIndex, isValue, jsonResponse, filter.getLimit());
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error parsing results with - filter: " + filter + " - query: " + esQueryString + " - response: " + jsonResponse, e);
        }
    }

    public ChartDataList computeChartData(AnalyticsFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        if (filter.getAggregations() == null || filter.getAggregations().isEmpty()) {
            throw new IllegalArgumentException("Filter aggregations is mandatory");
        }
        String esQueryString = this.buildAnalyticsQuery(filter.getAggregations(), filter.getFilters(), filter.zoneId(), filter.getOffset(), filter.getLimit());
        String jsonResponse = this.esClient.sendRequest(esQueryString);
        try {
            return this.buildChartDataFromESResponse(filter, jsonResponse);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error parsing results with - filter: " + filter + " - query: " + esQueryString + " - response: " + jsonResponse, e);
        }
    }

    public PercentageChartValue computePercentageChartData(AnalyticsFilter filter, AnalyticsPeriod currentPeriod, AnalyticsPeriod previousPeriod, boolean hasLimitAggregation) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        if (filter.getAggregations() == null || filter.getAggregations().isEmpty()) {
            throw new IllegalArgumentException("Filter aggregations is mandatory");
        }
        AnalyticsAggregation yAxisAggregation = filter.getYAxisAggregation();
        AnalyticsAggregationType aggregationType = yAxisAggregation == null ? AnalyticsAggregationType.COUNT : yAxisAggregation.getType();
        String esQueryString = this.buildAnalyticsQuery(filter.getAggregations(), filter.getFilters(), aggregationType, hasLimitAggregation, filter.zoneId(), filter.getOffset(), filter.getLimit());
        String jsonResponse = this.esClient.sendRequest(esQueryString);
        try {
            return this.buildPercentageChartValuesFromESResponse(jsonResponse, currentPeriod, previousPeriod);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error parsing results with - filter: " + filter + " - query: " + esQueryString + " - response: " + jsonResponse, e);
        }
    }

    public List<StatisticData> retrieveData(AnalyticsFilter filter) {
        List filters = filter == null ? Collections.emptyList() : filter.getFilters();
        long offset = filter == null ? 0L : filter.getOffset();
        long limit = filter == null ? 10L : filter.getLimit();
        ZoneId timeZone = filter == null ? null : filter.zoneId();
        String esQueryString = this.buildAnalyticsQuery(null, filters, timeZone, offset, limit);
        String jsonResponse = this.esClient.sendRequest(esQueryString);
        try {
            return this.buildSearchResultFromESResponse(jsonResponse);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error parsing results with filter: " + filter + ", response: " + jsonResponse, e);
        }
    }

    public List<String> getAdministratorsPermissions() {
        return this.administratorsPermissions;
    }

    public List<String> getViewAllPermissions() {
        return this.viewAllPermissions;
    }

    public List<String> getViewPermissions() {
        return this.viewPermissions;
    }

    public List<StatisticWatcher> getUIWatchers() {
        return this.uiWatchers;
    }

    public StatisticWatcher getUIWatcher(String name) {
        return this.getUIWatchers().stream().filter(watcher -> StringUtils.equals((CharSequence)name, (CharSequence)watcher.getName())).findFirst().orElse(null);
    }

    public void addUIWatcherPlugin(StatisticUIWatcherPlugin uiWatcherPlugin) {
        this.uiWatcherPlugins.add(uiWatcherPlugin);
        this.uiWatchers.add(uiWatcherPlugin.getStatisticWatcher());
    }

    private List<StatisticFieldValue> buildFieldValuesResponse(String jsonResponse) throws JSONException {
        JSONArray buckets;
        JSONObject result;
        JSONObject aggregations;
        JSONObject json = new JSONObject(jsonResponse);
        JSONObject jSONObject = aggregations = json.has("aggregations") ? json.getJSONObject("aggregations") : null;
        if (aggregations == null) {
            return Collections.emptyList();
        }
        JSONObject jSONObject2 = result = aggregations.has(AGGREGATION_RESULT_PARAM) ? aggregations.getJSONObject(AGGREGATION_RESULT_PARAM) : null;
        if (result == null) {
            return Collections.emptyList();
        }
        JSONArray jSONArray = buckets = result.has("buckets") ? result.getJSONArray("buckets") : null;
        if (buckets == null) {
            return Collections.emptyList();
        }
        ArrayList<StatisticFieldValue> results = new ArrayList<StatisticFieldValue>();
        for (int i = 0; i < buckets.length(); ++i) {
            JSONObject bucket = buckets.getJSONObject(i);
            String value = bucket.getString("key");
            long count = bucket.getLong("doc_count");
            results.add(new StatisticFieldValue(value, count));
        }
        return results;
    }

    private void addESDateSubField(String dateFieldName) {
        StatisticFieldMapping fieldMapping = new StatisticFieldMapping("doc['timestamp'].value." + dateFieldName, "long", false, true);
        this.esMappings.put(fieldMapping.getName(), fieldMapping);
    }

    private String buildAnalyticsQuery(List<AnalyticsAggregation> aggregations, List<AnalyticsFieldFilter> filters, ZoneId timeZone, long offset, long limit) {
        return this.buildAnalyticsQuery(aggregations, filters, null, false, timeZone, offset, limit);
    }

    private String buildAnalyticsQuery(List<AnalyticsAggregation> aggregations, List<AnalyticsFieldFilter> filters, AnalyticsAggregationType aggregationType, boolean hasLimitAggregation, ZoneId timeZone, long offset, long limit) {
        boolean isCount = aggregations != null;
        StringBuilder esQuery = new StringBuilder();
        esQuery.append("{");
        this.buildSearchFilterQuery(esQuery, filters, offset, limit, isCount);
        if (isCount) {
            this.buildAggregationQuery(esQuery, aggregations, aggregationType, timeZone, hasLimitAggregation);
        }
        esQuery.append("}");
        String esQueryString = esQuery.toString();
        esQueryString = AnalyticsUtils.fixJSONStringFormat((String)esQueryString);
        LOG.debug("ES query to compute chart data with aggregations :{}, filters :{} . Query: {}", new Object[]{aggregations, filters, esQueryString});
        return esQueryString;
    }

    private void buildSearchFilterQuery(StringBuilder esQuery, List<AnalyticsFieldFilter> filters, long offset, long limit, boolean isCount) {
        if (isCount) {
            esQuery.append("     \"size\" : 0");
        } else {
            if (offset > 0L) {
                esQuery.append("     \"from\" : ").append(offset).append(",");
            }
            if (limit <= 0L || limit > Integer.MAX_VALUE) {
                limit = 10000L;
            }
            esQuery.append("     \"size\" : ").append(limit).append(",");
            esQuery.append("     \"sort\" : [{ \"timestamp\":{\"order\" : \"desc\"}}]");
        }
        this.appendSearchFilterConditions(filters, esQuery);
    }

    private void appendSearchFilterConditions(List<AnalyticsFieldFilter> filters, StringBuilder esQuery) {
        filters = filters == null ? new ArrayList<AnalyticsFieldFilter>() : new ArrayList<AnalyticsFieldFilter>(filters);
        esQuery.append(",");
        esQuery.append("    \"query\": {");
        esQuery.append("      \"bool\" : {");
        esQuery.append("        \"must\" : [");
        for (AnalyticsFieldFilter fieldFilter : filters) {
            String esFieldName = fieldFilter.getField();
            StatisticFieldMapping fieldMapping = this.esMappings.get(esFieldName);
            if (fieldMapping != null) {
                esFieldName = fieldMapping.getAggregationFieldName();
            }
            String esQueryValue = fieldMapping == null ? StatisticFieldMapping.computeESQueryValue((String)fieldFilter.getValueString()) : fieldMapping.getESQueryValue(fieldFilter.getValueString());
            switch (fieldFilter.getType()) {
                case NOT_NULL: {
                    esQuery.append("        {\"exists\" : {\"").append("field").append("\" : \"").append(esFieldName).append("\"      }},");
                    break;
                }
                case IS_NULL: {
                    esQuery.append("        {\"bool\": {\"must_not\": {\"exists\": {\"field\": \"").append(esFieldName).append("\"      }}}},");
                    break;
                }
                case EQUAL: {
                    esQuery.append("        {\"match\" : {\"").append(esFieldName).append("\" : ").append(esQueryValue).append("        }},");
                    break;
                }
                case NOT_EQUAL: {
                    esQuery.append("        {\"bool\": {\"must_not\": {\"match\" : {\"").append(esFieldName).append("\" : ").append(esQueryValue).append("        }}}},");
                    break;
                }
                case GREATER: {
                    esQuery.append("        {\"range\" : {\"").append(esFieldName).append("\" : {").append("\"gte\" : ").append(esQueryValue).append("        }}},");
                    break;
                }
                case LESS: {
                    esQuery.append("        {\"range\" : {\"").append(esFieldName).append("\" : {").append("\"lte\" : ").append(esQueryValue).append("        }}},");
                    break;
                }
                case RANGE: {
                    AnalyticsFilter.Range range = fieldFilter.getRange();
                    esQuery.append("        {\"range\" : {\"").append(esFieldName).append("\" : {").append("\"gte\" : ").append(range.getMin()).append(",\"lte\" : ").append(range.getMax()).append("        }}},");
                    break;
                }
                case IN_SET: {
                    esQuery.append("        {\"terms\" : {\"").append(esFieldName).append("\" : ").append(AnalyticsUtils.collectionToJSONString((String)fieldFilter.getValueString())).append("        }},");
                    break;
                }
                case NOT_IN_SET: {
                    esQuery.append("        {\"bool\": {\"must_not\": {\"terms\" : {\"").append(esFieldName).append("\" : ").append(AnalyticsUtils.collectionToJSONString((String)fieldFilter.getValueString())).append("        }}}},");
                    break;
                }
            }
        }
        esQuery.append("        ],");
        esQuery.append("      },");
        esQuery.append("     },");
    }

    private void buildAggregationQuery(StringBuilder esQuery, List<AnalyticsAggregation> aggregations, AnalyticsAggregationType percentageAggregationType, ZoneId timeZone, boolean hasLimitAggregation) {
        if (aggregations != null && !aggregations.isEmpty()) {
            StringBuffer endOfQuery = new StringBuffer();
            int aggregationsSize = aggregations.size();
            for (int i = 0; i < aggregationsSize; ++i) {
                AnalyticsAggregation aggregation = aggregations.get(i);
                AnalyticsAggregationType aggregationType = aggregation.getType();
                if (aggregationType.isUseInterval() && StringUtils.isBlank((CharSequence)aggregation.getInterval())) {
                    throw new IllegalStateException("Analytics aggregation type '" + aggregationType + "' is using intervals while it has empty interval");
                }
                String fieldName = this.getAggregationFieldName(aggregationType);
                long limit = aggregation.getLimit();
                if (aggregationType.isUseLimit() && limit <= 0L) {
                    limit = this.aggregationReturnedDocumentsSize;
                }
                esQuery.append("     ,\"aggs\": {");
                esQuery.append("       \"").append(fieldName).append("\": {");
                esQuery.append("         \"").append(aggregationType.getAggName()).append("\": {");
                String aggregationFieldName = aggregation.getField();
                StatisticFieldMapping aggregationField = this.getFieldMapping(aggregationFieldName);
                if (aggregationField == null || !aggregationField.isScriptedField()) {
                    esQuery.append("           \"field\": \"").append(aggregationFieldName).append("\"");
                } else {
                    esQuery.append("           \"script\": {").append("             \"lang\": \"painless\",").append("             \"source\": \"").append(aggregationFieldName).append("\"").append("}");
                }
                if (aggregationType.isUseInterval()) {
                    esQuery.append(",");
                    if (Arrays.asList("year", "quarter", "month", "week", "day", "hour", "minute").contains(aggregation.getInterval())) {
                        esQuery.append("           \"calendar_interval\": \"");
                    } else {
                        esQuery.append("           \"fixed_interval\": \"");
                    }
                    esQuery.append(aggregation.getInterval()).append("\"");
                    if (aggregation.getOffset() != null) {
                        esQuery.append(",").append("           \"offset\": \"").append(aggregation.getOffset()).append("\"");
                    }
                    if (timeZone != null && !ZoneOffset.UTC.equals(timeZone) && aggregationFieldName.equals("timestamp")) {
                        esQuery.append(",").append("           \"time_zone\": \"").append(timeZone.getId()).append("\"");
                    }
                    if (aggregation.isUseBounds()) {
                        esQuery.append(",").append("           \"min_doc_count\": 0,").append("").append("           \"extended_bounds\": {").append("             \"min\": ").append(aggregation.getMinBound()).append(",").append("             \"max\": ").append(aggregation.getMaxBound()).append("            }");
                    }
                }
                if (aggregationType.isUseLimit() && limit > 0L) {
                    esQuery.append("           ,\"size\": ").append(limit);
                }
                if (aggregationType.isUseSort()) {
                    String sortField = null;
                    if (i + 1 < aggregationsSize) {
                        AnalyticsAggregation nextAggregation = aggregations.get(i + 1);
                        sortField = this.getSortField(nextAggregation);
                    } else if (aggregationType == AnalyticsAggregationType.TERMS) {
                        sortField = "_count";
                    }
                    if (sortField != null) {
                        esQuery.append(",           \"order\": {\"").append(sortField).append("\": \"").append(aggregation.getSortDirection()).append("\"}");
                    }
                }
                esQuery.append("         }");
                endOfQuery.append("       }");
                if (hasLimitAggregation && percentageAggregationType != null) {
                    if (i != aggregationsSize - 1) {
                        endOfQuery.append("     }");
                    }
                    if (i != aggregationsSize - 2) continue;
                    String bucketAggregationType = null;
                    switch (percentageAggregationType) {
                        case MIN: {
                            bucketAggregationType = "min_bucket";
                            break;
                        }
                        case MAX: {
                            bucketAggregationType = "max_bucket";
                            break;
                        }
                        case AVG: {
                            bucketAggregationType = "avg_bucket";
                            break;
                        }
                        default: {
                            bucketAggregationType = "sum_bucket";
                        }
                    }
                    String aggregationResultBucketName = "aggregation_result>aggregation_result_value.value";
                    endOfQuery.append("     },");
                    endOfQuery.append("     \"").append(AGGREGATION_BUCKETS_VALUE_PARAM).append("\": {");
                    endOfQuery.append("       \"").append(bucketAggregationType).append("\": {");
                    endOfQuery.append("         \"buckets_path\": \"" + aggregationResultBucketName + "\"");
                    endOfQuery.append("       }");
                    endOfQuery.append("     }");
                    continue;
                }
                endOfQuery.append("     }");
            }
            esQuery.append(endOfQuery);
        }
    }

    private String getAggregationFieldName(AnalyticsAggregationType aggregationType) {
        String fieldName = null;
        fieldName = AnalyticsAggregationType.TERMS == aggregationType || AnalyticsAggregationType.DATE == aggregationType || AnalyticsAggregationType.HISTOGRAM == aggregationType ? AGGREGATION_RESULT_PARAM : AGGREGATION_RESULT_VALUE_PARAM;
        return fieldName;
    }

    private String getSortField(AnalyticsAggregation nextAggregation) {
        if (nextAggregation == null) {
            return null;
        }
        if (nextAggregation.getType().isNumericResult()) {
            return this.getAggregationFieldName(nextAggregation.getType()) + ".value";
        }
        return "_count";
    }

    private void computePercentageLimits(AnalyticsPercentageFilter percentageFilter, PercentageChartResult percentageChartResult, AnalyticsPeriod currentPeriod, AnalyticsPeriod previousPeriod) {
        AnalyticsPercentageLimit percentageLimit = percentageFilter.getPercentageLimit();
        PercentageChartValue chartValue = this.computePercentageChartData(percentageFilter.computeLimitFilter(), currentPeriod, previousPeriod, false);
        double currentPeriodLimit = chartValue.getCurrentPeriodValue();
        double previousPeriodLimit = chartValue.getPreviousPeriodValue();
        percentageChartResult.setCurrentPeriodLimit(currentPeriodLimit);
        percentageChartResult.setPreviousPeriodLimit(previousPeriodLimit);
        percentageFilter.setCurrentPeriodLimit(Math.round(currentPeriodLimit * percentageLimit.getPercentage() / 100.0));
        percentageFilter.setPreviousPeriodLimit(Math.round(previousPeriodLimit * percentageLimit.getPercentage() / 100.0));
    }

    private void computePercentageValuesPerPeriod(PercentageChartResult percentageResult, AnalyticsFilter analyticsFilter, AnalyticsPeriod currentPeriod, AnalyticsPeriod previousPeriod, boolean isValue, boolean hasLimitAggregation) {
        PercentageChartValue chartValue = this.computePercentageChartData(analyticsFilter, currentPeriod, previousPeriod, hasLimitAggregation);
        if (isValue) {
            if (chartValue.getCurrentPeriodValue() > 0.0) {
                percentageResult.setCurrentPeriodValue(chartValue.getCurrentPeriodValue());
            }
            if (chartValue.getPreviousPeriodValue() > 0.0) {
                percentageResult.setPreviousPeriodValue(chartValue.getPreviousPeriodValue());
            }
        } else {
            percentageResult.setCurrentPeriodThreshold(chartValue.getCurrentPeriodValue());
            percentageResult.setPreviousPeriodThreshold(chartValue.getPreviousPeriodValue());
        }
        percentageResult.setComputingTime(percentageResult.getComputingTime() + chartValue.getComputingTime());
        percentageResult.setDataCount(percentageResult.getDataCount() + chartValue.getDataCount());
    }

    private TableColumnResult buildTableColumnDataFromESResponse(TableColumnResult tableColumnResult, AnalyticsTableFilter tableFilter, AnalyticsPeriod period, AnalyticsPeriodType periodType, int columnIndex, boolean isValue, String jsonResponse, long limit) throws JSONException {
        JSONArray buckets;
        JSONObject result;
        JSONObject json;
        JSONObject aggregations;
        if (tableColumnResult == null) {
            tableColumnResult = new TableColumnResult();
        }
        JSONObject jSONObject = aggregations = (json = new JSONObject(jsonResponse)).has("aggregations") ? json.getJSONObject("aggregations") : null;
        if (aggregations == null) {
            return tableColumnResult;
        }
        JSONObject jSONObject2 = result = aggregations.has(AGGREGATION_RESULT_PARAM) ? aggregations.getJSONObject(AGGREGATION_RESULT_PARAM) : null;
        if (result == null) {
            return tableColumnResult;
        }
        JSONArray jSONArray = buckets = result.has("buckets") ? result.getJSONArray("buckets") : null;
        if (buckets == null) {
            return tableColumnResult;
        }
        AnalyticsTableColumnFilter columnFilter = tableFilter.getColumnFilter(columnIndex);
        LinkedHashMap<String, TableColumnItemValue> itemValues = new LinkedHashMap<String, TableColumnItemValue>();
        tableColumnResult.getItems().forEach(item -> itemValues.put(item.getKey(), (TableColumnItemValue)item));
        if (columnFilter.isPreviousPeriod()) {
            AnalyticsPeriod currentPeriod = tableFilter.getCurrentPeriod(period, periodType);
            AnalyticsPeriod previousPeriod = tableFilter.getPreviousPeriod(period, periodType);
            for (int i = buckets.length() - 1; i >= 0; --i) {
                JSONObject bucket = buckets.getJSONObject(i);
                long timestamp = bucket.getLong("key");
                boolean isCurrent = currentPeriod.isInPeriod(timestamp);
                if (!isCurrent && !previousPeriod.isInPeriod(timestamp) || !bucket.has(AGGREGATION_RESULT_PARAM) || !bucket.getJSONObject(AGGREGATION_RESULT_PARAM).has("buckets")) continue;
                JSONArray subBuckets = bucket.getJSONObject(AGGREGATION_RESULT_PARAM).getJSONArray("buckets");
                for (int j = 0; j < subBuckets.length(); ++j) {
                    JSONObject subBucket = subBuckets.getJSONObject(j);
                    String key = subBucket.getString("key");
                    TableColumnItemValue itemValue = itemValues.computeIfAbsent(key, mapKey -> new TableColumnItemValue());
                    itemValue.setKey(key);
                    if (columnIndex == 0) {
                        itemValue.setValue((Object)key);
                        continue;
                    }
                    this.computeColumnItemValue(itemValue, subBucket, isCurrent, isValue);
                }
            }
        } else {
            for (int i = 0; i < buckets.length(); ++i) {
                JSONObject bucket = buckets.getJSONObject(i);
                String key = bucket.getString("key");
                TableColumnItemValue itemValue = new TableColumnItemValue();
                itemValue.setKey(key);
                if (columnIndex == 0) {
                    itemValue.setValue((Object)key);
                } else {
                    this.computeColumnItemValue(itemValue, bucket, true, isValue);
                }
                itemValues.put(itemValue.getKey(), itemValue);
            }
        }
        List<Object> itemsList = null;
        itemsList = limit > 0L ? itemValues.values().stream().limit(limit).collect(Collectors.toList()) : new ArrayList(itemValues.values());
        tableColumnResult.setItems(itemsList);
        return tableColumnResult;
    }

    private void computeColumnItemValue(TableColumnItemValue itemValue, JSONObject bucket, boolean isCurrent, boolean isValue) throws JSONException {
        Object value;
        if (bucket.has(AGGREGATION_RESULT_VALUE_PARAM)) {
            value = bucket.getJSONObject(AGGREGATION_RESULT_VALUE_PARAM).getString("value");
        } else if (bucket.has(AGGREGATION_RESULT_PARAM)) {
            JSONObject subAggregationResult = bucket.getJSONObject(AGGREGATION_RESULT_PARAM);
            ArrayList<String> values = new ArrayList<String>();
            if (subAggregationResult.has("buckets")) {
                JSONArray subAggregationBuckets = subAggregationResult.getJSONArray("buckets");
                for (int j = 0; j < subAggregationBuckets.length(); ++j) {
                    JSONObject subAggregationBucket = subAggregationBuckets.getJSONObject(j);
                    values.add(subAggregationBucket.getString("key"));
                }
            }
            value = values;
        } else {
            value = bucket.has("value") ? bucket.getString("value") : null;
        }
        if (isValue) {
            if (isCurrent) {
                itemValue.setValue(value);
            } else {
                itemValue.setPreviousValue(value);
            }
        } else if (isCurrent) {
            itemValue.setThreshold(value);
        } else {
            itemValue.setPreviousThreshold(value);
        }
    }

    private PercentageChartValue buildPercentageChartValuesFromESResponse(String jsonResponse, AnalyticsPeriod currentPeriod, AnalyticsPeriod previousPeriod) throws JSONException {
        PercentageChartValue percentageChartValue = new PercentageChartValue();
        JSONObject json = new JSONObject(jsonResponse);
        JSONObject aggregations = json.getJSONObject("aggregations");
        if (aggregations == null) {
            return percentageChartValue;
        }
        percentageChartValue.setComputingTime(json.getLong("took"));
        JSONObject hitsResult = json.getJSONObject("hits");
        percentageChartValue.setDataCount(hitsResult.getJSONObject("total").getLong("value"));
        if (aggregations.has(AGGREGATION_BUCKETS_VALUE_PARAM)) {
            double valueDouble;
            String value = aggregations.getJSONObject(AGGREGATION_BUCKETS_VALUE_PARAM).getString("value");
            double d = valueDouble = StringUtils.isBlank((CharSequence)value) || StringUtils.equals((CharSequence)"null", (CharSequence)value) ? 0.0 : Double.parseDouble(value);
            if (currentPeriod != null) {
                percentageChartValue.setCurrentPeriodValue(valueDouble);
            } else if (previousPeriod != null) {
                percentageChartValue.setPreviousPeriodValue(valueDouble);
            }
        } else if (aggregations.has(AGGREGATION_RESULT_PARAM)) {
            JSONArray buckets = aggregations.getJSONObject(AGGREGATION_RESULT_PARAM).getJSONArray("buckets");
            HashMap<Long, Double> values = new HashMap<Long, Double>();
            if (buckets.length() > 0) {
                for (int i = 0; i < buckets.length(); ++i) {
                    String value;
                    JSONObject bucket = buckets.getJSONObject(i);
                    Long timestamp = bucket.getLong("key");
                    if (bucket.has(AGGREGATION_BUCKETS_VALUE_PARAM)) {
                        value = bucket.getJSONObject(AGGREGATION_BUCKETS_VALUE_PARAM).getString("value");
                        values.put(timestamp, StringUtils.isBlank((CharSequence)value) || StringUtils.equals((CharSequence)"null", (CharSequence)value) ? 0.0 : Double.parseDouble(value));
                        continue;
                    }
                    if (bucket.has(AGGREGATION_RESULT_VALUE_PARAM)) {
                        value = bucket.getJSONObject(AGGREGATION_RESULT_VALUE_PARAM).getString("value");
                        values.put(timestamp, StringUtils.isBlank((CharSequence)value) || StringUtils.equals((CharSequence)"null", (CharSequence)value) ? 0.0 : Double.parseDouble(value));
                        continue;
                    }
                    LOG.warn("Can't extract value from bucket {}", new Object[]{bucket});
                }
                if (currentPeriod != null) {
                    double currentPeriodValue = values.entrySet().stream().filter(aggregationValue -> {
                        long timestamp = (Long)aggregationValue.getKey();
                        return timestamp < currentPeriod.getToInMS() && timestamp >= currentPeriod.getFromInMS();
                    }).map(Map.Entry::getValue).findFirst().orElse(0.0);
                    percentageChartValue.setCurrentPeriodValue(currentPeriodValue);
                }
                if (previousPeriod != null) {
                    double previousPeriodValue = values.entrySet().stream().filter(aggregationValue -> {
                        long timestamp = (Long)aggregationValue.getKey();
                        return timestamp < previousPeriod.getToInMS() && timestamp >= previousPeriod.getFromInMS();
                    }).map(Map.Entry::getValue).findFirst().orElse(0.0);
                    percentageChartValue.setPreviousPeriodValue(previousPeriodValue);
                }
            }
        }
        return percentageChartValue;
    }

    private ChartDataList buildChartDataFromESResponse(AnalyticsFilter filter, String jsonResponse) throws JSONException {
        AnalyticsAggregation multipleChartsAggregation = filter.getMultipleChartsAggregation();
        String lang = filter.getLang();
        ChartDataList chartsData = new ChartDataList(lang);
        JSONObject json = new JSONObject(jsonResponse);
        JSONObject aggregations = json.getJSONObject("aggregations");
        if (aggregations == null) {
            return chartsData;
        }
        JSONObject hitsResult = (JSONObject)json.get("hits");
        chartsData.setComputingTime(json.getLong("took"));
        chartsData.setDataCount(hitsResult.getJSONObject("total").getLong("value"));
        int level = multipleChartsAggregation == null ? 0 : -1;
        this.computeAggregatedResultEntry(filter, aggregations, chartsData, multipleChartsAggregation, null, null, level);
        this.addEmptyResultsToNotExistingEntries(chartsData);
        return chartsData;
    }

    private void computeAggregatedResultEntry(AnalyticsFilter filter, JSONObject aggregations, ChartDataList chartsData, AnalyticsAggregation multipleChartsAggregation, ChartAggregationValue parentAggregation, ArrayList<ChartAggregationValue> aggregationValues, int level) throws JSONException {
        String lang = filter.getLang();
        JSONObject aggsResult = aggregations.getJSONObject(AGGREGATION_RESULT_PARAM);
        JSONArray buckets = aggsResult.getJSONArray("buckets");
        if (buckets.length() > 0) {
            int nextLevel = level + 1;
            for (int i = 0; i < buckets.length(); ++i) {
                String key;
                JSONObject bucketResult = buckets.getJSONObject(i);
                ArrayList<ChartAggregationValue> childAggregationValues = new ArrayList<ChartAggregationValue>();
                if (aggregationValues != null) {
                    childAggregationValues.addAll(aggregationValues);
                }
                if (bucketResult.isNull(AGGREGATION_RESULT_PARAM)) {
                    key = bucketResult.getString("key");
                    String result = null;
                    if (bucketResult.isNull(AGGREGATION_RESULT_VALUE_PARAM)) {
                        result = bucketResult.get("doc_count").toString();
                    } else {
                        JSONObject valueResult = bucketResult.getJSONObject(AGGREGATION_RESULT_VALUE_PARAM);
                        result = valueResult.get("value").toString();
                    }
                    this.addAggregationValue(key, filter, childAggregationValues, level);
                    List labels = childAggregationValues.stream().map(ChartAggregationValue::getFieldLabel).collect(Collectors.toList());
                    String label = StringUtils.join(labels, (String)AGGREGATION_KEYS_SEPARATOR);
                    ChartAggregationLabel chartLabel = new ChartAggregationLabel(childAggregationValues, label, lang);
                    ChartAggregationResult aggregationResult = new ChartAggregationResult(chartLabel, chartLabel.getLabel(), result);
                    chartsData.addAggregationResult(parentAggregation, aggregationResult);
                    continue;
                }
                key = bucketResult.getString("key");
                ChartAggregationValue parentAggregationToUse = parentAggregation;
                if (multipleChartsAggregation != null && level == -1) {
                    String fieldLabel = multipleChartsAggregation.getType() == AnalyticsAggregationType.DATE ? multipleChartsAggregation.getLabel(key, filter.zoneId(), filter.getLang()) : multipleChartsAggregation.getLabel(key);
                    parentAggregationToUse = new ChartAggregationValue(multipleChartsAggregation, key, fieldLabel);
                } else {
                    this.addAggregationValue(key, filter, childAggregationValues, level);
                }
                this.computeAggregatedResultEntry(filter, bucketResult, chartsData, multipleChartsAggregation, parentAggregationToUse, childAggregationValues, nextLevel);
            }
        }
    }

    private void addAggregationValue(String key, AnalyticsFilter filter, ArrayList<ChartAggregationValue> aggregationValues, int level) {
        AnalyticsAggregation aggregation = null;
        if (filter.getXAxisAggregations().size() < level) {
            if (filter.getYAxisAggregation() == null) {
                throw new IllegalStateException("Can't find relative aggregation to index " + level);
            }
            aggregation = filter.getYAxisAggregation();
        } else {
            aggregation = (AnalyticsAggregation)filter.getXAxisAggregations().get(level);
        }
        String fieldLabel = null;
        fieldLabel = aggregation == null ? key : (aggregation.getType() == AnalyticsAggregationType.DATE ? aggregation.getLabel(key, filter.zoneId(), filter.getLang()) : aggregation.getLabel(key));
        ChartAggregationValue aggregationValue = new ChartAggregationValue(aggregation, key, fieldLabel);
        aggregationValues.add(aggregationValue);
    }

    private List<StatisticData> buildSearchResultFromESResponse(String jsonResponse) throws JSONException {
        ArrayList<StatisticData> results = new ArrayList<StatisticData>();
        JSONObject json = new JSONObject(jsonResponse);
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return results;
        }
        JSONArray jsonHits = jsonResult.getJSONArray("hits");
        for (int i = 0; i < jsonHits.length(); ++i) {
            JSONObject statisticDataJsonObject = jsonHits.getJSONObject(i).getJSONObject("_source");
            int statusOrdinal = statisticDataJsonObject.getInt("status");
            statisticDataJsonObject.put("status", (Object)StatisticData.StatisticStatus.values()[statusOrdinal]);
            StatisticData statisticData = (StatisticData)AnalyticsUtils.fromJsonString((String)statisticDataJsonObject.toString(), StatisticData.class);
            AnalyticsUtils.DEFAULT_FIELDS.stream().forEach(arg_0 -> ((JSONObject)statisticDataJsonObject).remove(arg_0));
            statisticData.setParameters(new HashMap());
            Iterator remainingKeys = statisticDataJsonObject.keys();
            while (remainingKeys.hasNext()) {
                String key = (String)remainingKeys.next();
                statisticData.getParameters().put(key, statisticDataJsonObject.getString(key));
            }
            results.add(statisticData);
        }
        return results;
    }

    private StatisticFieldMapping getFieldMapping(String fieldName) {
        return this.esMappings.get(fieldName);
    }

    private void readFieldsMapping() {
        SettingValue existingMapping = this.settingService.get(CONTEXT, ES_SCOPE, ES_AGGREGATED_MAPPING);
        if (existingMapping == null) {
            return;
        }
        String esMappingSerialized = existingMapping.getValue().toString();
        try {
            JSONObject jsonObject = new JSONObject(esMappingSerialized);
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                String fieldMappingString = jsonObject.getString(key);
                StatisticFieldMapping fieldMapping = (StatisticFieldMapping)AnalyticsUtils.fromJsonString((String)fieldMappingString, StatisticFieldMapping.class);
                this.esMappings.put(key, fieldMapping);
            }
        }
        catch (JSONException e) {
            LOG.error((Object)"Error reading ES mapped fields", (Throwable)e);
        }
    }

    private void storeFieldsMappings() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        Set<String> keys = this.esMappings.keySet();
        for (String key : keys) {
            jsonObject.put(key, (Object)AnalyticsUtils.toJsonString((Object)this.esMappings.get(key)));
        }
        this.settingService.set(CONTEXT, ES_SCOPE, ES_AGGREGATED_MAPPING, SettingValue.create((String)jsonObject.toString()));
    }

    private void addEmptyResultsToNotExistingEntries(ChartDataList chartsData) {
        LinkedHashSet aggregationLabels = chartsData.getAggregationLabels();
        int index = 0;
        for (ChartAggregationLabel chartAggregationLabel : aggregationLabels) {
            ChartAggregationResult emptyResult = new ChartAggregationResult(chartAggregationLabel, chartAggregationLabel.getLabel(), null);
            LinkedHashSet charts = chartsData.getCharts();
            for (ChartData chartData : charts) {
                chartData.addAggregationResult(emptyResult, index, false);
            }
            ++index;
        }
    }
}

