/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.configuration;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityExistsException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.storage.RuleStorage;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RuleServiceImpl
implements RuleService {
    private static final Log LOG = ExoLogger.getLogger(RuleServiceImpl.class);
    private RuleStorage ruleStorage;

    public RuleServiceImpl(RuleStorage ruleStorage) {
        this.ruleStorage = ruleStorage;
    }

    @Override
    public RuleDTO findEnableRuleByTitle(String ruleTitle) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)ruleTitle)) {
            throw new IllegalArgumentException("rule title is mandatory");
        }
        RuleDTO rule = this.ruleStorage.findEnableRuleByTitle(ruleTitle);
        return rule;
    }

    @Override
    public RuleDTO findRuleById(Long id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("rule id is mandatory");
        }
        return this.ruleStorage.findRuleById(id);
    }

    @Override
    public List<RuleDTO> findEnabledRulesByEvent(String event) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)event)) {
            throw new IllegalArgumentException("rule event is mandatory");
        }
        return this.ruleStorage.findEnabledRulesByEvent(event);
    }

    @Override
    public RuleDTO findRuleByTitle(String ruleTitle) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)ruleTitle)) {
            throw new IllegalArgumentException("rule title is mandatory");
        }
        return this.ruleStorage.findRuleByTitle(ruleTitle);
    }

    @Override
    public RuleDTO findRuleByEventAndDomain(String ruleTitle, String domain) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)ruleTitle)) {
            throw new IllegalArgumentException("rule title is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)domain)) {
            throw new IllegalArgumentException("rule domain is mandatory");
        }
        return this.ruleStorage.findRuleByEventAndDomain(ruleTitle, domain);
    }

    @Override
    public List<RuleDTO> getAllAutomaticRules() {
        return this.ruleStorage.getAllAutomaticRules();
    }

    @Override
    public List<RuleDTO> findAllRules() {
        return this.ruleStorage.findAllRules();
    }

    @Override
    public List<RuleDTO> getActiveRules() {
        return this.ruleStorage.getActiveRules();
    }

    @Override
    public List<RuleDTO> getAllRulesByDomain(String domain) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)domain)) {
            throw new IllegalArgumentException("rule domain is mandatory");
        }
        return this.ruleStorage.getAllRulesByDomain(domain);
    }

    @Override
    public List<RuleDTO> getAllRulesWithNullDomain() {
        return this.ruleStorage.getAllRulesWithNullDomain();
    }

    @Override
    public List<String> getAllEvents() {
        return this.ruleStorage.getAllEvents();
    }

    @Override
    public List<String> getDomainListFromRules() {
        return this.ruleStorage.getDomainListFromRules();
    }

    @Override
    public void deleteRule(Long id) throws IllegalArgumentException, ObjectNotFoundException {
        if (id == null) {
            throw new IllegalArgumentException("rule id is mandatory");
        }
        RuleDTO rule = this.ruleStorage.findRuleById(id);
        if (rule == null) {
            throw new ObjectNotFoundException("Rule does not exist");
        }
        rule.setDeleted(true);
        this.ruleStorage.deleteRule(rule);
    }

    @Override
    public RuleDTO addRule(RuleDTO ruleDTO) throws IllegalArgumentException, EntityExistsException {
        if (ruleDTO == null) {
            throw new IllegalArgumentException("rule is mandatory");
        }
        RuleDTO oldRule = this.ruleStorage.findRuleByEventAndDomain(ruleDTO.getEvent(), ruleDTO.getArea());
        if (oldRule != null) {
            throw new EntityExistsException("Rule with same event and domain already exist");
        }
        return this.ruleStorage.saveRule(ruleDTO);
    }

    @Override
    public RuleDTO updateRule(RuleDTO ruleDTO) throws ObjectNotFoundException {
        RuleDTO oldRule = this.ruleStorage.findRuleByEventAndDomain(ruleDTO.getEvent(), ruleDTO.getArea());
        if (oldRule == null) {
            throw new ObjectNotFoundException("Rule does not exist");
        }
        if (!ruleDTO.getTitle().startsWith("def_")) {
            ruleDTO.setTitle(ruleDTO.getEvent() + "_" + ruleDTO.getArea());
        }
        ruleDTO.setLastModifiedDate(Utils.toRFC3339Date(new Date()));
        return this.ruleStorage.saveRule(ruleDTO);
    }
}

