/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.notes.activity.processor;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.NoteService;

public class ActivityNotesProcessor
extends BaseActivityProcessorPlugin {
    private static final Log LOG = ExoLogger.getLogger(ActivityNotesProcessor.class);
    private NoteService noteService;

    public ActivityNotesProcessor(NoteService noteService, InitParams initParams) {
        super(initParams);
        this.noteService = noteService;
    }

    public void processActivity(ExoSocialActivity activity) {
        if (activity.isComment() || activity.getType() == null || activity.getTemplateParams() == null || !activity.getTemplateParams().containsKey("page_type") || !activity.getTemplateParams().containsKey("page_owner") || !activity.getTemplateParams().containsKey("page_id")) {
            return;
        }
        String pageOwnerType = (String)activity.getTemplateParams().get("page_type");
        String pageOwner = (String)activity.getTemplateParams().get("page_owner");
        String pageId = (String)activity.getTemplateParams().get("page_id");
        try {
            Page page = this.noteService.getNoteOfNoteBookByName(pageOwnerType, pageOwner, pageId);
            if (page != null) {
                activity.setMetadataObjectType("notes");
                activity.setMetadataObjectId(page.getId());
            }
        }
        catch (WikiException e) {
            LOG.warn("Error getting notes page {}/{}/{}", new Object[]{pageOwnerType, pageOwner, pageId, e});
        }
    }
}

