/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.cached;

import java.io.Serializable;
import org.exoplatform.addons.gamification.service.dto.configuration.Announcement;
import org.exoplatform.addons.gamification.storage.AnnouncementStorage;
import org.exoplatform.addons.gamification.storage.RuleStorage;
import org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class AnnouncementCachedStorage
extends AnnouncementStorage {
    private static final int ANNOUNCEMENT_ID_CONTEXT = 0;
    private static final String ANNOUNCEMENT_CACHE_NAME = "gamification.announcement";
    private FutureExoCache<Serializable, Object, Integer> announcementFutureCache;

    public AnnouncementCachedStorage(GamificationHistoryDAO gamificationHistoryDAO, RuleStorage ruleStorage, CacheService cacheService) {
        super(gamificationHistoryDAO, ruleStorage);
        ExoCache domainCache = cacheService.getCacheInstance(ANNOUNCEMENT_CACHE_NAME);
        Loader<Serializable, Object, Integer> domainLoader = new Loader<Serializable, Object, Integer>(){

            public Object retrieve(Integer context, Serializable key) throws Exception {
                if (context == 0) {
                    return AnnouncementCachedStorage.super.countAnnouncementsByChallenge((Long)key);
                }
                throw new IllegalStateException("Unknown context id " + context);
            }
        };
        this.announcementFutureCache = new FutureExoCache((Loader)domainLoader, domainCache);
    }

    @Override
    public Long countAnnouncementsByChallenge(Long challengeId) {
        return (Long)this.announcementFutureCache.get((Object)0, (Object)challengeId);
    }

    @Override
    public Announcement saveAnnouncement(Announcement announcement) {
        try {
            Announcement announcement2 = super.saveAnnouncement(announcement);
            return announcement2;
        }
        finally {
            this.announcementFutureCache.remove((Serializable)announcement.getChallengeId());
        }
    }
}

