/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.cached;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.storage.DomainStorage;
import org.exoplatform.addons.gamification.storage.dao.DomainDAO;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class DomainCachedStorage
extends DomainStorage {
    private static final int DOMAIN_ID_CONTEXT = 0;
    private static final int DOMAIN_TITLE_CONTEXT = 1;
    private static final int ALL_DOMAIN_CONTEXT = 2;
    private static final int DOMAIN_ENABLED_CONTEXT = 3;
    private static final String DOMAIN_CACHE_NAME = "gamification.domain";
    private FutureExoCache<Serializable, Object, Integer> domainFutureCache;

    public DomainCachedStorage(DomainDAO domainDAO, CacheService cacheService) {
        super(domainDAO);
        ExoCache domainCache = cacheService.getCacheInstance(DOMAIN_CACHE_NAME);
        Loader<Serializable, Object, Integer> domainLoader = new Loader<Serializable, Object, Integer>(){

            public Object retrieve(Integer context, Serializable key) throws Exception {
                if (context == 0) {
                    return DomainCachedStorage.super.getDomainByID((Long)key);
                }
                if (context == 1) {
                    return DomainCachedStorage.super.findDomainByTitle((String)((Object)key));
                }
                if (context == 2) {
                    return DomainCachedStorage.super.getAllDomains();
                }
                if (context == 3) {
                    return DomainCachedStorage.super.getEnabledDomains();
                }
                throw new IllegalStateException("Unknown context id " + context);
            }
        };
        this.domainFutureCache = new FutureExoCache((Loader)domainLoader, domainCache);
    }

    @Override
    public DomainDTO saveDomain(DomainDTO domain) {
        try {
            DomainDTO domainDTO = domain = super.saveDomain(domain);
            return domainDTO;
        }
        finally {
            this.domainFutureCache.remove((Serializable)domain.getId());
            this.domainFutureCache.remove((Serializable)((Object)domain.getTitle()));
            this.domainFutureCache.remove((Serializable)Integer.valueOf(0));
            this.domainFutureCache.remove((Serializable)Integer.valueOf(1));
        }
    }

    @Override
    public DomainDTO getDomainByID(Long id) {
        return (DomainDTO)this.domainFutureCache.get((Object)0, (Object)id);
    }

    @Override
    public DomainDTO findDomainByTitle(String title) {
        return (DomainDTO)this.domainFutureCache.get((Object)1, (Object)title);
    }

    @Override
    public List<DomainDTO> getAllDomains() {
        return (List)this.domainFutureCache.get((Object)2, (Object)0);
    }

    @Override
    public List<DomainDTO> getEnabledDomains() {
        return (List)this.domainFutureCache.get((Object)3, (Object)1);
    }

    public void clearCache() {
        this.domainFutureCache.clear();
    }
}

