/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.UIExtensionEventListener;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiAttachmentUploadListForm;
import org.exoplatform.wiki.webui.UIWikiBottomArea;
import org.exoplatform.wiki.webui.UIWikiPageContentArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.filter.RemoveAttachmentPermissionFilter;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/control/action/RemoveAttachmentActionComponent.gtmpl", events={@EventConfig(listeners={RemoveAttachmentActionListener.class})})
public class RemoveAttachmentActionComponent
extends UIContainer {
    public static final String DELETE_ACTION = "RemoveAttachment";
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new RemoveAttachmentPermissionFilter()});
    private String attachmentName;

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    public static class RemoveAttachmentActionListener
    extends UIExtensionEventListener<RemoveAttachmentActionComponent> {
        protected void processEvent(Event<RemoveAttachmentActionComponent> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((RemoveAttachmentActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiPageContentArea contentArea = (UIWikiPageContentArea)wikiPortlet.findFirstComponentOfType(UIWikiPageContentArea.class);
            UIWikiAttachmentUploadListForm attachmentUploadListForm = (UIWikiAttachmentUploadListForm)wikiPortlet.findFirstComponentOfType(UIWikiAttachmentUploadListForm.class);
            UIWikiBottomArea bottomArea = (UIWikiBottomArea)wikiPortlet.findFirstComponentOfType(UIWikiBottomArea.class);
            Page page = attachmentUploadListForm.getCurrentWikiPage();
            String attachmentName = URLDecoder.decode(event.getRequestContext().getRequestParameter("objectId"), "UTF-8");
            WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
            wikiService.deleteAttachmentOfPage(attachmentName, page);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)bottomArea);
            if (WikiMode.VIEW.equals((Object)wikiPortlet.getWikiMode())) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)contentArea);
            }
        }

        protected Map<String, Object> createContext(Event<RemoveAttachmentActionComponent> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((RemoveAttachmentActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiAttachmentUploadListForm attachmentUploadListForm = (UIWikiAttachmentUploadListForm)wikiPortlet.findFirstComponentOfType(UIWikiAttachmentUploadListForm.class);
            Page page = attachmentUploadListForm.getCurrentWikiPage();
            String attachmentName = URLDecoder.decode(event.getRequestContext().getRequestParameter("objectId"), "UTF-8");
            WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
            Attachment attachment = wikiService.getAttachmentOfPageByName(attachmentName, page);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("attachmentName", attachment);
            return context;
        }

        protected String getExtensionType() {
            return "org.exoplatform.wiki.webui.UIWikiAttachmentUploadListForm";
        }
    }
}

