/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.nio.CharBuffer;
import java.util.Arrays;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Static;
import org.apache.sis.util.StringBuilders;

public final class CharSequences
extends Static {
    public static final String[] EMPTY_ARRAY = new String[0];
    private static final String[] SPACES = new String[10];

    private CharSequences() {
    }

    private static int codePointAfter(CharSequence charSequence, int n) {
        return Character.codePointAt(charSequence, n + Character.charCount(Character.codePointAt(charSequence, n)));
    }

    public static CharSequence spaces(final int n) {
        if (n <= 0) {
            return "";
        }
        if (n < SPACES.length) {
            String string = SPACES[n - 1];
            if (string == null) {
                char[] cArray = new char[n];
                Arrays.fill(cArray, ' ');
                CharSequences.SPACES[n - 1] = string = new String(cArray).intern();
            }
            return string;
        }
        return new CharSequence(){

            @Override
            public int length() {
                return n;
            }

            @Override
            public char charAt(int n2) {
                ArgumentChecks.ensureValidIndex(n, n2);
                return ' ';
            }

            @Override
            public CharSequence subSequence(int n4, int n2) {
                ArgumentChecks.ensureValidIndexRange(n, n4, n2);
                int n3 = n2 - n4;
                return n3 == n ? this : CharSequences.spaces(n3);
            }

            @Override
            public String toString() {
                char[] cArray = new char[n];
                Arrays.fill(cArray, ' ');
                return new String(cArray);
            }
        };
    }

    public static int length(CharSequence charSequence) {
        return charSequence != null ? charSequence.length() : 0;
    }

    public static int codePointCount(CharSequence charSequence) {
        return charSequence != null ? CharSequences.codePointCount(charSequence, 0, charSequence.length()) : 0;
    }

    public static int codePointCount(CharSequence charSequence, int n, int n2) {
        CharBuffer charBuffer;
        if (charSequence == null) {
            return 0;
        }
        if (charSequence instanceof String) {
            return ((String)charSequence).codePointCount(n, n2);
        }
        if (charSequence instanceof StringBuilder) {
            return ((StringBuilder)charSequence).codePointCount(n, n2);
        }
        if (charSequence instanceof StringBuffer) {
            return ((StringBuffer)charSequence).codePointCount(n, n2);
        }
        if (charSequence instanceof CharBuffer && (charBuffer = (CharBuffer)charSequence).hasArray() && !charBuffer.isReadOnly()) {
            int n3 = charBuffer.position();
            return Character.codePointCount(charBuffer.array(), n3 + n, n3 + n2);
        }
        return Character.codePointCount(charSequence, n, n2);
    }

    public static int count(CharSequence charSequence, String string) {
        ArgumentChecks.ensureNonEmpty("toSearch", string);
        int n = string.length();
        if (n == 1) {
            return CharSequences.count(charSequence, string.charAt(0));
        }
        int n2 = 0;
        if (charSequence != null) {
            int n3 = 0;
            while ((n3 = CharSequences.indexOf(charSequence, string, n3, charSequence.length())) >= 0) {
                ++n2;
                n3 += n;
            }
        }
        return n2;
    }

    public static int count(CharSequence charSequence, char c) {
        int n;
        block4: {
            n = 0;
            if (charSequence == null) break block4;
            if (charSequence instanceof String) {
                String string = (String)charSequence;
                int n2 = string.indexOf(c);
                while (++n2 != 0) {
                    ++n;
                    n2 = string.indexOf(c, n2);
                }
            } else {
                int n3 = charSequence.length();
                while (--n3 >= 0) {
                    if (charSequence.charAt(n3) != c) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n, int n2) {
        ArgumentChecks.ensureNonEmpty("toSearch", charSequence2);
        if (charSequence != null) {
            int n3 = charSequence.length();
            if (n2 > n3) {
                n2 = n3;
            }
            if (charSequence2 instanceof String && n2 == n3) {
                if (charSequence instanceof String) {
                    return ((String)charSequence).indexOf((String)charSequence2, n);
                }
                if (charSequence instanceof StringBuilder) {
                    return ((StringBuilder)charSequence).indexOf((String)charSequence2, n);
                }
                if (charSequence instanceof StringBuffer) {
                    return ((StringBuffer)charSequence).indexOf((String)charSequence2, n);
                }
            }
            if (n < 0) {
                n = 0;
            }
            n3 = charSequence2.length();
            n2 -= n3;
            while (n <= n2) {
                block10: {
                    for (int i = 0; i < n3; ++i) {
                        if (charSequence.charAt(n + i) == charSequence2.charAt(i)) {
                            continue;
                        }
                        break block10;
                    }
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public static int indexOf(CharSequence charSequence, int n, int n2, int n3) {
        if (charSequence != null) {
            int n4 = charSequence.length();
            if (n3 >= n4) {
                if (charSequence instanceof String) {
                    return ((String)charSequence).indexOf(n, n2);
                }
                n3 = n4;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            char c = (char)n;
            char c2 = '\u0000';
            if (c != n) {
                c = Character.highSurrogate(n);
                c2 = Character.lowSurrogate(n);
                --n3;
            }
            while (n2 < n3) {
                if (charSequence.charAt(n2) == c && (c2 == '\u0000' || charSequence.charAt(n2 + 1) == c2)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence charSequence, int n, int n2, int n3) {
        if (charSequence != null) {
            int n4;
            if (n2 <= 0) {
                if (charSequence instanceof String) {
                    return ((String)charSequence).lastIndexOf(n, n3 - 1);
                }
                n2 = 0;
            }
            if (n3 > (n4 = charSequence.length())) {
                n3 = n4;
            }
            char c = (char)n;
            char c2 = '\u0000';
            if (c != n) {
                c = Character.lowSurrogate(n);
                c2 = Character.highSurrogate(n);
                ++n2;
            }
            while (n3 > n2) {
                if (charSequence.charAt(--n3) != c || c2 != '\u0000' && charSequence.charAt(--n3) != c2) continue;
                return n3;
            }
        }
        return -1;
    }

    public static int indexOfLineStart(CharSequence charSequence, int n, int n2) {
        char c;
        int n3 = charSequence.length();
        if (n <= 0) {
            while (true) {
                if (n2 == 0) {
                    return n2;
                }
                if ((c = charSequence.charAt(--n2)) == '\n') {
                    if (n2 != 0 && charSequence.charAt(n2 - 1) == '\r') {
                        --n2;
                    }
                } else if (c != '\r') continue;
                if (++n == 1) break;
            }
        }
        block1: while (--n >= 0) {
            do {
                if (n2 == n3) {
                    return n2;
                }
                if ((c = charSequence.charAt(n2++)) != '\r') continue;
                if (n2 == n3 || charSequence.charAt(n2) != '\n') continue block1;
                ++n2;
                continue block1;
            } while (c != '\n');
        }
        return n2;
    }

    public static int skipLeadingWhitespaces(CharSequence charSequence, int n, int n2) {
        int n3;
        while (n < n2 && Character.isWhitespace(n3 = Character.codePointAt(charSequence, n))) {
            n += Character.charCount(n3);
        }
        return n;
    }

    public static int skipTrailingWhitespaces(CharSequence charSequence, int n, int n2) {
        int n3;
        while (n2 > n && Character.isWhitespace(n3 = Character.codePointBefore(charSequence, n2))) {
            n2 -= Character.charCount(n3);
        }
        return n2;
    }

    private static CharSequence[] createSplitArray(CharSequence charSequence) {
        return charSequence instanceof String || charSequence instanceof StringBuilder || charSequence instanceof StringBuffer ? new String[8] : new CharSequence[8];
    }

    public static CharSequence[] split(CharSequence charSequence, char c) {
        CharSequence charSequence2;
        if (charSequence == null) {
            return EMPTY_ARRAY;
        }
        if (c == '\n' || c == '\r') {
            CharSequence[] charSequenceArray = CharSequences.splitOnEOL(charSequence);
            for (int i = 0; i < charSequenceArray.length; ++i) {
                charSequenceArray[i] = CharSequences.trimWhitespaces(charSequenceArray[i]);
            }
            return charSequenceArray;
        }
        boolean bl = Character.isWhitespace(c);
        CharSequence[] charSequenceArray = CharSequences.createSplitArray(charSequence);
        int n = charSequence.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n4 = CharSequences.indexOf(charSequence, c, n4, n)) >= 0) {
            charSequence2 = CharSequences.trimWhitespaces(charSequence, n3, n4);
            if (!bl || charSequence2.length() != 0) {
                if (n2 == charSequenceArray.length) {
                    charSequenceArray = Arrays.copyOf(charSequenceArray, n2 << 1);
                }
                charSequenceArray[n2++] = charSequence2;
            }
            n3 = ++n4;
        }
        charSequence2 = CharSequences.trimWhitespaces(charSequence, n3, n);
        if (!bl || charSequence2.length() != 0) {
            if (n2 == charSequenceArray.length) {
                charSequenceArray = Arrays.copyOf(charSequenceArray, n2 + 1);
            }
            charSequenceArray[n2++] = charSequence2;
        }
        return ArraysExt.resize(charSequenceArray, n2);
    }

    public static CharSequence[] splitOnEOL(CharSequence charSequence) {
        boolean bl;
        if (charSequence == null) {
            return EMPTY_ARRAY;
        }
        int n = charSequence.length();
        int n2 = CharSequences.indexOf(charSequence, 10, 0, n);
        int n3 = CharSequences.indexOf(charSequence, 13, 0, n);
        if (n2 < 0 && n3 < 0) {
            return new CharSequence[]{charSequence};
        }
        int n4 = 0;
        CharSequence[] charSequenceArray = CharSequences.createSplitArray(charSequence);
        int n5 = 0;
        do {
            int n6;
            int n7 = 1;
            if (n3 < 0) {
                n6 = n2;
                bl = (n2 = CharSequences.indexOf(charSequence, 10, n2 + 1, n)) >= 0;
            } else if (n2 < 0) {
                n6 = n3;
                bl = (n3 = CharSequences.indexOf(charSequence, 13, n3 + 1, n)) >= 0;
            } else if (n2 < n3) {
                n6 = n2;
                bl = true;
                n2 = CharSequences.indexOf(charSequence, 10, n2 + 1, n);
            } else {
                n6 = n3++;
                if (n2 == n3) {
                    n3 = CharSequences.indexOf(charSequence, 13, n3 + 1, n);
                    n2 = CharSequences.indexOf(charSequence, 10, n2 + 1, n);
                    bl = n3 >= 0 || n2 >= 0;
                    n7 = 2;
                } else {
                    n3 = CharSequences.indexOf(charSequence, 13, n3 + 1, n);
                    bl = true;
                }
            }
            if (n4 >= charSequenceArray.length) {
                charSequenceArray = Arrays.copyOf(charSequenceArray, n4 * 2);
            }
            charSequenceArray[n4++] = charSequence.subSequence(n5, n6);
            n5 = n6 + n7;
        } while (bl);
        if (n4 >= charSequenceArray.length) {
            charSequenceArray = Arrays.copyOf(charSequenceArray, n4 + 1);
        }
        charSequenceArray[n4++] = charSequence.subSequence(n5, charSequence.length());
        return ArraysExt.resize(charSequenceArray, n4);
    }

    private static boolean isEmpty(CharSequence[] charSequenceArray) {
        switch (charSequenceArray.length) {
            case 0: {
                return true;
            }
            case 1: {
                return charSequenceArray[0].length() == 0;
            }
        }
        return false;
    }

    public static double[] parseDoubles(CharSequence charSequence, char c) throws NumberFormatException {
        CharSequence[] charSequenceArray = CharSequences.split(charSequence, c);
        if (CharSequences.isEmpty(charSequenceArray)) {
            return ArraysExt.EMPTY_DOUBLE;
        }
        double[] dArray = new double[charSequenceArray.length];
        for (int i = 0; i < charSequenceArray.length; ++i) {
            String string = CharSequences.trimWhitespaces(charSequenceArray[i]).toString();
            dArray[i] = string.isEmpty() ? Double.NaN : Double.parseDouble(string);
        }
        return dArray;
    }

    public static float[] parseFloats(CharSequence charSequence, char c) throws NumberFormatException {
        CharSequence[] charSequenceArray = CharSequences.split(charSequence, c);
        if (CharSequences.isEmpty(charSequenceArray)) {
            return ArraysExt.EMPTY_FLOAT;
        }
        float[] fArray = new float[charSequenceArray.length];
        for (int i = 0; i < charSequenceArray.length; ++i) {
            String string = CharSequences.trimWhitespaces(charSequenceArray[i]).toString();
            fArray[i] = string.isEmpty() ? Float.NaN : Float.parseFloat(string);
        }
        return fArray;
    }

    public static long[] parseLongs(CharSequence charSequence, char c, int n) throws NumberFormatException {
        CharSequence[] charSequenceArray = CharSequences.split(charSequence, c);
        if (CharSequences.isEmpty(charSequenceArray)) {
            return ArraysExt.EMPTY_LONG;
        }
        long[] lArray = new long[charSequenceArray.length];
        for (int i = 0; i < charSequenceArray.length; ++i) {
            lArray[i] = Long.parseLong(CharSequences.trimWhitespaces(charSequenceArray[i]).toString(), n);
        }
        return lArray;
    }

    public static int[] parseInts(CharSequence charSequence, char c, int n) throws NumberFormatException {
        CharSequence[] charSequenceArray = CharSequences.split(charSequence, c);
        if (CharSequences.isEmpty(charSequenceArray)) {
            return ArraysExt.EMPTY_INT;
        }
        int[] nArray = new int[charSequenceArray.length];
        for (int i = 0; i < charSequenceArray.length; ++i) {
            nArray[i] = Integer.parseInt(CharSequences.trimWhitespaces(charSequenceArray[i]).toString(), n);
        }
        return nArray;
    }

    public static short[] parseShorts(CharSequence charSequence, char c, int n) throws NumberFormatException {
        CharSequence[] charSequenceArray = CharSequences.split(charSequence, c);
        if (CharSequences.isEmpty(charSequenceArray)) {
            return ArraysExt.EMPTY_SHORT;
        }
        short[] sArray = new short[charSequenceArray.length];
        for (int i = 0; i < charSequenceArray.length; ++i) {
            sArray[i] = Short.parseShort(CharSequences.trimWhitespaces(charSequenceArray[i]).toString(), n);
        }
        return sArray;
    }

    public static byte[] parseBytes(CharSequence charSequence, char c, int n) throws NumberFormatException {
        CharSequence[] charSequenceArray = CharSequences.split(charSequence, c);
        if (CharSequences.isEmpty(charSequenceArray)) {
            return ArraysExt.EMPTY_BYTE;
        }
        byte[] byArray = new byte[charSequenceArray.length];
        for (int i = 0; i < charSequenceArray.length; ++i) {
            byArray[i] = Byte.parseByte(CharSequences.trimWhitespaces(charSequenceArray[i]).toString(), n);
        }
        return byArray;
    }

    public static CharSequence toASCII(CharSequence charSequence) {
        return StringBuilders.toASCII(charSequence, null);
    }

    public static String trimWhitespaces(String string) {
        if (string != null) {
            int n = string.length();
            int n2 = CharSequences.skipLeadingWhitespaces(string, 0, n);
            string = string.substring(n2, CharSequences.skipTrailingWhitespaces(string, n2, n));
        }
        return string;
    }

    public static CharSequence trimWhitespaces(CharSequence charSequence) {
        if (charSequence != null) {
            charSequence = CharSequences.trimWhitespaces(charSequence, 0, charSequence.length());
        }
        return charSequence;
    }

    public static CharSequence trimWhitespaces(CharSequence charSequence, int n, int n2) {
        int n3 = CharSequences.length(charSequence);
        ArgumentChecks.ensureValidIndexRange(n3, n, n2);
        if (charSequence != null) {
            n = CharSequences.skipLeadingWhitespaces(charSequence, n, n2);
            n2 = CharSequences.skipTrailingWhitespaces(charSequence, n, n2);
            if (n != 0 || n2 != n3) {
                charSequence = charSequence.subSequence(n, n2);
            }
        }
        return charSequence;
    }

    public static CharSequence trimFractionalPart(CharSequence charSequence) {
        if (charSequence != null) {
            int n;
            block4: for (int i = charSequence.length(); i > 0; i -= Character.charCount(n)) {
                n = Character.codePointBefore(charSequence, i);
                switch (n) {
                    case 48: {
                        continue block4;
                    }
                    case 46: {
                        return charSequence.subSequence(0, i);
                    }
                }
                return charSequence;
            }
        }
        return charSequence;
    }

    public static CharSequence shortSentence(CharSequence charSequence, int n) {
        int n2;
        int n3;
        ArgumentChecks.ensureStrictlyPositive("maxLength", n);
        if (charSequence != null && (n3 = (n2 = charSequence.length()) - n) > 0) {
            n3 += 5;
            int n4 = n2 >>> 1;
            if (n4 != 0 && Character.isLowSurrogate(charSequence.charAt(n4))) {
                --n4;
            }
            int n5 = n4;
            boolean bl = false;
            block5: do {
                int n6 = 0;
                int n7 = 0;
                boolean bl2 = bl = !bl;
                while (true) {
                    int n8;
                    if (bl) {
                        if ((n5 += n6) == n2) continue block5;
                        n8 = Character.codePointAt(charSequence, n5);
                    } else {
                        if ((n4 -= n6) == 0) continue block5;
                        n8 = Character.codePointBefore(charSequence, n4);
                    }
                    n6 = Character.charCount(n8);
                    if (Character.isWhitespace(n8)) {
                        if (n7 != 0) {
                            n7 = 12;
                        }
                    } else {
                        switch (n7) {
                            case 12: {
                                continue block5;
                            }
                            case 0: {
                                n7 = Character.isUnicodeIdentifierPart(n8) ? 1 : Character.getType(n8);
                                break;
                            }
                            case 1: {
                                if (Character.isUnicodeIdentifierPart(n8)) break;
                                continue block5;
                            }
                            default: {
                                if (Character.getType(n8) != n7) continue block5;
                            }
                        }
                    }
                    n3 -= n6;
                }
            } while (n3 > 0);
            charSequence = new StringBuilder(n4 + (n2 - n5) + 5).append(charSequence, 0, n4).append(" (\u2026) ").append(charSequence, n5, n2);
        }
        return charSequence;
    }

    public static CharSequence upperCaseToSentence(CharSequence charSequence) {
        int n;
        if (charSequence == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        int n2 = charSequence.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = Character.codePointAt(charSequence, i);
            if (i != 0) {
                n = n == 95 ? 32 : Character.toLowerCase(n);
            }
            stringBuilder.appendCodePoint(n);
        }
        return stringBuilder;
    }

    public static CharSequence camelCaseToSentence(CharSequence charSequence) {
        StringBuilder stringBuilder;
        if (charSequence == null) {
            return null;
        }
        if (CharSequences.isCode(charSequence)) {
            if (charSequence instanceof String) {
                return ((String)charSequence).replace('_', '-');
            }
            stringBuilder = new StringBuilder(charSequence);
            StringBuilders.replace(stringBuilder, '_', '-');
        } else {
            stringBuilder = (StringBuilder)CharSequences.camelCaseToWords(charSequence, true);
            int n = stringBuilder.length();
            if (n != 0) {
                StringBuilders.replace(stringBuilder, '_', ' ');
                int n2 = stringBuilder.codePointAt(0);
                int n3 = Character.toUpperCase(n2);
                if (n2 != n3) {
                    StringBuilders.replace(stringBuilder, 0, Character.charCount(n2), Character.toChars(n3));
                }
            }
        }
        return stringBuilder;
    }

    public static CharSequence camelCaseToWords(CharSequence charSequence, boolean bl) {
        int n;
        int n2;
        if (charSequence == null) {
            return null;
        }
        int n3 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n3 + 8);
        int n4 = n3 != 0 ? n3 - Character.charCount(Character.codePointBefore(charSequence, n3)) : 0;
        int n5 = 0;
        for (n = 1; n <= n3; n += Character.charCount(n2)) {
            int n6;
            int n7;
            boolean bl2;
            if (n == n3) {
                n2 = 0;
                bl2 = true;
            } else {
                n2 = Character.codePointAt(charSequence, n);
                boolean bl3 = bl2 = Character.isUpperCase(n2) && Character.isLowerCase(Character.codePointBefore(charSequence, n));
            }
            if (!bl2) continue;
            int n8 = stringBuilder.length();
            stringBuilder.append(charSequence, n5, n).append(' ');
            if (bl && n8 != 0 && n5 < n4 && Character.isLowerCase(CharSequences.codePointAfter(charSequence, n5)) && (n7 = stringBuilder.codePointAt(n8)) != (n6 = Character.toLowerCase(n7))) {
                StringBuilders.replace(stringBuilder, n8, n8 + Character.charCount(n7), Character.toChars(n6));
            }
            n5 = n;
        }
        n = stringBuilder.length();
        if (n != 0 && Character.isWhitespace(n2 = stringBuilder.codePointBefore(n))) {
            stringBuilder.setLength(n - Character.charCount(n2));
        }
        return stringBuilder;
    }

    public static CharSequence camelCaseToAcronym(CharSequence charSequence) {
        if ((charSequence = CharSequences.trimWhitespaces(charSequence)) != null && !CharSequences.isAcronym(charSequence)) {
            int n;
            int n2;
            int n3 = charSequence.length();
            StringBuilder stringBuilder = new StringBuilder(8);
            boolean bl = true;
            for (n = 0; n < n3; n += Character.charCount(n2)) {
                n2 = Character.codePointAt(charSequence, n);
                if (bl) {
                    if (!Character.isUnicodeIdentifierStart(n2)) continue;
                    stringBuilder.appendCodePoint(n2);
                    bl = false;
                    continue;
                }
                if (!Character.isUnicodeIdentifierPart(n2) || n2 == 95) {
                    bl = true;
                    continue;
                }
                if (!Character.isUpperCase(n2) || Character.isUpperCase(Character.codePointBefore(charSequence, n))) continue;
                stringBuilder.appendCodePoint(n2);
            }
            n = stringBuilder.length();
            if (n != 0) {
                int n4;
                if (CharSequences.isUpperCase(stringBuilder, 1, n, true) && (n2 = stringBuilder.codePointAt(0)) != (n4 = Character.toUpperCase(n2))) {
                    StringBuilders.replace(stringBuilder, 0, Character.charCount(n2), Character.toChars(n4));
                }
                if (!CharSequences.equals(charSequence, stringBuilder)) {
                    charSequence = stringBuilder;
                }
            }
        }
        return charSequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isAcronymForWords(CharSequence charSequence, CharSequence charSequence2) {
        boolean bl;
        int n;
        int n2;
        int n3;
        block17: {
            int n4;
            int n5 = CharSequences.length(charSequence);
            int n6 = 0;
            do {
                if (n6 >= n5) {
                    return false;
                }
                n4 = Character.codePointAt(charSequence, n6);
                n6 += Character.charCount(n4);
            } while (!Character.isLetterOrDigit(n4));
            n3 = CharSequences.length(charSequence2);
            n2 = 0;
            do {
                if (n2 >= n3) {
                    return false;
                }
                n = Character.codePointAt(charSequence2, n2);
                n2 += Character.charCount(n);
            } while (!Character.isLetterOrDigit(n));
            if (Character.toUpperCase(n4) != Character.toUpperCase(n)) {
                return false;
            }
            while (true) {
                block18: {
                    if (n6 >= n5) break block17;
                    if (n2 >= n3) {
                        return false;
                    }
                    n4 = Character.codePointAt(charSequence, n6);
                    n6 += Character.charCount(n4);
                    n = Character.codePointAt(charSequence2, n2);
                    n2 += Character.charCount(n);
                    if (Character.isLetterOrDigit(n4)) {
                        if (Character.toUpperCase(n4) == Character.toUpperCase(n)) {
                            continue;
                        }
                    } else {
                        while (n6 < n5) {
                            n4 = Character.codePointAt(charSequence, n6);
                            n6 += Character.charCount(n4);
                            if (!Character.isLetterOrDigit(n4)) continue;
                            break block18;
                        }
                        break block17;
                    }
                }
                bl = true;
                while (true) {
                    if (Character.isLetterOrDigit(n) == bl) {
                        if (n2 >= n3) {
                            return false;
                        }
                        n = Character.codePointAt(charSequence2, n2);
                        n2 += Character.charCount(n);
                        continue;
                    }
                    if (bl = !bl) break;
                }
                if (Character.toUpperCase(n4) != Character.toUpperCase(n)) break;
            }
            return false;
        }
        bl = true;
        while (true) {
            if (n2 >= n3) {
                return true;
            }
            n = Character.codePointAt(charSequence2, n2);
            n2 += Character.charCount(n);
            if (Character.isLetterOrDigit(n) == bl) continue;
            if (!bl) {
                return false;
            }
            boolean bl2 = bl = false;
            if (bl2) break;
        }
        return false;
    }

    private static boolean isCode(CharSequence charSequence) {
        int n = charSequence.length();
        while (--n >= 0) {
            char c = charSequence.charAt(n);
            if (c >= 'A' && c <= 'Z' || c >= '-' && c <= ':' || c == '_') continue;
            return false;
        }
        return true;
    }

    private static boolean isAcronym(CharSequence charSequence) {
        return CharSequences.isUpperCase(charSequence) && CharSequences.indexOf(charSequence, 95, 0, charSequence.length()) < 0 && CharSequences.isUnicodeIdentifier(charSequence);
    }

    public static boolean isUnicodeIdentifier(CharSequence charSequence) {
        int n = CharSequences.length(charSequence);
        if (n == 0) {
            return false;
        }
        int n2 = Character.codePointAt(charSequence, 0);
        if (!Character.isUnicodeIdentifierStart(n2)) {
            return false;
        }
        int n3 = 0;
        while ((n3 += Character.charCount(n2)) < n) {
            n2 = Character.codePointAt(charSequence, n3);
            if (Character.isUnicodeIdentifierPart(n2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(CharSequence charSequence) {
        return CharSequences.isUpperCase(charSequence, 0, CharSequences.length(charSequence), false);
    }

    private static boolean isUpperCase(CharSequence charSequence, int n, int n2, boolean bl) {
        while (n < n2) {
            int n3 = Character.codePointAt(charSequence, n);
            if (Character.isLowerCase(n3)) {
                return false;
            }
            if (!bl) {
                bl = Character.isUpperCase(n3);
            }
            n += Character.charCount(n3);
        }
        return bl;
    }

    public static boolean equalsFiltered(CharSequence charSequence, CharSequence charSequence2, Characters.Filter filter, boolean bl) {
        int n;
        int n2;
        if (charSequence == charSequence2) {
            return true;
        }
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        if (filter == null) {
            return bl ? CharSequences.equalsIgnoreCase(charSequence, charSequence2) : CharSequences.equals(charSequence, charSequence2);
        }
        int n3 = charSequence.length();
        int n4 = charSequence2.length();
        int n5 = 0;
        for (int i = 0; i < n3; i += n2) {
            int n6;
            n = Character.codePointAt(charSequence, i);
            n2 = Character.charCount(n);
            if (!filter.contains(n)) continue;
            do {
                if (n5 >= n4) {
                    return false;
                }
                n6 = Character.codePointAt(charSequence2, n5);
                n5 += Character.charCount(n6);
            } while (!filter.contains(n6));
            if (n == n6 || bl && CharSequences.equalsIgnoreCase(n, n6)) continue;
            return false;
        }
        while (n5 < n4) {
            n = Character.codePointAt(charSequence2, n5);
            if (filter.contains(n)) {
                return false;
            }
            n5 += Character.charCount(n);
        }
        return true;
    }

    private static boolean equalsIgnoreCase(int n, int n2) {
        if ((n = Character.toUpperCase(n)) == (n2 = Character.toUpperCase(n2))) {
            return true;
        }
        return Character.toLowerCase(n) == Character.toLowerCase(n2);
    }

    public static boolean equalsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        int n2;
        int n3;
        if (charSequence == charSequence2) {
            return true;
        }
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        int n4 = charSequence.length();
        int n5 = charSequence2.length();
        int n6 = 0;
        for (n = 0; n6 < n4 && n < n5; n6 += Character.charCount(n3), n += Character.charCount(n2)) {
            n3 = Character.codePointAt(charSequence, n6);
            if (n3 == (n2 = Character.codePointAt(charSequence2, n)) || CharSequences.equalsIgnoreCase(n3, n2)) continue;
            return false;
        }
        return n6 == n;
    }

    public static boolean equals(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == charSequence2) {
            return true;
        }
        if (charSequence != null && charSequence2 != null) {
            if (charSequence instanceof String) {
                return ((String)charSequence).contentEquals(charSequence2);
            }
            if (charSequence2 instanceof String) {
                return ((String)charSequence2).contentEquals(charSequence);
            }
            int n = charSequence.length();
            if (charSequence2.length() == n) {
                for (int i = 0; i < n; ++i) {
                    if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean regionMatches(CharSequence charSequence, int n, CharSequence charSequence2) {
        int n2;
        if (charSequence instanceof String && charSequence2 instanceof String) {
            return ((String)charSequence).startsWith((String)charSequence2, n);
        }
        if (n < 0 || n + (n2 = charSequence2.length()) > charSequence.length()) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (charSequence.charAt(n + i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence charSequence, int n, CharSequence charSequence2, boolean bl) {
        int n2;
        if (!bl) {
            return CharSequences.regionMatches(charSequence, n, charSequence2);
        }
        int n3 = charSequence.length();
        int n4 = charSequence2.length();
        if (n < 0) {
            return false;
        }
        for (int i = 0; i < n4; i += Character.charCount(n2)) {
            int n5;
            if (n >= n3) {
                return false;
            }
            n2 = Character.codePointAt(charSequence2, i);
            if (n2 != (n5 = Character.codePointAt(charSequence, n)) && !CharSequences.equalsIgnoreCase(n2, n5)) {
                return false;
            }
            n += Character.charCount(n5);
        }
        return true;
    }

    public static boolean startsWith(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        return CharSequences.regionMatches(charSequence, 0, charSequence2, bl);
    }

    public static boolean endsWith(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        int n;
        int n2 = charSequence.length();
        for (int i = charSequence2.length(); i > 0; i -= Character.charCount(n)) {
            if (n2 <= 0) {
                return false;
            }
            int n3 = Character.codePointBefore(charSequence, n2);
            if (!(n3 == (n = Character.codePointBefore(charSequence2, i)) || bl && CharSequences.equalsIgnoreCase(n3, n))) {
                return false;
            }
            n2 -= Character.charCount(n3);
        }
        return true;
    }

    public static CharSequence commonPrefix(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        int n2;
        CharSequence charSequence3;
        int n3;
        if (charSequence == null) {
            return charSequence2;
        }
        if (charSequence2 == null) {
            return charSequence;
        }
        int n4 = charSequence.length();
        if (n4 <= (n3 = charSequence2.length())) {
            charSequence3 = charSequence;
            n2 = n4;
        } else {
            charSequence3 = charSequence2;
            n2 = n3;
        }
        for (n = 0; n < n2 && charSequence.charAt(n) == charSequence2.charAt(n); ++n) {
        }
        return charSequence3.subSequence(0, n);
    }

    public static CharSequence commonSuffix(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        CharSequence charSequence3;
        int n2;
        if (charSequence == null) {
            return charSequence2;
        }
        if (charSequence2 == null) {
            return charSequence;
        }
        int n3 = charSequence.length();
        if (n3 <= (n2 = charSequence2.length())) {
            charSequence3 = charSequence;
            n = n3;
        } else {
            charSequence3 = charSequence2;
            n = n2;
        }
        int n4 = 0;
        while (++n4 <= n && charSequence.charAt(n3 - n4) == charSequence2.charAt(n2 - n4)) {
        }
        return charSequence3.subSequence(n - --n4, charSequence3.length());
    }

    public static CharSequence token(CharSequence charSequence, int n) {
        int n2;
        int n3 = charSequence.length();
        int n4 = n;
        do {
            if (n4 >= n3) {
                return "";
            }
            n2 = Character.codePointAt(charSequence, n4);
            n = n4;
            n4 += Character.charCount(n2);
        } while (Character.isWhitespace(n2));
        if (Character.isUnicodeIdentifierStart(n2)) {
            while (n4 < n3 && Character.isUnicodeIdentifierPart(n2 = Character.codePointAt(charSequence, n4))) {
                n4 += Character.charCount(n2);
            }
        } else {
            int n5 = Character.getType(Character.codePointAt(charSequence, n));
            while (n4 < n3 && Character.getType(n2 = Character.codePointAt(charSequence, n4)) == n5) {
                n4 += Character.charCount(n2);
            }
        }
        return charSequence.subSequence(n, n4);
    }

    public static CharSequence replace(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        ArgumentChecks.ensureNonEmpty("toSearch", charSequence2);
        ArgumentChecks.ensureNonNull("replaceBy", charSequence3);
        if (charSequence != null && !charSequence2.equals(charSequence3)) {
            if (charSequence instanceof String) {
                return ((String)charSequence).replace(charSequence2, charSequence3);
            }
            int n = charSequence.length();
            int n2 = CharSequences.indexOf(charSequence, charSequence2, 0, n);
            if (n2 >= 0) {
                int n3 = 0;
                int n4 = charSequence2.length();
                StringBuilder stringBuilder = new StringBuilder(n + (charSequence3.length() - n4));
                do {
                    stringBuilder.append(charSequence, n3, n2).append(charSequence3);
                } while ((n2 = CharSequences.indexOf(charSequence, charSequence2, n3 = n2 + n4, n)) >= 0);
                return stringBuilder.append(charSequence, n3, n);
            }
        }
        return charSequence;
    }

    public static void copyChars(CharSequence charSequence, int n, char[] cArray, int n2, int n3) {
        ArgumentChecks.ensurePositive("length", n3);
        if (charSequence instanceof String) {
            ((String)charSequence).getChars(n, n + n3, cArray, n2);
        } else if (charSequence instanceof StringBuilder) {
            ((StringBuilder)charSequence).getChars(n, n + n3, cArray, n2);
        } else if (charSequence instanceof StringBuffer) {
            ((StringBuffer)charSequence).getChars(n, n + n3, cArray, n2);
        } else if (charSequence instanceof CharBuffer) {
            ((CharBuffer)charSequence).subSequence(n, n + n3).get(cArray, n2, n3);
        } else {
            while (n3 != 0) {
                cArray[n2++] = charSequence.charAt(n++);
                --n3;
            }
        }
    }
}

