/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.Serializable;
import java.util.Iterator;
import juzu.impl.common.Lexers;
import juzu.impl.common.Path;
import juzu.impl.common.Tools;

public class Name
implements Iterable<String>,
Serializable,
CharSequence {
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Name EMPTY = new Name("", EMPTY_STRING_ARRAY);
    final String[] identifiers;
    final int size;
    private String value;
    private Name parent;

    public static Name create(Class<?> type) throws NullPointerException {
        return Name.parse(type.getName());
    }

    public static Name parse(CharSequence s) throws IllegalArgumentException {
        int len = s.length();
        return Name.parse(s, 0, len);
    }

    public static Name parse(CharSequence s, int from, int end) throws IllegalArgumentException {
        if (end > s.length()) {
            throw new IllegalArgumentException("End bound " + end + " cannot be greater than the sequence length " + s.length());
        }
        String[] segments = Lexers.parseName(s, from, end);
        if (segments.length == 0) {
            return EMPTY;
        }
        return new Name(s.subSequence(from, end).toString(), segments);
    }

    private Name(String value, String[] identifiers) {
        this(value, identifiers, identifiers.length);
    }

    private Name(String value, String[] identifiers, int size) {
        this.value = value;
        this.identifiers = identifiers;
        this.size = size;
        this.parent = null;
    }

    Name(String[] identifiers) {
        this(identifiers, identifiers.length);
    }

    Name(String[] identifiers, int size) {
        this.value = Tools.join('.', identifiers, 0, size);
        this.identifiers = identifiers;
        this.size = size;
        this.parent = null;
    }

    public Name getParent() {
        if (this.parent == null) {
            if (this.size == 1) {
                this.parent = EMPTY;
            } else if (this.size() > 1) {
                this.parent = new Name(this.value.substring(0, this.value.length() - 1 - this.identifiers[this.size - 1].length()), this.identifiers, this.size - 1);
            }
        }
        return this.parent;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isSimple() {
        return this.size == 1;
    }

    public boolean isQualified() {
        return this.size > 1;
    }

    public String getIdentifier() {
        return this.size > 0 ? this.identifiers[this.size - 1] : null;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    public int size() {
        return this.size;
    }

    public String get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " cannot be negative");
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " cannot be greater than size");
        }
        return this.identifiers[index];
    }

    @Override
    public Iterator<String> iterator() {
        return Tools.iterator(0, this.size, this.identifiers);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Name) {
            Name that = (Name)obj;
            if (this.size == that.size) {
                for (int i = this.size - 1; i >= 0; --i) {
                    if (this.identifiers[i].equals(that.identifiers[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public Path.Absolute resolve(String path) {
        String[] atoms = Lexers.parsePath(1, this.identifiers, this.size, path, 0);
        return new Path.Absolute(new Name(atoms, atoms.length - 1), atoms[atoms.length - 1]);
    }

    public Path.Absolute resolve(Path path) {
        if (path instanceof Path.Absolute) {
            return (Path.Absolute)path;
        }
        return Path.absolute(this.append(path.getName()), path.getExt());
    }

    public Name append(Name suffix) throws NullPointerException {
        if (suffix == null) {
            throw new NullPointerException("No null suffix allowed");
        }
        return this.append(suffix.identifiers, suffix.size);
    }

    public Name append(String ... identifiers) throws NullPointerException, IllegalArgumentException {
        if (identifiers == null) {
            throw new NullPointerException("No null suffix allowed");
        }
        return this.append(identifiers, identifiers.length);
    }

    public Name subName(int l) throws IllegalArgumentException {
        if (l < 0) {
            throw new IllegalArgumentException("No negative argument " + l + " accepted");
        }
        if (l == 0) {
            return this;
        }
        int remaining = this.size - l;
        if (remaining < 0) {
            throw new IllegalArgumentException("Argument " + l + " can't be greater than size " + this.size);
        }
        if (remaining == 0) {
            return EMPTY;
        }
        String[] identifiers = new String[remaining];
        System.arraycopy(this.identifiers, l, identifiers, 0, remaining);
        return new Name(identifiers);
    }

    private Name append(String[] suffixIdentifiers, int suffixSize) throws NullPointerException, IllegalArgumentException {
        if (this.size == 0) {
            return this;
        }
        String[] tmp = new String[this.size + suffixSize];
        System.arraycopy(this.identifiers, 0, tmp, 0, this.size);
        System.arraycopy(suffixIdentifiers, 0, tmp, this.size, suffixSize);
        int len = this.value.length();
        for (int i = 0; i < suffixSize; ++i) {
            if (suffixIdentifiers[i] == null) {
                throw new IllegalArgumentException("Cannot accept null suffix segment");
            }
            if (suffixIdentifiers[i].isEmpty()) {
                throw new IllegalArgumentException("Cannot accept empty suffix segment");
            }
            if (suffixIdentifiers[i].indexOf(46) != -1) {
                throw new IllegalArgumentException("Cannot accept '.' in suffix segment");
            }
            len += 1 + suffixIdentifiers[i].length();
        }
        StringBuilder sb = new StringBuilder(len).append(this.value);
        for (int i = 0; i < suffixSize; ++i) {
            sb.append('.').append(suffixIdentifiers[i]);
        }
        return new Name(sb.toString(), tmp, tmp.length);
    }

    public Name getPrefix(Name name) {
        int size = Math.min(this.size, name.size);
        int a = 0;
        int len = 0;
        for (int i = 0; i < size && this.identifiers[i].equals(name.identifiers[i]); ++i) {
            ++a;
            if (i > 0) {
                ++len;
            }
            len += this.identifiers[i].length();
        }
        return a == this.size ? this : new Name(this.value.substring(0, len), this.identifiers, a);
    }

    public boolean isPrefix(Name name) {
        if (name.parent == this) {
            return true;
        }
        if (this.size <= name.size) {
            for (int i = 0; i < this.size; ++i) {
                if (this.identifiers[i].equals(name.identifiers[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

