/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.internal.metadata.AxisNames;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;

public abstract class Transliterator
implements Serializable {
    private static final long serialVersionUID = 7115456393795045932L;
    static final int SPACES = -268419584;
    private static final Map<AxisDirection, String> CARTESIAN;
    public static final Transliterator DEFAULT;
    public static final Transliterator IDENTITY;

    protected Transliterator() {
    }

    public String filter(String string) {
        CharSequence charSequence = CharSequences.toASCII((CharSequence)string);
        StringBuilder stringBuilder = null;
        int n = charSequence.length();
        while (--n >= 0) {
            char c = charSequence.charAt(n);
            if (c >= ' ') continue;
            if (stringBuilder == null) {
                if (charSequence == string) {
                    stringBuilder = new StringBuilder(string);
                    charSequence = stringBuilder;
                } else {
                    stringBuilder = (StringBuilder)charSequence;
                }
            }
            if ((0xF0003E00 & '\u0001' << c) != 0) {
                stringBuilder.setCharAt(n, ' ');
                if (n == 0 || c != '\n' || charSequence.charAt(n - 1) != '\r') continue;
                stringBuilder.deleteCharAt(--n);
                continue;
            }
            stringBuilder.deleteCharAt(n);
        }
        return charSequence.toString();
    }

    public String toShortAxisName(CoordinateSystem coordinateSystem, AxisDirection axisDirection, String string) {
        if (string.equalsIgnoreCase("Geodetic latitude")) {
            return "Latitude";
        }
        if (string.equalsIgnoreCase("Geodetic longitude")) {
            return "Longitude";
        }
        if (AxisDirections.isGeocentric(axisDirection) && CharSequences.equalsFiltered((CharSequence)string, (CharSequence)axisDirection.name(), (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)true)) {
            return null;
        }
        return string;
    }

    public String toLongAxisName(String string, AxisDirection axisDirection, String string2) {
        if (string != null) {
            switch (string) {
                case "ellipsoidal": {
                    if (Transliterator.isLatLong("Latitude", string2)) {
                        return "Geodetic latitude";
                    }
                    if (!Transliterator.isLatLong("Longitude", string2)) break;
                    return "Geodetic longitude";
                }
                case "spherical": {
                    if (Transliterator.isLatLong("Latitude", string2)) {
                        return "Spherical latitude";
                    }
                    if (!Transliterator.isLatLong("Longitude", string2)) break;
                    return "Spherical longitude";
                }
                case "Cartesian": {
                    String string3;
                    if (string2.length() > 1 || (string3 = CARTESIAN.get(axisDirection)) == null) break;
                    return string3;
                }
            }
        }
        return AxisNames.toCamelCase((String)string2);
    }

    private static boolean isLatLong(String string, String string2) {
        int n = string2.length();
        return n >= 3 && n <= string2.length() && CharSequences.startsWith((CharSequence)string, (CharSequence)string2, (boolean)true);
    }

    public String toLatinAbbreviation(CoordinateSystem coordinateSystem, AxisDirection axisDirection, String string) {
        if (string != null && !string.isEmpty()) {
            if (string.length() <= 2) {
                switch (string.charAt(0)) {
                    case '\u03b8': {
                        if (coordinateSystem instanceof SphericalCS) {
                            string = "V";
                            break;
                        }
                        if (!(coordinateSystem instanceof PolarCS)) break;
                        string = "U";
                        break;
                    }
                    case '\u03c6': {
                        if (coordinateSystem instanceof SphericalCS) {
                            string = "U";
                            break;
                        }
                        if (!(coordinateSystem instanceof EllipsoidalCS)) break;
                        string = "B";
                        break;
                    }
                    case '\u03a9': {
                        if (!(coordinateSystem instanceof SphericalCS)) break;
                        string = "U";
                        break;
                    }
                    case '\u03bb': {
                        if (!(coordinateSystem instanceof EllipsoidalCS)) break;
                        string = "L";
                    }
                }
            } else if (string.equalsIgnoreCase("Lat")) {
                string = "B";
            } else if (string.regionMatches(true, 0, "Long", 0, Math.min(3, Math.max(4, string.length())))) {
                string = "L";
            }
        }
        return string;
    }

    public String toUnicodeAbbreviation(String string, AxisDirection axisDirection, String string2) {
        if (string2.length() == 1) {
            String string3;
            String string4;
            switch (string2.charAt(0)) {
                case 'U': {
                    if ("polar".equals(string)) {
                        return "\u03b8";
                    }
                    string4 = "\u03a9";
                    string3 = "spherical";
                    break;
                }
                case 'V': {
                    string4 = "\u03b8";
                    string3 = "spherical";
                    break;
                }
                case 'L': {
                    string4 = "\u03bb";
                    string3 = "ellipsoidal";
                    break;
                }
                case 'B': 
                case 'P': {
                    string4 = "\u03c6";
                    string3 = "ellipsoidal";
                    break;
                }
                default: {
                    return string2;
                }
            }
            if (string3.equals(string)) {
                return string4;
            }
        } else {
            if (Transliterator.isLatLong("Latitude", string2)) {
                return "\u03c6";
            }
            if (Transliterator.isLatLong("Longitude", string2)) {
                return "\u03bb";
            }
        }
        return string2;
    }

    static {
        HashMap<AxisDirection, String> hashMap = new HashMap<AxisDirection, String>(12);
        hashMap.put(AxisDirection.EAST, "Easting");
        hashMap.put(AxisDirection.WEST, "Westing");
        hashMap.put(AxisDirection.NORTH, "Northing");
        hashMap.put(AxisDirection.SOUTH, "Southing");
        hashMap.put(AxisDirection.GEOCENTRIC_X, "Geocentric X");
        hashMap.put(AxisDirection.GEOCENTRIC_Y, "Geocentric Y");
        hashMap.put(AxisDirection.GEOCENTRIC_Z, "Geocentric Z");
        CARTESIAN = hashMap;
        DEFAULT = new Default();
        IDENTITY = new Unicode();
    }

    private static final class Unicode
    extends Transliterator {
        private static final long serialVersionUID = 7392131912748253956L;

        private Unicode() {
        }

        @Override
        public String filter(String string) {
            return string;
        }

        @Override
        public String toShortAxisName(CoordinateSystem coordinateSystem, AxisDirection axisDirection, String string) {
            return string;
        }

        @Override
        public String toLongAxisName(String string, AxisDirection axisDirection, String string2) {
            return string2;
        }

        @Override
        public String toLatinAbbreviation(CoordinateSystem coordinateSystem, AxisDirection axisDirection, String string) {
            return string;
        }

        @Override
        public String toUnicodeAbbreviation(String string, AxisDirection axisDirection, String string2) {
            return string2;
        }

        public String toString() {
            return "IDENTITY";
        }

        Object readResolve() throws ObjectStreamException {
            return IDENTITY;
        }
    }

    private static final class Default
    extends Transliterator {
        private static final long serialVersionUID = 4869597020294928525L;

        private Default() {
        }

        public String toString() {
            return "DEFAULT";
        }

        Object readResolve() throws ObjectStreamException {
            return DEFAULT;
        }
    }
}

