/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.dao;

import java.util.Collection;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.gamification.github.entity.GitHubAccountEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GitHubAccountDAO
extends GenericDAOJPAImpl<GitHubAccountEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(GitHubAccountDAO.class);

    public GitHubAccountEntity getAccountByGithubId(String gitHubId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GitHubAccountEntity.getAccountByGithubId", GitHubAccountEntity.class).setParameter("gitHubId", (Object)gitHubId);
        try {
            return (GitHubAccountEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (NonUniqueResultException e) {
            List list = query.getResultList();
            GitHubAccountEntity gitHubAccountEntity = CollectionUtils.isEmpty((Collection)list) ? null : (GitHubAccountEntity)list.get(0);
            LOG.warn("Not only one single user found for github account {}. Try to retrieve only first one for user {}", new Object[]{gitHubId, gitHubAccountEntity == null ? null : gitHubAccountEntity.getUserName(), e});
            return gitHubAccountEntity;
        }
    }

    public GitHubAccountEntity getAccountByUserName(String userName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GitHubAccountEntity.getAccountByUserName", GitHubAccountEntity.class).setParameter("userName", (Object)userName);
        try {
            return (GitHubAccountEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (NonUniqueResultException e) {
            List list = query.getResultList();
            GitHubAccountEntity gitHubAccountEntity = CollectionUtils.isEmpty((Collection)list) ? null : (GitHubAccountEntity)list.get(0);
            LOG.warn("Not only one single github account found for user {}. Try to retrieve only first one for github account {}", new Object[]{userName, gitHubAccountEntity == null ? null : gitHubAccountEntity.getGitHubId(), e});
            return gitHubAccountEntity;
        }
    }
}

