/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class ConvertedGridCoverage
extends GridCoverage {
    private final GridCoverage packed;
    private final MathTransform1D[] toConverted;
    private final MathTransform1D[] toPacked;
    private final boolean isIdentity;

    public static GridCoverage create(GridCoverage gridCoverage) {
        List<SampleDimension> list = gridCoverage.getSampleDimensions();
        ArrayList<SampleDimension> arrayList = new ArrayList<SampleDimension>(list.size());
        for (SampleDimension sampleDimension : list) {
            arrayList.add(sampleDimension.forConvertedValues(true));
        }
        return arrayList.equals(list) ? gridCoverage : new ConvertedGridCoverage(gridCoverage, list, arrayList);
    }

    private ConvertedGridCoverage(GridCoverage gridCoverage, List<SampleDimension> list, List<SampleDimension> list2) {
        super(gridCoverage.getGridGeometry(), list2);
        int n = list.size();
        this.toConverted = new MathTransform1D[n];
        this.toPacked = new MathTransform1D[n];
        boolean bl = true;
        MathTransform1D mathTransform1D = (MathTransform1D)MathTransforms.identity((int)1);
        for (int i = 0; i < n; ++i) {
            MathTransform1D mathTransform1D2;
            this.toConverted[i] = mathTransform1D2 = list.get(i).getTransferFunction().orElse(mathTransform1D);
            bl &= mathTransform1D2.isIdentity();
            try {
                mathTransform1D2 = mathTransform1D2.inverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                mathTransform1D2 = (MathTransform1D)MathTransforms.linear((double)Double.NaN, (double)0.0);
            }
            this.toPacked[i] = mathTransform1D2;
        }
        this.isIdentity = bl;
        this.packed = gridCoverage;
    }

    @Override
    public RenderedImage render(GridExtent gridExtent) {
        RenderedImage renderedImage = this.packed.render(gridExtent);
        if (this.isIdentity) {
            return renderedImage;
        }
        Raster raster = renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1 ? renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY()) : renderedImage.getData();
        SampleModel sampleModel = raster.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        SampleConverter sampleConverter = new SampleConverter(sampleModel, this.toConverted, this.toPacked);
        WritableRaster writableRaster = WritableRaster.createWritableRaster(sampleConverter, dataBuffer, null);
        ScaledColorModel scaledColorModel = new ScaledColorModel(this.getSampleDimensions().get(0).getSampleRange().get());
        return new BufferedImage(scaledColorModel, writableRaster, false, null);
    }

    @Override
    public GridCoverage forConvertedValues(boolean bl) {
        return bl ? this : this.packed;
    }

    private static final class ScaledColorModel
    extends ColorModel {
        private final float scale;
        private final float offset;

        ScaledColorModel(NumberRange<?> numberRange) {
            super(32);
            double d = 255.0 / (numberRange.getMaxDouble() - numberRange.getMinDouble());
            this.scale = (float)d;
            this.offset = (float)(numberRange.getMinDouble() / d);
        }

        @Override
        public boolean isCompatibleRaster(Raster raster) {
            return this.isCompatibleSampleModel(raster.getSampleModel());
        }

        @Override
        public boolean isCompatibleSampleModel(SampleModel sampleModel) {
            return sampleModel instanceof SampleConverter;
        }

        @Override
        public int getRGB(Object object) {
            float f = object instanceof float[] ? ((float[])object)[0] : (object instanceof int[] ? (float)((int[])object)[0] : (object instanceof double[] ? (float)((double[])object)[0] : (object instanceof byte[] ? (float)((byte[])object)[0] : (object instanceof short[] ? (float)((short[])object)[0] : (object instanceof long[] ? (float)((long[])object)[0] : (object instanceof Number[] ? ((Number[])object)[0].floatValue() : (object instanceof Byte[] ? (float)((Byte[])object)[0].byteValue() : 0.0f)))))));
            int n = (int)((f - this.offset) * this.scale);
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            return 0xFF000000 | n << 16 | n << 8 | n;
        }

        @Override
        public int getRed(int n) {
            int n2 = this.getRGB((Object)n);
            return 0xFF & n2 >>> 16;
        }

        @Override
        public int getGreen(int n) {
            int n2 = this.getRGB((Object)n);
            return 0xFF & n2 >>> 8;
        }

        @Override
        public int getBlue(int n) {
            int n2 = this.getRGB((Object)n);
            return 0xFF & n2;
        }

        @Override
        public int getAlpha(int n) {
            int n2 = this.getRGB((Object)n);
            return 0xFF & n2 >>> 24;
        }

        @Override
        public int getRed(Object object) {
            int n = this.getRGB(object);
            return 0xFF & n >>> 16;
        }

        @Override
        public int getGreen(Object object) {
            int n = this.getRGB(object);
            return 0xFF & n >>> 8;
        }

        @Override
        public int getBlue(Object object) {
            int n = this.getRGB(object);
            return 0xFF & n;
        }

        @Override
        public int getAlpha(Object object) {
            int n = this.getRGB(object);
            return 0xFF & n >>> 24;
        }
    }

    private static final class SampleConverter
    extends SampleModel {
        private final SampleModel base;
        private final int baseDataType;
        private final MathTransform1D[] toConverted;
        private final MathTransform1D[] toPacked;

        SampleConverter(SampleModel sampleModel, MathTransform1D[] mathTransform1DArray, MathTransform1D[] mathTransform1DArray2) {
            super(4, sampleModel.getWidth(), sampleModel.getHeight(), sampleModel.getNumBands());
            this.base = sampleModel;
            this.baseDataType = sampleModel.getDataType();
            this.toConverted = mathTransform1DArray;
            this.toPacked = mathTransform1DArray2;
        }

        @Override
        public int getNumDataElements() {
            return this.base.getNumDataElements();
        }

        @Override
        public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
            float[] fArray;
            Object object2 = this.base.getDataElements(n, n2, null, dataBuffer);
            if (object == null) {
                fArray = new float[this.numBands];
            } else {
                if (!(object instanceof float[])) {
                    throw new ClassCastException("Unsupported array type, expecting a float array.");
                }
                fArray = (float[])object;
            }
            switch (this.baseDataType) {
                case 0: {
                    int n3;
                    Object[] objectArray = (byte[])object2;
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        fArray[n3] = objectArray[n3];
                    }
                    break;
                }
                case 2: {
                    int n3;
                    Object[] objectArray = (short[])object2;
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        fArray[n3] = objectArray[n3];
                    }
                    break;
                }
                case 1: {
                    int n3;
                    Object[] objectArray = (short[])object2;
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        fArray[n3] = Short.toUnsignedInt(objectArray[n3]);
                    }
                    break;
                }
                case 3: {
                    int n3;
                    Object[] objectArray = (int[])object2;
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        fArray[n3] = objectArray[n3];
                    }
                    break;
                }
                case 4: {
                    Object[] objectArray = (float[])object2;
                    System.arraycopy(objectArray, 0, fArray, 0, objectArray.length);
                    break;
                }
                case 5: {
                    int n3;
                    Object[] objectArray = (double[])object2;
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        fArray[n3] = objectArray[n3];
                    }
                    break;
                }
                default: {
                    throw new ClassCastException("Unsupported base array type.");
                }
            }
            try {
                for (int i = 0; i < this.toConverted.length; ++i) {
                    fArray[i] = (float)this.toConverted[i].transform((double)fArray[i]);
                }
            }
            catch (TransformException transformException) {
                Arrays.fill(fArray, Float.NaN);
            }
            return fArray;
        }

        @Override
        public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
            Objects.requireNonNull(object);
            if (!(object instanceof float[])) {
                throw new ClassCastException("Unsupported array type, expecting a float array.");
            }
            float[] fArray = (float[])object;
            try {
                for (int i = 0; i < this.toConverted.length; ++i) {
                    fArray[i] = (float)this.toPacked[i].transform((double)fArray[i]);
                }
            }
            catch (TransformException transformException) {
                Arrays.fill(fArray, Float.NaN);
            }
            switch (this.baseDataType) {
                case 0: {
                    byte[] byArray = new byte[fArray.length];
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = (byte)fArray[i];
                    }
                    this.base.setDataElements(n, n2, byArray, dataBuffer);
                    break;
                }
                case 2: {
                    short[] sArray = new short[fArray.length];
                    for (int i = 0; i < sArray.length; ++i) {
                        sArray[i] = (short)fArray[i];
                    }
                    this.base.setDataElements(n, n2, sArray, dataBuffer);
                    break;
                }
                case 1: {
                    short[] sArray = new short[fArray.length];
                    for (int i = 0; i < sArray.length; ++i) {
                        sArray[i] = (short)fArray[i];
                    }
                    this.base.setDataElements(n, n2, sArray, dataBuffer);
                    break;
                }
                case 3: {
                    int[] nArray = new int[fArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = (int)fArray[i];
                    }
                    this.base.setDataElements(n, n2, nArray, dataBuffer);
                    break;
                }
                case 4: {
                    this.base.setDataElements(n, n2, fArray, dataBuffer);
                    break;
                }
                case 5: {
                    double[] dArray = new double[fArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        dArray[i] = fArray[i];
                    }
                    this.base.setDataElements(n, n2, dArray, dataBuffer);
                    break;
                }
                default: {
                    throw new ClassCastException("Unsupported base array type.");
                }
            }
        }

        @Override
        public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
            return (int)this.getSampleDouble(n, n2, n3, dataBuffer);
        }

        @Override
        public float getSampleFloat(int n, int n2, int n3, DataBuffer dataBuffer) {
            try {
                return (float)this.toConverted[n3].transform((double)this.base.getSampleFloat(n, n2, n3, dataBuffer));
            }
            catch (TransformException transformException) {
                return Float.NaN;
            }
        }

        @Override
        public double getSampleDouble(int n, int n2, int n3, DataBuffer dataBuffer) {
            try {
                return this.toConverted[n3].transform(this.base.getSampleDouble(n, n2, n3, dataBuffer));
            }
            catch (TransformException transformException) {
                return Double.NaN;
            }
        }

        @Override
        public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
            this.setSample(n, n2, n3, (double)n4, dataBuffer);
        }

        @Override
        public void setSample(int n, int n2, int n3, double d, DataBuffer dataBuffer) {
            try {
                d = this.toPacked[n3].transform(d);
            }
            catch (TransformException transformException) {
                d = Double.NaN;
            }
            this.base.setSample(n, n2, n3, d, dataBuffer);
        }

        @Override
        public void setSample(int n, int n2, int n3, float f, DataBuffer dataBuffer) {
            this.setSample(n, n2, n3, (double)f, dataBuffer);
        }

        @Override
        public SampleModel createCompatibleSampleModel(int n, int n2) {
            SampleModel sampleModel = this.base.createCompatibleSampleModel(n, n2);
            return new SampleConverter(sampleModel, this.toConverted, this.toPacked);
        }

        @Override
        public SampleModel createSubsetSampleModel(int[] nArray) {
            SampleModel sampleModel = this.base.createSubsetSampleModel(nArray);
            MathTransform1D[] mathTransform1DArray = new MathTransform1D[nArray.length];
            MathTransform1D[] mathTransform1DArray2 = new MathTransform1D[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                mathTransform1DArray[i] = this.toConverted[nArray[i]];
                mathTransform1DArray2[i] = this.toPacked[nArray[i]];
            }
            return new SampleConverter(sampleModel, mathTransform1DArray, mathTransform1DArray2);
        }

        @Override
        public DataBuffer createDataBuffer() {
            return this.base.createDataBuffer();
        }

        @Override
        public int[] getSampleSize() {
            int[] nArray = new int[this.numBands];
            Arrays.fill(nArray, 32);
            return nArray;
        }

        @Override
        public int getSampleSize(int n) {
            return 32;
        }
    }
}

