/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.api.functional;

import org.infinispan.commons.util.Experimental;

@Experimental
public interface Param<P> {
    public int id();

    public P get();

    @Experimental
    public static enum PersistenceMode implements Param<PersistenceMode>
    {
        PERSIST,
        SKIP;

        public static final int ID = 1;
        private static final PersistenceMode[] CACHED_VALUES;

        @Override
        public int id() {
            return 1;
        }

        @Override
        public PersistenceMode get() {
            return this;
        }

        public static PersistenceMode defaultValue() {
            return PERSIST;
        }

        public static PersistenceMode valueOf(int ordinal) {
            return CACHED_VALUES[ordinal];
        }

        static {
            CACHED_VALUES = PersistenceMode.values();
        }
    }

    @Experimental
    public static enum FutureMode implements Param<FutureMode>
    {
        ASYNC,
        COMPLETED;

        public static final int ID = 0;

        @Override
        public int id() {
            return 0;
        }

        @Override
        public FutureMode get() {
            return this;
        }

        public static FutureMode defaultValue() {
            return ASYNC;
        }
    }
}

