/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.distance.LatLonPointRadius;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.index.tree.NodeType;
import org.apache.sis.index.tree.QuadTreeData;
import org.apache.sis.index.tree.QuadTreeNode;
import org.apache.sis.index.tree.Quadrant;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.GeodeticCalculator;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class QuadTree {
    private static final double EARTH_MIN_X = 0.0;
    private static final double EARTH_MIN_Y = 0.0;
    private static final double EARTH_MAX_X = 360.0;
    private static final double EARTH_MAX_Y = 180.0;
    private static final double EARTH_MID_X = 180.0;
    private static final double EARTH_MID_Y = 90.0;
    private static final double[] xf = new double[]{-0.25, 0.25, -0.25, 0.25};
    private static final double[] yf = new double[]{0.25, 0.25, -0.25, -0.25};
    private final QuadTreeNode root;
    private int size;
    private int nodeSize;
    private int maxDepth;
    private int capacity;
    private final GeodeticCalculator calculator;

    public QuadTree(int n, int n2) {
        this();
        this.capacity = n;
        this.maxDepth = n2;
    }

    public QuadTree() {
        this.root = new QuadTreeNode(NodeType.GRAY, this.nodeSize);
        this.calculator = GeodeticCalculator.create((CoordinateReferenceSystem)CommonCRS.SPHERE.geographic());
    }

    public boolean insert(QuadTreeData quadTreeData) {
        if (this.insert(quadTreeData, this.root)) {
            ++this.size;
            return true;
        }
        return false;
    }

    private Quadrant compare(QuadTreeData quadTreeData, double d, double d2) {
        if (quadTreeData.getX() < d) {
            if (quadTreeData.getY() < d2) {
                return Quadrant.SW;
            }
            return Quadrant.NW;
        }
        if (quadTreeData.getY() < d2) {
            return Quadrant.SE;
        }
        return Quadrant.NE;
    }

    private boolean insert(QuadTreeData quadTreeData, QuadTreeNode quadTreeNode) {
        int n = 0;
        QuadTreeNode quadTreeNode2 = quadTreeNode;
        double d = 180.0;
        double d2 = 90.0;
        double d3 = 360.0;
        double d4 = 180.0;
        QuadTreeNode quadTreeNode3 = quadTreeNode2;
        Quadrant quadrant = this.compare(quadTreeData, d, d2);
        ++n;
        while (quadTreeNode3.getChild(quadrant) != null && quadTreeNode3.getChild(quadrant).getNodeType() == NodeType.GRAY) {
            quadTreeNode3 = quadTreeNode3.getChild(quadrant);
            quadrant = this.compare(quadTreeData, d += xf[quadrant.index()] * (d3 /= 2.0), d2 += yf[quadrant.index()] * (d4 /= 2.0));
            if (++n <= this.maxDepth) continue;
            return false;
        }
        if (quadTreeNode3.getChild(quadrant) == null) {
            QuadTreeNode quadTreeNode4 = new QuadTreeNode(++this.nodeSize, this.capacity);
            quadTreeNode4.addData(quadTreeData);
            quadTreeNode3.setChild(quadTreeNode4, quadrant);
        } else {
            QuadTreeNode quadTreeNode5 = quadTreeNode3.getChild(quadrant);
            if (quadTreeNode5.getCount() < this.capacity) {
                quadTreeNode5.addData(quadTreeData);
                return true;
            }
            QuadTreeData[] quadTreeDataArray = quadTreeNode5.getData();
            if (!this.maxDepthExceeded(quadTreeDataArray, quadTreeData, d, d2, d3, d4, quadrant, n)) {
                quadTreeNode3.setChild(new QuadTreeNode(NodeType.GRAY, quadTreeNode5.getId()), quadrant);
                quadTreeNode3 = quadTreeNode3.getChild(quadrant);
                d += xf[quadrant.index()] * d3;
                d3 /= 2.0;
                d2 += yf[quadrant.index()] * d4;
                d4 /= 2.0;
                quadrant = this.compare(quadTreeData, d, d2);
                if (++n > this.maxDepth) {
                    return false;
                }
                while (this.isSimilarQuad(quadTreeDataArray, quadTreeData, d, d2, quadrant)) {
                    quadTreeNode3.setChild(new QuadTreeNode(NodeType.GRAY, ++this.nodeSize), quadrant);
                    quadTreeNode3 = quadTreeNode3.getChild(quadrant);
                    quadrant = this.compare(quadTreeData, d += xf[quadrant.index()] * (d3 /= 2.0), d2 += yf[quadrant.index()] * (d4 /= 2.0));
                    if (++n <= this.maxDepth) continue;
                    return false;
                }
                if (quadTreeNode3.getChild(quadrant) == null) {
                    QuadTreeNode quadTreeNode6 = new QuadTreeNode(++this.nodeSize, this.capacity);
                    quadTreeNode6.addData(quadTreeData);
                    quadTreeNode3.setChild(quadTreeNode6, quadrant);
                } else {
                    quadTreeNode3.getChild(quadrant).addData(quadTreeData);
                }
                for (int i = 0; i < quadTreeDataArray.length; ++i) {
                    Quadrant quadrant2 = this.compare(quadTreeDataArray[i], d, d2);
                    if (quadTreeNode3.getChild(quadrant2) == null) {
                        QuadTreeNode quadTreeNode7 = new QuadTreeNode(++this.nodeSize, this.capacity);
                        quadTreeNode7.addData(quadTreeDataArray[i]);
                        quadTreeNode3.setChild(quadTreeNode7, quadrant2);
                        continue;
                    }
                    quadTreeNode3.getChild(quadrant2).addData(quadTreeDataArray[i]);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean maxDepthExceeded(QuadTreeData[] quadTreeDataArray, QuadTreeData quadTreeData, double d, double d2, double d3, double d4, Quadrant quadrant, int n) {
        int n2 = n;
        double d5 = d;
        double d6 = d3;
        double d7 = d2;
        double d8 = d4;
        Quadrant quadrant2 = quadrant;
        d5 += xf[quadrant2.index()] * d6;
        d6 /= 2.0;
        d7 += yf[quadrant2.index()] * d8;
        d8 /= 2.0;
        quadrant2 = this.compare(quadTreeData, d5, d7);
        if (++n2 > this.maxDepth) {
            return true;
        }
        while (this.isSimilarQuad(quadTreeDataArray, quadTreeData, d5, d7, quadrant2)) {
            quadrant2 = this.compare(quadTreeData, d5 += xf[quadrant2.index()] * (d6 /= 2.0), d7 += yf[quadrant2.index()] * (d8 /= 2.0));
            if (++n2 <= this.maxDepth) continue;
            return true;
        }
        return false;
    }

    private boolean isSimilarQuad(QuadTreeData[] quadTreeDataArray, QuadTreeData quadTreeData, double d, double d2, Quadrant quadrant) {
        Quadrant quadrant2 = this.compare(quadTreeDataArray[0], d, d2);
        if (quadrant != quadrant2) {
            return false;
        }
        for (int i = 1; i < quadTreeDataArray.length; ++i) {
            if (this.compare(quadTreeDataArray[i], d, d2) == quadrant2) continue;
            return false;
        }
        return true;
    }

    public List<QuadTreeData> queryByPointRadius(DirectPosition2D directPosition2D, double d) {
        LatLonPointRadius latLonPointRadius = new LatLonPointRadius((DirectPosition)directPosition2D, d);
        return this.queryByPointRadius(directPosition2D, d, this.root, new Rectangle2D.Double(0.0, 0.0, 360.0, 180.0), latLonPointRadius.getRectangularRegionApproximation(360));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QuadTreeData> queryByPointRadius(DirectPosition2D directPosition2D, double d, QuadTreeNode quadTreeNode, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        List<QuadTreeData> list;
        ArrayList<QuadTreeData> arrayList = new ArrayList<QuadTreeData>();
        if (quadTreeNode == null) {
            return arrayList;
        }
        if (quadTreeNode.getNodeType() != NodeType.GRAY) {
            if (quadTreeNode.getNodeType() == NodeType.WHITE) {
                return arrayList;
            }
            QuadTreeData[] quadTreeDataArray = quadTreeNode.getData();
            for (int i = 0; i < quadTreeNode.getCount(); ++i) {
                double d2;
                DirectPosition2D directPosition2D2 = quadTreeDataArray[i].getLatLon();
                GeodeticCalculator geodeticCalculator = this.calculator;
                synchronized (geodeticCalculator) {
                    this.calculator.setStartGeographicPoint(directPosition2D2.y, directPosition2D2.x);
                    this.calculator.setEndGeographicPoint(directPosition2D.y, directPosition2D.x);
                    d2 = this.calculator.getGeodesicDistance();
                }
                if (!(d2 <= d)) continue;
                arrayList.add(quadTreeDataArray[i]);
            }
            return arrayList;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY(), rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
        Rectangle2D.Double double_3 = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight() / 2.0, rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
        Rectangle2D.Double double_4 = new Rectangle2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0, rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
        if (double_.intersects(rectangle2D2)) {
            list = this.queryByPointRadius(directPosition2D, d, quadTreeNode.getChild(Quadrant.SW), double_, rectangle2D2);
            for (QuadTreeData quadTreeData : list) {
                arrayList.add(quadTreeData);
            }
        }
        if (double_2.intersects(rectangle2D2)) {
            list = this.queryByPointRadius(directPosition2D, d, quadTreeNode.getChild(Quadrant.SE), double_2, rectangle2D2);
            for (QuadTreeData quadTreeData : list) {
                arrayList.add(quadTreeData);
            }
        }
        if (double_3.intersects(rectangle2D2)) {
            list = this.queryByPointRadius(directPosition2D, d, quadTreeNode.getChild(Quadrant.NW), double_3, rectangle2D2);
            for (QuadTreeData quadTreeData : list) {
                arrayList.add(quadTreeData);
            }
        }
        if (double_4.intersects(rectangle2D2)) {
            list = this.queryByPointRadius(directPosition2D, d, quadTreeNode.getChild(Quadrant.NE), double_4, rectangle2D2);
            for (QuadTreeData quadTreeData : list) {
                arrayList.add(quadTreeData);
            }
        }
        return arrayList;
    }

    public List<QuadTreeData> queryByBoundingBox(Envelope2D envelope2D) {
        Rectangle2D.Double[] doubleArray = envelope2D.toRectangles();
        for (Rectangle2D.Double object : doubleArray) {
            object.x += 180.0;
            object.y += 90.0;
        }
        if (doubleArray.length == 1) {
            return this.queryByBoundingBox(doubleArray[0]);
        }
        if (doubleArray.length == 2) {
            List<QuadTreeData> list = this.queryByBoundingBox(doubleArray[0]);
            List<QuadTreeData> list2 = this.queryByBoundingBox(doubleArray[1]);
            for (QuadTreeData quadTreeData : list2) {
                if (list.contains(quadTreeData)) continue;
                list.add(quadTreeData);
            }
            return list;
        }
        return null;
    }

    private List<QuadTreeData> queryByBoundingBox(Rectangle2D rectangle2D) {
        return this.queryByBoundingBox(this.root, new Rectangle2D.Double(0.0, 0.0, 360.0, 180.0), rectangle2D);
    }

    private List<QuadTreeData> queryByBoundingBox(QuadTreeNode quadTreeNode, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        List<QuadTreeData> list;
        ArrayList<QuadTreeData> arrayList = new ArrayList<QuadTreeData>();
        if (quadTreeNode == null) {
            return arrayList;
        }
        if (quadTreeNode.getNodeType() != NodeType.GRAY) {
            if (quadTreeNode.getNodeType() == NodeType.WHITE) {
                return arrayList;
            }
            QuadTreeData[] quadTreeDataArray = quadTreeNode.getData();
            for (int i = 0; i < quadTreeNode.getCount(); ++i) {
                if (!rectangle2D2.contains(quadTreeDataArray[i].getX(), quadTreeDataArray[i].getY())) continue;
                arrayList.add(quadTreeDataArray[i]);
            }
            return arrayList;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY(), rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
        Rectangle2D.Double double_3 = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight() / 2.0, rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
        Rectangle2D.Double double_4 = new Rectangle2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0, rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
        if (double_.intersects(rectangle2D2)) {
            list = this.queryByBoundingBox(quadTreeNode.getChild(Quadrant.SW), double_, rectangle2D2);
            for (QuadTreeData quadTreeData : list) {
                arrayList.add(quadTreeData);
            }
        }
        if (double_2.intersects(rectangle2D2)) {
            list = this.queryByBoundingBox(quadTreeNode.getChild(Quadrant.SE), double_2, rectangle2D2);
            for (QuadTreeData quadTreeData : list) {
                arrayList.add(quadTreeData);
            }
        }
        if (double_3.intersects(rectangle2D2)) {
            list = this.queryByBoundingBox(quadTreeNode.getChild(Quadrant.NW), double_3, rectangle2D2);
            for (QuadTreeData quadTreeData : list) {
                arrayList.add(quadTreeData);
            }
        }
        if (double_4.intersects(rectangle2D2)) {
            list = this.queryByBoundingBox(quadTreeNode.getChild(Quadrant.NE), double_4, rectangle2D2);
            for (QuadTreeData quadTreeData : list) {
                arrayList.add(quadTreeData);
            }
        }
        return arrayList;
    }

    public int size() {
        return this.size;
    }

    final QuadTreeNode getRoot() {
        return this.root;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setNodeSize(int n) {
        this.nodeSize = n;
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getDepth() {
        return this.maxDepth;
    }

    public void setCapacity(int n) {
        this.capacity = n;
    }

    public void setDepth(int n) {
        this.maxDepth = n;
    }
}

