/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168;

import java.util.HashMap;
import java.util.Map;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.pc.api.LifeCyclePhase;
import org.gatein.pc.portlet.container.PortletApplication;
import org.gatein.pc.portlet.container.PortletFilterContext;
import org.gatein.pc.portlet.container.object.PortletFilterObject;
import org.gatein.pc.portlet.impl.info.ContainerFilterInfo;
import org.gatein.pc.portlet.impl.jsr168.PortletApplicationImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletContextImpl;

public class PortletFilterImpl
implements PortletFilterObject {
    private static final Map<Class<? extends PortletFilter>, LifeCyclePhase> typeToPhase = new HashMap<Class<? extends PortletFilter>, LifeCyclePhase>();
    private final Log log;
    private final ContainerFilterInfo info;
    private PortletFilterContext context;
    private PortletApplicationImpl application;
    private PortletApplicationImpl.FilterLifecycle lifeCycle;

    public PortletFilterImpl(ContainerFilterInfo info) {
        this.info = info;
        this.log = ExoLogger.getLogger(PortletFilterImpl.class);
    }

    public <T> T instance(Class<T> type) {
        LifeCyclePhase phase = typeToPhase.get(type);
        if (this.info.getPhases().contains(phase) && type.isInstance(this.lifeCycle.getInstance())) {
            return type.cast(this.lifeCycle.getInstance());
        }
        return null;
    }

    public ContainerFilterInfo getInfo() {
        return this.info;
    }

    @Override
    public String getId() {
        return this.info.getName();
    }

    @Override
    public void setPortletApplication(PortletApplication application) {
        this.application = (PortletApplicationImpl)application;
    }

    @Override
    public PortletApplication getPortletApplication() {
        return this.application;
    }

    @Override
    public void setContext(PortletFilterContext context) {
        this.context = context;
    }

    @Override
    public PortletFilterContext getContext() {
        return this.context;
    }

    @Override
    public void create() throws Exception {
        PortletContextImpl portletContext = this.application.portletContext;
        String className = this.info.getClassName();
        ClassLoader classLoader = this.application.getContext().getClassLoader();
        this.lifeCycle = new PortletApplicationImpl.FilterLifecycle(this.log, classLoader, className, "filter", this.info, portletContext);
    }

    @Override
    public void start() throws Exception {
        this.lifeCycle.create();
    }

    @Override
    public void stop() {
        this.lifeCycle.destroy();
    }

    @Override
    public void destroy() {
        this.lifeCycle = null;
    }

    static {
        typeToPhase.put(ActionFilter.class, LifeCyclePhase.ACTION);
        typeToPhase.put(EventFilter.class, LifeCyclePhase.EVENT);
        typeToPhase.put(RenderFilter.class, LifeCyclePhase.RENDER);
        typeToPhase.put(ResourceFilter.class, LifeCyclePhase.RESOURCE);
    }
}

