/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.type.StructuredType;

public class PDFAIdentificationValidation {
    public List<ValidationResult.ValidationError> validatePDFAIdentifer(XMPMetadata metadata) throws ValidationException {
        ArrayList<ValidationResult.ValidationError> ve = new ArrayList<ValidationResult.ValidationError>();
        PDFAIdentificationSchema id = metadata.getPDFIdentificationSchema();
        if (id == null) {
            ve.add(new ValidationResult.ValidationError("7.11", "PDF/A identification schema " + PDFAIdentificationSchema.class.getAnnotation(StructuredType.class).namespace() + " is missing"));
            return ve;
        }
        StructuredType stBasic = XMPBasicSchema.class.getAnnotation(StructuredType.class);
        StructuredType stPdfaIdent = PDFAIdentificationSchema.class.getAnnotation(StructuredType.class);
        if (!id.getPrefix().equals(stPdfaIdent.preferedPrefix())) {
            if (metadata.getSchema(stPdfaIdent.preferedPrefix(), stBasic.namespace()) == null) {
                ve.add(this.unexpectedPrefixFoundError(id.getPrefix(), stPdfaIdent.preferedPrefix(), PDFAIdentificationSchema.class.getName()));
            } else {
                id = (PDFAIdentificationSchema)metadata.getSchema(stPdfaIdent.preferedPrefix(), stPdfaIdent.namespace());
            }
        }
        this.checkConformanceLevel(ve, id.getConformance());
        this.checkPartNumber(ve, id.getPart() == null ? -1 : id.getPart());
        return ve;
    }

    protected ValidationResult.ValidationError unexpectedPrefixFoundError(String prefFound, String prefExpected, String schema) {
        StringBuilder sb = new StringBuilder(80);
        sb.append(schema).append(" found but prefix used is '").append(prefFound).append("', prefix '").append(prefExpected).append("' is expected.");
        return new ValidationResult.ValidationError("7.4.2", sb.toString());
    }

    protected void checkConformanceLevel(List<ValidationResult.ValidationError> ve, String value) {
        if (value == null || !value.equals("A") && !value.equals("B")) {
            ve.add(new ValidationResult.ValidationError("7.11.1"));
        }
    }

    protected void checkPartNumber(List<ValidationResult.ValidationError> ve, int value) {
        if (value != 1) {
            ve.add(new ValidationResult.ValidationError("7.11.2"));
        }
    }
}

