/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Optional;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.event.WarningEvent;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;

public class AbstractResource
extends StoreListeners
implements Resource {
    private Metadata metadata;

    public AbstractResource(StoreListeners storeListeners) {
        super(storeListeners, null);
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return Optional.empty();
    }

    public Optional<Envelope> getEnvelope() throws DataStoreException {
        return Optional.empty();
    }

    @Override
    public final synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            MetadataBuilder metadataBuilder = new MetadataBuilder();
            this.createMetadata(metadataBuilder);
            this.metadata = metadataBuilder.build(true);
        }
        return this.metadata;
    }

    protected void createMetadata(MetadataBuilder metadataBuilder) throws DataStoreException {
        this.getIdentifier().ifPresent(genericName -> metadataBuilder.addTitle((CharSequence)genericName.toInternationalString()));
        this.getEnvelope().ifPresent(envelope -> {
            try {
                metadataBuilder.addExtent((Envelope)envelope);
            }
            catch (UnsupportedOperationException | TransformException throwable) {
                this.warning((Exception)throwable);
            }
        });
    }

    protected synchronized void clearCache() {
        this.metadata = null;
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        if (storeListener == null || clazz == null || clazz.isAssignableFrom(WarningEvent.class)) {
            super.addListener(clazz, storeListener);
        }
    }
}

