/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import javax.imageio.stream.ImageInputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.ChannelDataOutput;
import org.apache.sis.internal.storage.io.ChannelImageInputStream;
import org.apache.sis.internal.storage.io.ChannelImageOutputStream;
import org.apache.sis.internal.storage.io.InputStreamAdapter;
import org.apache.sis.internal.storage.io.OutputStreamAdapter;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class IOUtilities
extends Static {
    private IOUtilities() {
    }

    public static String filename(Object object) {
        return IOUtilities.part(object, false);
    }

    public static String extension(Object object) {
        return IOUtilities.part(object, true);
    }

    private static String part(Object object, boolean bl) {
        String string;
        int n = 0;
        if (object instanceof File) {
            string = ((File)object).getName();
        } else if (object instanceof Path) {
            string = ((Path)object).getFileName().toString();
        } else {
            int n2 = 47;
            if (object instanceof URL) {
                string = ((URL)object).getPath();
            } else if (object instanceof URI) {
                URI uRI = (URI)object;
                string = uRI.isOpaque() ? uRI.getSchemeSpecificPart() : uRI.getPath();
            } else if (object instanceof CharSequence) {
                string = object.toString();
                n2 = File.separatorChar;
            } else {
                return null;
            }
            n = string.lastIndexOf(47) + 1;
            if (n2 != 47) {
                n = Math.max(n, CharSequences.lastIndexOf((CharSequence)string, (int)n2, (int)n, (int)string.length()) + 1);
            }
        }
        if (bl && (n = CharSequences.lastIndexOf((CharSequence)string, (int)46, (int)n, (int)string.length()) + 1) <= 1) {
            return "";
        }
        return string.substring(n);
    }

    public static String toString(Object object) {
        if (object instanceof CharSequence || object instanceof Path || object instanceof URL || object instanceof URI) {
            return object.toString();
        }
        if (object instanceof File) {
            return ((File)object).getPath();
        }
        return null;
    }

    public static String filenameWithoutExtension(String string) {
        if (string != null) {
            int n;
            int n2 = string.lastIndexOf(File.separatorChar);
            if (n2 < 0 && File.separatorChar != '/') {
                n2 = string.lastIndexOf(47);
            }
            if ((n = string.lastIndexOf(46)) <= ++n2) {
                n = string.length();
            }
            string = string.substring(n2, n);
        }
        return string;
    }

    public static String encodeURI(String string) {
        int n;
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = null;
        int n2 = string.length();
        for (int i = 0; i < n2; i += n) {
            int n3 = string.codePointAt(i);
            n = Character.charCount(n3);
            if (!Character.isSpaceChar(n3) && !Character.isISOControl(n3) && n3 != 37) {
                if (stringBuilder == null) continue;
                stringBuilder.appendCodePoint(n3);
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(string);
                stringBuilder.setLength(i);
            }
            for (byte by : string.substring(i, i + n).getBytes(StandardCharsets.UTF_8)) {
                stringBuilder.append('%');
                String string2 = Integer.toHexString(Byte.toUnsignedInt(by)).toUpperCase(Locale.ROOT);
                if (string2.length() < 2) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string2);
            }
        }
        return stringBuilder != null ? stringBuilder.toString() : string;
    }

    public static URI toURI(URL uRL, String string) throws IOException {
        if (uRL == null) {
            return null;
        }
        String string2 = uRL.toExternalForm();
        if (string != null) {
            string2 = URLDecoder.decode(string2, string);
        }
        string2 = IOUtilities.encodeURI(string2);
        try {
            return new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (MalformedURLException)new MalformedURLException(Exceptions.formatChainedMessages(null, (String)Errors.format((short)45, (Object)"URL", (Object)string2), (Throwable)uRISyntaxException)).initCause(uRISyntaxException);
        }
    }

    public static File toFile(URL uRL, String string) throws IOException {
        if (uRL == null) {
            return null;
        }
        URI uRI = IOUtilities.toURI(uRL, string);
        try {
            return new File(uRI);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(Exceptions.formatChainedMessages(null, (String)Errors.format((short)45, (Object)"URL", (Object)uRL), (Throwable)illegalArgumentException), illegalArgumentException);
        }
    }

    public static Path toPath(URL uRL, String string) throws IOException {
        if (uRL == null) {
            return null;
        }
        URI uRI = IOUtilities.toURI(uRL, string);
        try {
            return Paths.get(uRI);
        }
        catch (IllegalArgumentException | FileSystemNotFoundException runtimeException) {
            IOException iOException;
            String string2 = Exceptions.formatChainedMessages(null, (String)Errors.format((short)45, (Object)"URL", (Object)uRL), (Throwable)runtimeException);
            if (runtimeException instanceof IllegalArgumentException) {
                iOException = new MalformedURLException(string2);
                iOException.initCause(runtimeException);
            } else {
                iOException = new IOException(string2, runtimeException);
            }
            throw iOException;
        }
    }

    public static Object toFileOrURL(String string, String string2) throws IOException {
        int n;
        if (string == null) {
            return null;
        }
        if (string.indexOf(63) < 0 && string.indexOf(35) < 0 && ((n = string.indexOf(58)) < 0 || n == 1 && Character.isLetter(string.charAt(0)) && !string.regionMatches(2, "//", 0, 2))) {
            return new File(string);
        }
        URL uRL = new URL(string);
        String string3 = uRL.getProtocol();
        if (string3 != null && string3.equalsIgnoreCase("file")) {
            return IOUtilities.toFile(uRL, string2);
        }
        return uRL;
    }

    public static InputStream toInputStream(AutoCloseable autoCloseable) throws IOException {
        if (autoCloseable != null) {
            if (autoCloseable instanceof InputStream) {
                return (InputStream)autoCloseable;
            }
            if (autoCloseable instanceof OutputStreamAdapter) {
                autoCloseable = ((OutputStreamAdapter)autoCloseable).output;
            }
            if (autoCloseable instanceof ChannelDataOutput) {
                ChannelDataOutput channelDataOutput = (ChannelDataOutput)((Object)autoCloseable);
                if (channelDataOutput.channel instanceof ReadableByteChannel) {
                    autoCloseable = new ChannelImageInputStream(channelDataOutput.filename, (ReadableByteChannel)((Object)channelDataOutput.channel), channelDataOutput.buffer, true);
                }
            }
            if (autoCloseable instanceof ImageInputStream) {
                return new InputStreamAdapter((ImageInputStream)autoCloseable);
            }
        }
        return null;
    }

    public static OutputStream toOutputStream(AutoCloseable autoCloseable) throws IOException {
        if (autoCloseable != null) {
            if (autoCloseable instanceof OutputStream) {
                return (OutputStream)autoCloseable;
            }
            if (autoCloseable instanceof InputStreamAdapter) {
                autoCloseable = ((InputStreamAdapter)autoCloseable).input;
            }
            if (autoCloseable instanceof ChannelDataInput) {
                ChannelDataInput channelDataInput = (ChannelDataInput)((Object)autoCloseable);
                if (channelDataInput.channel instanceof WritableByteChannel) {
                    autoCloseable = new ChannelImageOutputStream(channelDataInput.filename, (WritableByteChannel)((Object)channelDataInput.channel), channelDataInput.buffer);
                }
            }
            if (autoCloseable instanceof ChannelImageOutputStream) {
                return new OutputStreamAdapter((ChannelImageOutputStream)autoCloseable);
            }
        }
        return null;
    }

    public static boolean truncate(AutoCloseable autoCloseable) throws IOException {
        if (autoCloseable instanceof OutputStreamAdapter) {
            autoCloseable = ((OutputStreamAdapter)autoCloseable).output;
        }
        if (autoCloseable instanceof ChannelDataOutput) {
            autoCloseable = ((ChannelDataOutput)((Object)autoCloseable)).channel;
        }
        if (autoCloseable instanceof SeekableByteChannel) {
            SeekableByteChannel seekableByteChannel = (SeekableByteChannel)autoCloseable;
            seekableByteChannel.truncate(seekableByteChannel.position());
            return true;
        }
        return false;
    }

    public static boolean isWrite(OpenOption[] openOptionArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (openOptionArray != null) {
            block5: for (OpenOption openOption : openOptionArray) {
                if (!(openOption instanceof StandardOpenOption)) continue;
                switch ((StandardOpenOption)openOption) {
                    case READ: {
                        bl = true;
                        continue block5;
                    }
                    case WRITE: {
                        bl2 = true;
                        continue block5;
                    }
                    case CREATE_NEW: 
                    case TRUNCATE_EXISTING: {
                        bl3 = true;
                    }
                }
            }
        }
        return bl2 & (!bl | bl3);
    }

    public static int readCodePoint(Reader reader) throws IOException {
        int n = reader.read();
        while (n >= 55296 && n <= 56319) {
            int n2 = reader.read();
            if (n2 >= 56320 && n2 <= 57343) {
                n = Character.toCodePoint((char)n, (char)n2);
                break;
            }
            n = n2;
        }
        return n;
    }

    public static String canNotReadFile(Locale locale, String string, String string2, Object object) {
        Object[] objectArray = IOUtilities.errorMessageParameters(string, string2, object);
        return Resources.forLocale(locale).getString(IOUtilities.errorMessageKey(objectArray), objectArray);
    }

    public static short errorMessageKey(Object[] objectArray) {
        return (short)(objectArray.length == 2 ? 1 : (objectArray.length == 3 ? 2 : 3));
    }

    public static Object[] errorMessageParameters(String string, String string2, Object object) {
        Object[] objectArray;
        int n = 0;
        int n2 = 0;
        if (object instanceof XMLStreamReader) {
            objectArray = ((XMLStreamReader)object).getLocation();
            n = objectArray.getLineNumber() + 1;
            n2 = objectArray.getColumnNumber() + 1;
        } else if (object instanceof LineNumberReader) {
            n = ((LineNumberReader)object).getLineNumber();
        }
        objectArray = new Object[n == 0 ? 2 : (n2 == 0 ? 3 : 4)];
        switch (objectArray.length) {
            default: {
                objectArray[3] = n2;
            }
            case 3: {
                objectArray[2] = n;
            }
            case 2: {
                objectArray[1] = string2;
            }
            case 1: {
                objectArray[0] = string;
            }
            case 0: 
        }
        return objectArray;
    }
}

