/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.cached;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.addons.gamification.entities.domain.configuration.RuleEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.CacheKey;
import org.exoplatform.addons.gamification.service.dto.configuration.Challenge;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.storage.RuleStorage;
import org.exoplatform.addons.gamification.storage.dao.RuleDAO;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class RuleCachedStorage
extends RuleStorage {
    private static final int RULE_ID_CONTEXT = 0;
    private static final int RULE_TITLE_CONTEXT = 1;
    private static final int ALL_RULE_CONTEXT = 2;
    private static final int CHALLENGE_USER_CONTEXT = 3;
    private static final String RULE_CACHE_NAME = "gamification.rule";
    private FutureExoCache<Serializable, Object, CacheKey> ruleFutureCache;

    public RuleCachedStorage(RuleDAO ruleDAO, CacheService cacheService) {
        super(ruleDAO);
        ExoCache ruleCache = cacheService.getCacheInstance(RULE_CACHE_NAME);
        Loader<Serializable, Object, CacheKey> ruleLoader = new Loader<Serializable, Object, CacheKey>(){

            public Object retrieve(CacheKey context, Serializable key) throws Exception {
                if (context.getContext() == 0) {
                    return RuleCachedStorage.super.findRuleById(context.getId());
                }
                if (context.getContext() == 1) {
                    return RuleCachedStorage.super.findRuleByTitle(context.getTitle());
                }
                if (context.getContext() == 2) {
                    return RuleCachedStorage.super.findAllRules();
                }
                if (context.getContext() == 3) {
                    return RuleCachedStorage.super.findAllChallengesByUser(context.getOffset(), context.getLimit(), context.getIds());
                }
                throw new IllegalStateException("Unknown context id " + context);
            }
        };
        this.ruleFutureCache = new FutureExoCache((Loader)ruleLoader, ruleCache);
    }

    @Override
    public RuleDTO saveRule(RuleDTO ruleDTO) {
        try {
            RuleDTO ruleDTO2 = ruleDTO = super.saveRule(ruleDTO);
            return ruleDTO2;
        }
        finally {
            this.ruleFutureCache.remove((Serializable)ruleDTO.getId());
            this.ruleFutureCache.remove((Serializable)((Object)ruleDTO.getTitle()));
            this.ruleFutureCache.remove((Serializable)Integer.valueOf(2));
        }
    }

    @Override
    public RuleDTO findRuleById(Long id) {
        return (RuleDTO)this.ruleFutureCache.get((Object)new CacheKey((Integer)0, id), (Object)id);
    }

    @Override
    public RuleDTO findRuleByTitle(String title) {
        return (RuleDTO)this.ruleFutureCache.get((Object)new CacheKey((Integer)1, title), (Object)title);
    }

    @Override
    public List<RuleDTO> findAllRules() {
        return (List)this.ruleFutureCache.get((Object)new CacheKey((Integer)2, 0L), (Object)2);
    }

    @Override
    public void deleteRule(RuleDTO rule) {
        try {
            super.deleteRule(rule);
        }
        finally {
            this.ruleFutureCache.remove((Serializable)rule.getId());
            this.ruleFutureCache.remove((Serializable)((Object)rule.getTitle()));
            this.ruleFutureCache.remove((Serializable)Integer.valueOf(2));
        }
    }

    @Override
    public List<RuleEntity> findAllChallengesByUser(int offset, int limit, List<Long> ids) {
        return (List)this.ruleFutureCache.get((Object)new CacheKey(3, ids, offset, limit), (Object)(3 + offset + Utils.getCurrentUser()));
    }

    @Override
    public Challenge saveChallenge(Challenge challenge, String username) {
        challenge = super.saveChallenge(challenge, username);
        this.ruleFutureCache.clear();
        return challenge;
    }

    @Override
    public void deleteChallenge(Challenge challenge) {
        super.deleteChallenge(challenge);
        this.ruleFutureCache.clear();
    }

    @Override
    public void clearCache() {
        this.ruleFutureCache.clear();
    }
}

