/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.Comparator;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.importer.Status;
import org.exoplatform.portal.pom.data.ModelChange;

public interface DataStorage {
    public static final String PAGE_CREATED = "org.exoplatform.portal.config.DataStorage.pageCreated".intern();
    public static final String PAGE_REMOVED = "org.exoplatform.portal.config.DataStorage.pageRemoved".intern();
    public static final String PAGE_UPDATED = "org.exoplatform.portal.config.DataStorage.pageUpdated".intern();
    public static final String PORTAL_CONFIG_CREATED = "org.exoplatform.portal.config.DataStorage.portalConfigCreated".intern();
    public static final String PORTAL_CONFIG_REMOVED = "org.exoplatform.portal.config.DataStorage.portalConfigRemoved".intern();
    public static final String PORTAL_CONFIG_UPDATED = "org.exoplatform.portal.config.DataStorage.portalConfigUpdated".intern();

    public void create(PortalConfig var1) throws Exception;

    public void save(PortalConfig var1) throws Exception;

    public PortalConfig getPortalConfig(String var1) throws Exception;

    public PortalConfig getPortalConfig(String var1, String var2) throws Exception;

    public void remove(PortalConfig var1) throws Exception;

    public Page getPage(String var1) throws Exception;

    @Deprecated
    public Page clonePage(String var1, String var2, String var3, String var4);

    @Deprecated
    public void remove(Page var1);

    @Deprecated
    public void create(Page var1);

    public List<ModelChange> save(Page var1) throws Exception;

    public <S> String getId(ApplicationState<S> var1) throws Exception;

    public <S> S load(ApplicationState<S> var1, ApplicationType<S> var2) throws Exception;

    public <S> ApplicationState<S> save(ApplicationState<S> var1, S var2) throws Exception;

    public <T> LazyPageList<T> find(Query<T> var1) throws Exception;

    public <T> LazyPageList<T> find(Query<T> var1, Comparator<T> var2) throws Exception;

    public <T> ListAccess<T> find2(Query<T> var1) throws Exception;

    public <T> ListAccess<T> find2(Query<T> var1, Comparator<T> var2) throws Exception;

    public Container getSharedLayout(String var1) throws Exception;

    public void save() throws Exception;

    public List<String> getAllPortalNames() throws Exception;

    public List<String> getAllGroupNames() throws Exception;

    @Deprecated
    public String[] getSiteInfo(String var1) throws Exception;

    public <S> Application<S> getApplicationModel(String var1) throws Exception;

    @Deprecated
    public <A> A adapt(ModelObject var1, Class<A> var2);

    @Deprecated
    public <A> A adapt(ModelObject var1, Class<A> var2, boolean var3);

    default public Status getImportStatus() {
        throw new UnsupportedOperationException();
    }

    default public void saveImportStatus(Status status) {
        throw new UnsupportedOperationException();
    }
}

